/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities.bolloom;

import endergeticexpansion.api.entity.util.EntityItemStackHelper;
import endergeticexpansion.common.capability.balloons.BalloonProvider;
import endergeticexpansion.common.entities.bolloom.EntityBolloomKnot;
import endergeticexpansion.core.registry.EEBlocks;
import endergeticexpansion.core.registry.EEEntities;
import endergeticexpansion.core.registry.EEItems;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityBolloomBalloon
extends Entity {
    private static final DataParameter<Float> ORIGINAL_X = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ORIGINAL_Z = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ORIGINAL_Y = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ANGLE = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> DESIRED_ANGLE = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SWAY = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> UNTIED = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACHED_ENTITY = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> ATTACHED_ENTITY_UNIQUE_ID = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> KNOT_UNIQUE_ID = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<BlockPos> FENCE_POS = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> TICKSEXISTED = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> COLOR = EntityDataManager.func_187226_a(EntityBolloomBalloon.class, (IDataSerializer)DataSerializers.field_187191_a);
    public float prevVineAngle;
    public float prevAngle;

    public EntityBolloomBalloon(EntityType<? extends EntityBolloomBalloon> entityType, World world) {
        super(entityType, world);
    }

    public EntityBolloomBalloon(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this((EntityType<? extends EntityBolloomBalloon>)((EntityType)EEEntities.BOLLOOM_BALLOON.get()), world);
    }

    public EntityBolloomBalloon(World world, UUID ownerKnot, BlockPos pos, float offset) {
        this((EntityType<? extends EntityBolloomBalloon>)((EntityType)EEEntities.BOLLOOM_BALLOON.get()), world);
        float xOffset = this.field_70146_Z.nextBoolean() ? -offset : offset;
        float zOffset = this.field_70146_Z.nextBoolean() ? -offset : offset;
        this.func_70107_b((float)pos.func_177958_n() + 0.5f + xOffset, pos.func_177956_o() + 3, (float)pos.func_177952_p() + 0.5f + zOffset);
        this.setOriginalPos((float)pos.func_177958_n() + 0.5f + xOffset, pos.func_177956_o() + 3, (float)pos.func_177952_p() + 0.5f + zOffset);
        this.func_184212_Q().func_187227_b(FENCE_POS, (Object)pos);
        this.setKnotId(ownerKnot);
        this.field_70169_q = (float)pos.func_177958_n() + 0.5f + xOffset;
        this.field_70167_r = pos.func_177956_o() + 3;
        this.field_70166_s = (float)pos.func_177952_p() + 0.5f + zOffset;
    }

    public EntityBolloomBalloon(World world, BlockPos pos) {
        this((EntityType<? extends EntityBolloomBalloon>)((EntityType)EEEntities.BOLLOOM_BALLOON.get()), world);
        this.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        this.setOriginalPos((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        this.setUntied();
        this.func_184212_Q().func_187227_b(DESIRED_ANGLE, (Object)Float.valueOf((float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI)));
        this.setAngle((float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI));
        this.field_70169_q = (float)pos.func_177958_n() + 0.5f;
        this.field_70167_r = pos.func_177956_o();
        this.field_70166_s = (float)pos.func_177952_p() + 0.5f;
    }

    public EntityBolloomBalloon(World world, Entity entity) {
        this((EntityType<? extends EntityBolloomBalloon>)((EntityType)EEEntities.BOLLOOM_BALLOON.get()), world);
        this.func_70107_b(entity.field_70165_t, entity.field_70163_u + 2.0 + (double)entity.func_70047_e(), entity.field_70161_v);
        this.setAttachedEntityId(entity.func_110124_au());
        if (!world.field_72995_K) {
            this.setOriginalPos((float)entity.field_70165_t, (float)entity.field_70163_u + 2.0f + entity.func_70047_e(), (float)entity.field_70161_v);
        }
        this.func_184212_Q().func_187227_b(ATTACHED_ENTITY, (Object)true);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.prevVineAngle = this.getVineAngle();
        this.prevAngle = this.getAngle();
        if (!((Boolean)this.func_184212_Q().func_187225_a(ATTACHED_ENTITY)).booleanValue() && this.func_130014_f_().isAreaLoaded(this.getFencePos(), 1) && !this.isUntied() && !this.func_130014_f_().func_180495_p(this.getFencePos()).func_177230_c().func_203417_a(BlockTags.field_219748_G)) {
            if (!this.func_130014_f_().field_72995_K && this.getKnot() != null) {
                ((EntityBolloomKnot)this.getKnot()).setBalloonsTied(((EntityBolloomKnot)this.getKnot()).getBalloonsTied() - 1);
            }
            this.setUntied();
        }
        if (this.field_70170_p.isAreaLoaded(this.func_180425_c(), 1)) {
            this.field_70180_af.func_187227_b(SWAY, (Object)Float.valueOf((float)Math.sin(0.06283185307179587 * (double)this.getTicksExisted()) * 0.5f));
        }
        if (!this.field_70170_p.field_72995_K) {
            if (((Boolean)this.func_184212_Q().func_187225_a(ATTACHED_ENTITY)).booleanValue() && this.getAttachedEntity() != null) {
                this.setOriginalPos((float)this.getAttachedEntity().field_70165_t, (float)this.getAttachedEntity().field_70163_u + 2.0f + this.getAttachedEntity().func_70047_e(), (float)this.getAttachedEntity().field_70161_v);
                this.field_70169_q = this.getAttachedEntity().field_70169_q;
                this.field_70167_r = this.getAttachedEntity().field_70167_r + 2.0 + (double)this.getAttachedEntity().func_70047_e();
                this.field_70166_s = this.getAttachedEntity().field_70166_s;
            }
            if (this.getTicksExisted() % 45 == 0) {
                this.func_184212_Q().func_187227_b(DESIRED_ANGLE, (Object)Float.valueOf((float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI)));
            }
            if (this.field_70163_u > 254.0 && this.isUntied()) {
                this.onBroken(this);
                this.func_70106_y();
            }
            float dangle = this.getDesiredAngle() - this.getAngle();
            while ((double)dangle > Math.PI) {
                dangle = (float)((double)dangle - Math.PI * 2);
            }
            while ((double)dangle <= -Math.PI) {
                dangle = (float)((double)dangle + Math.PI * 2);
            }
            if (Math.abs(dangle) <= 0.1f) {
                this.setAngle(this.getAngle() + dangle);
            } else if (dangle > 0.0f) {
                this.setAngle(this.getAngle() + 0.03f);
            } else {
                this.setAngle(this.getAngle() - 0.03f);
            }
        }
        if (this.field_70170_p.isAreaLoaded(this.func_180425_c(), 1)) {
            if (!this.isUntied()) {
                this.func_70107_b((double)((Float)this.func_184212_Q().func_187225_a(ORIGINAL_X)).floatValue() + (double)((Float)this.field_70180_af.func_187225_a(SWAY)).floatValue() * Math.sin(-this.getAngle()), this.getSetY(), (double)((Float)this.func_184212_Q().func_187225_a(ORIGINAL_Z)).floatValue() + (double)((Float)this.field_70180_af.func_187225_a(SWAY)).floatValue() * Math.cos(-this.getAngle()));
            } else {
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213293_j(Math.sin(this.getAngle()) * Math.cos(this.getAngle()) * (double)0.05f, Math.toRadians(4.0), Math.cos(this.getVineAngle()) * Math.cos(-this.getAngle()) * (double)0.05f);
            }
        }
        if (!((Boolean)this.func_184212_Q().func_187225_a(ATTACHED_ENTITY)).booleanValue() && this.checkForBlocksDown()) {
            if (!this.func_130014_f_().field_72995_K && this.getKnot() != null && !this.isUntied()) {
                ((EntityBolloomKnot)this.getKnot()).setBalloonsTied(((EntityBolloomKnot)this.getKnot()).getBalloonsTied() - 1);
            }
            this.setUntied();
        }
        this.incrementTicksExisted();
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(KNOT_UNIQUE_ID, Optional.empty());
        this.func_184212_Q().func_187214_a(ATTACHED_ENTITY_UNIQUE_ID, Optional.empty());
        this.func_184212_Q().func_187214_a(ORIGINAL_X, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(ORIGINAL_Z, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(ORIGINAL_Y, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(FENCE_POS, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(UNTIED, (Object)false);
        this.func_184212_Q().func_187214_a(ATTACHED_ENTITY, (Object)false);
        this.func_184212_Q().func_187214_a(ANGLE, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(SWAY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(DESIRED_ANGLE, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(TICKSEXISTED, (Object)0);
        this.func_184212_Q().func_187214_a(COLOR, (Object)16);
    }

    protected void func_213281_b(CompoundNBT nbt) {
        if (this.getKnotId() != null) {
            nbt.func_186854_a("KnotUUID", this.getKnotId());
        }
        if (this.getAttachedEntityId() != null) {
            nbt.func_186854_a("AttachedEntityUUID", this.getAttachedEntityId());
        }
        nbt.func_74757_a("UNTIED", ((Boolean)this.func_184212_Q().func_187225_a(UNTIED)).booleanValue());
        nbt.func_74757_a("ATTACHED", ((Boolean)this.func_184212_Q().func_187225_a(ATTACHED_ENTITY)).booleanValue());
        nbt.func_74776_a("ORIGIN_X", ((Float)this.func_184212_Q().func_187225_a(ORIGINAL_X)).floatValue());
        nbt.func_74776_a("ORIGIN_Y", ((Float)this.func_184212_Q().func_187225_a(ORIGINAL_Y)).floatValue());
        nbt.func_74776_a("ORIGIN_Z", ((Float)this.func_184212_Q().func_187225_a(ORIGINAL_Z)).floatValue());
        nbt.func_74772_a("FENCE_POS", ((BlockPos)this.func_184212_Q().func_187225_a(FENCE_POS)).func_218275_a());
        nbt.func_74774_a("Color", ((Byte)this.field_70180_af.func_187225_a(COLOR)).byteValue());
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.setKnotId(nbt.func_186857_a("KnotUUID"));
        this.setAttachedEntityId(nbt.func_186857_a("AttachedEntityUUID"));
        this.func_184212_Q().func_187227_b(UNTIED, (Object)nbt.func_74767_n("UNTIED"));
        this.func_184212_Q().func_187227_b(ATTACHED_ENTITY, (Object)nbt.func_74767_n("ATTACHED"));
        this.func_184212_Q().func_187227_b(ORIGINAL_X, (Object)Float.valueOf(nbt.func_74760_g("ORIGIN_X")));
        this.func_184212_Q().func_187227_b(ORIGINAL_Y, (Object)Float.valueOf(nbt.func_74760_g("ORIGIN_Y")));
        this.func_184212_Q().func_187227_b(ORIGINAL_Z, (Object)Float.valueOf(nbt.func_74760_g("ORIGIN_Z")));
        this.func_184212_Q().func_187227_b(FENCE_POS, (Object)BlockPos.func_218283_e((long)nbt.func_74763_f("FENCE_POS")));
        this.field_70180_af.func_187227_b(COLOR, (Object)nbt.func_74771_c("Color"));
    }

    public boolean func_70067_L() {
        return true;
    }

    public void onBroken(@Nullable Entity brokenEntity) {
        this.func_184185_a(SoundEvents.field_211414_dn, 1.0f, 1.0f);
        if (this.getKnot() != null) {
            ((EntityBolloomKnot)this.getKnot()).setBalloonsTied(((EntityBolloomKnot)this.getKnot()).getBalloonsTied() - 1);
        }
        if (this.getAttachedEntity() != null) {
            this.getAttachedEntity().getCapability(BalloonProvider.BALLOON_CAP, null).ifPresent(balloons -> balloons.decrementBalloons(1));
        }
        this.doParticles();
    }

    public void func_174812_G() {
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getKnot() != null) {
                ((EntityBolloomKnot)this.getKnot()).setBalloonsTied(((EntityBolloomKnot)this.getKnot()).getBalloonsTied() - 1);
            }
            if (this.getAttachedEntity() != null) {
                this.getAttachedEntity().getCapability(BalloonProvider.BALLOON_CAP, null).ifPresent(balloons -> balloons.decrementBalloons(1));
            }
        }
        super.func_174812_G();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            this.onBroken(source.func_76346_g());
        }
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.func_190530_aW() && source != DamageSource.field_76380_i && source != DamageSource.field_191291_g;
    }

    public boolean func_85031_j(Entity entityIn) {
        return entityIn instanceof PlayerEntity ? this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)entityIn)), 0.0f) : false;
    }

    private void doParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, ((Block)EEBlocks.BOLLOOM_PARTICLE.get()).func_176223_P()), this.field_70165_t, this.field_70163_u + (double)this.func_213302_cg() / 1.5, this.field_70161_v, 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    public void applyMotionToAttachedEntity(Entity entity) {
        this.getAttachedEntity().getCapability(BalloonProvider.BALLOON_CAP, null).ifPresent(balloons -> {
            if (entity instanceof LivingEntity) {
                if (balloons.getBalloonsTied() == 1 && !entity.field_70122_E) {
                    entity.func_213317_d(entity.func_213322_ci().func_216372_d(1.0, 0.8, 1.0));
                    entity.field_70143_R = 0.0f;
                } else if (balloons.getBalloonsTied() == 2 && !entity.field_70122_E) {
                    entity.func_213317_d(entity.func_213322_ci().func_216372_d(1.0, 0.5, 1.0));
                    entity.field_70143_R = 0.0f;
                } else if (balloons.getBalloonsTied() == 3 || balloons.getBalloonsTied() == 4) {
                    // empty if block
                }
                entity.field_70143_R = 0.0f;
            }
        });
    }

    public static void addBalloonToEntity(Entity entity) {
        EntityBolloomBalloon balloon = new EntityBolloomBalloon(entity.func_130014_f_(), entity);
        entity.func_130014_f_().func_217376_c((Entity)balloon);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public DyeColor getColor() {
        Byte obyte = (Byte)this.field_70180_af.func_187225_a(COLOR);
        return obyte != 16 && obyte <= 15 ? DyeColor.func_196056_a((int)obyte.byteValue()) : null;
    }

    public void setColor(@Nullable DyeColor color) {
        if (color == null) {
            this.field_70180_af.func_187227_b(COLOR, (Object)16);
        } else {
            this.field_70180_af.func_187227_b(COLOR, (Object)((byte)color.func_196059_a()));
        }
    }

    @Nullable
    public Entity getKnot() {
        return ((ServerWorld)this.field_70170_p).func_217461_a(this.getKnotId());
    }

    @Nullable
    public Entity getAttachedEntity() {
        return ((ServerWorld)this.field_70170_p).func_217461_a(this.getAttachedEntityId());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getVineAnimation(float partialTicks) {
        return new float[]{MathHelper.func_219799_g((float)partialTicks, (float)this.prevVineAngle, (float)this.getVineAngle()), MathHelper.func_219799_g((float)partialTicks, (float)this.prevAngle, (float)this.getAngle())};
    }

    public boolean checkForBlocksDown() {
        for (int i = 0; i < 3; ++i) {
            BlockPos pos = this.getFencePos().func_177981_b(3).func_177979_c(i);
            if (!this.func_130014_f_().isAreaLoaded(pos, 1) || this.func_130014_f_().func_180495_p(pos).func_185904_a().func_76222_j() && this.func_130014_f_().func_180495_p(pos).func_177230_c() != Blocks.field_150353_l) continue;
            return true;
        }
        return false;
    }

    public final boolean func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() instanceof DyeItem && this.getColor() != ((DyeItem)itemstack.func_77973_b()).func_195962_g() && !this.field_70170_p.field_72995_K) {
            this.setColor(((DyeItem)itemstack.func_77973_b()).func_195962_g());
            EntityItemStackHelper.consumeItemFromStack(player, itemstack);
        }
        return super.func_184230_a(player, hand);
    }

    protected Vec3d func_213308_a(Vec3d pos) {
        return Vec3d.field_186680_a;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)EEItems.BOLLOOM_BALLOON.get());
    }

    @Nullable
    public UUID getKnotId() {
        return ((Optional)this.field_70180_af.func_187225_a(KNOT_UNIQUE_ID)).orElse(null);
    }

    public void setKnotId(@Nullable UUID knotUUID) {
        this.field_70180_af.func_187227_b(KNOT_UNIQUE_ID, Optional.ofNullable(knotUUID));
    }

    @Nullable
    public UUID getAttachedEntityId() {
        return ((Optional)this.field_70180_af.func_187225_a(ATTACHED_ENTITY_UNIQUE_ID)).orElse(null);
    }

    public void setAttachedEntityId(@Nullable UUID knotUUID) {
        this.field_70180_af.func_187227_b(ATTACHED_ENTITY_UNIQUE_ID, Optional.ofNullable(knotUUID));
    }

    public void setAngle(float degree) {
        this.func_184212_Q().func_187227_b(ANGLE, (Object)Float.valueOf(degree));
    }

    public float getAngle() {
        return ((Float)this.func_184212_Q().func_187225_a(ANGLE)).floatValue();
    }

    public float getDesiredAngle() {
        return ((Float)this.func_184212_Q().func_187225_a(DESIRED_ANGLE)).floatValue();
    }

    public float getVineAngle() {
        return (float)Math.atan(((Float)this.field_70180_af.func_187225_a(SWAY)).floatValue() / 2.0f);
    }

    public void setUntied() {
        this.func_184212_Q().func_187227_b(UNTIED, (Object)true);
    }

    public boolean isUntied() {
        return (Boolean)this.func_184212_Q().func_187225_a(UNTIED);
    }

    public float getSetY() {
        return ((Float)this.func_184212_Q().func_187225_a(ORIGINAL_Y)).floatValue();
    }

    public void setOriginalPos(float x, float y, float z) {
        this.func_184212_Q().func_187227_b(ORIGINAL_X, (Object)Float.valueOf(x));
        this.func_184212_Q().func_187227_b(ORIGINAL_Y, (Object)Float.valueOf(y));
        this.func_184212_Q().func_187227_b(ORIGINAL_Z, (Object)Float.valueOf(z));
    }

    public int getTicksExisted() {
        return (Integer)this.func_184212_Q().func_187225_a(TICKSEXISTED);
    }

    public void incrementTicksExisted() {
        this.func_184212_Q().func_187227_b(TICKSEXISTED, (Object)(this.getTicksExisted() + 1));
    }

    public BlockPos getFencePos() {
        return (BlockPos)this.func_184212_Q().func_187225_a(FENCE_POS);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70104_M() {
        return !this.field_70128_L;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    public AxisAlignedBB func_184177_bl() {
        return super.func_184177_bl().func_186662_g(5.0);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

