/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities.bolloom;

import endergeticexpansion.common.blocks.poise.BlockBolloomBud;
import endergeticexpansion.core.registry.EEBlocks;
import endergeticexpansion.core.registry.EEEntities;
import endergeticexpansion.core.registry.EEItems;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityBolloomFruit
extends Entity {
    private static final DataParameter<BlockPos> BUD_POS = EntityDataManager.func_187226_a(EntityBolloomFruit.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Float> ORIGINAL_X = EntityDataManager.func_187226_a(EntityBolloomFruit.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ORIGINAL_Z = EntityDataManager.func_187226_a(EntityBolloomFruit.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ORIGINAL_Y = EntityDataManager.func_187226_a(EntityBolloomFruit.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ANGLE = EntityDataManager.func_187226_a(EntityBolloomFruit.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> DESIRED_ANGLE = EntityDataManager.func_187226_a(EntityBolloomFruit.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SWAY = EntityDataManager.func_187226_a(EntityBolloomFruit.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> VINE_HEIGHT = EntityDataManager.func_187226_a(EntityBolloomFruit.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TICKS_EXISTED = EntityDataManager.func_187226_a(EntityBolloomFruit.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> UNTIED = EntityDataManager.func_187226_a(EntityBolloomFruit.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float prevVineAngle;
    public float prevAngle;

    public EntityBolloomFruit(EntityType<? extends EntityBolloomFruit> type, World world) {
        super((EntityType)EEEntities.BOLLOOM_FRUIT.get(), world);
        this.func_189654_d(true);
    }

    public EntityBolloomFruit(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this((EntityType<? extends EntityBolloomFruit>)((EntityType)EEEntities.BOLLOOM_FRUIT.get()), world);
    }

    public EntityBolloomFruit(World world, BlockPos budPos, BlockPos origin, int height, Direction direction) {
        this((EntityType<? extends EntityBolloomFruit>)((EntityType)EEEntities.BOLLOOM_FRUIT.get()), world);
        float xPos = (float)origin.func_177958_n() + 0.5f + (direction.func_176740_k() == Direction.Axis.Z ? 0.0f : -0.2f * (float)direction.func_176743_c().func_179524_a());
        float zPos = (float)origin.func_177952_p() + 0.5f + (direction.func_176740_k() == Direction.Axis.X ? 0.0f : -0.2f * (float)direction.func_176743_c().func_179524_a());
        float yPos = (float)origin.func_177956_o() + 1.15f;
        this.func_70107_b(xPos, yPos, zPos);
        this.setOriginalPositions(xPos, yPos, zPos);
        this.setOrigin(budPos);
        this.setVineHeight(height);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public void func_213281_b(CompoundNBT nbt) {
        nbt.func_74772_a("BudPosition", ((BlockPos)this.func_184212_Q().func_187225_a(BUD_POS)).func_218275_a());
        nbt.func_74757_a("Untied", this.isUntied());
        nbt.func_74776_a("OriginalPosX", this.getOriginalPos()[0]);
        nbt.func_74776_a("OriginalPosY", this.getOriginalPos()[1]);
        nbt.func_74776_a("OriginalPosZ", this.getOriginalPos()[2]);
        nbt.func_74768_a("VineHeight", this.getVineHeight());
    }

    public void func_70037_a(CompoundNBT nbt) {
        this.func_184212_Q().func_187227_b(BUD_POS, (Object)BlockPos.func_218283_e((long)nbt.func_74763_f("BudPosition")));
        this.setUntied(nbt.func_74767_n("Untied"));
        this.setOriginalPositions(nbt.func_74760_g("OriginalPosX"), nbt.func_74760_g("OriginalPosY"), nbt.func_74760_g("OriginalPosZ"));
        this.setVineHeight(nbt.func_74762_e("VineHeight"));
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ORIGINAL_X, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(ORIGINAL_Z, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(ORIGINAL_Y, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(ANGLE, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(SWAY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(DESIRED_ANGLE, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(VINE_HEIGHT, (Object)0);
        this.func_184212_Q().func_187214_a(BUD_POS, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(UNTIED, (Object)false);
        this.func_184212_Q().func_187214_a(TICKS_EXISTED, (Object)0);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.prevVineAngle = this.getVineAngle();
        this.prevAngle = this.getAngle();
        if (this.field_70170_p.isAreaLoaded(this.getOrigin(), 1)) {
            this.setSway((float)Math.sin(0.06283185307179587 * (double)this.getTicksExisted()) * 0.5f);
        }
        if (this.field_70170_p.isAreaLoaded(this.getOrigin(), 1)) {
            if (!this.isUntied()) {
                this.func_70107_b((double)this.getOriginalPos()[0] + (double)this.getSway() * Math.sin(-this.getAngle()), this.getOriginalY(), (double)this.getOriginalPos()[2] + (double)this.getSway() * Math.cos(-this.getAngle()));
            } else {
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213293_j(Math.sin(this.getAngle()) * Math.cos(this.getAngle()) * (double)0.05f, Math.toRadians(4.0), Math.cos(this.getVineAngle()) * Math.cos(-this.getAngle()) * (double)0.05f);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getTicksExisted() % 45 == 0) {
                this.setDesiredAngle((float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI));
            }
            if (this.field_70163_u >= (double)(this.field_70170_p.func_201675_m().getSeaLevel() * 2) && this.field_70146_Z.nextFloat() <= 0.1f && this.isUntied()) {
                this.func_70106_y();
            }
            float dangle = this.getDesiredAngle() - this.getAngle();
            while ((double)dangle > Math.PI) {
                dangle = (float)((double)dangle - Math.PI * 2);
            }
            while ((double)dangle <= -Math.PI) {
                dangle = (float)((double)dangle + Math.PI * 2);
            }
            if (Math.abs(dangle) <= 0.1f) {
                this.setAngle(this.getAngle() + dangle);
            } else if (dangle > 0.0f) {
                this.setAngle(this.getAngle() + 0.03f);
            } else {
                this.setAngle(this.getAngle() - 0.03f);
            }
        }
        if (this.field_70170_p.isAreaLoaded(this.getOrigin(), 1) && (this.func_130014_f_().func_180495_p(this.getOrigin()).func_177230_c() != EEBlocks.BOLLOOM_BUD.get() || !((Boolean)this.func_130014_f_().func_180495_p(this.getOrigin()).func_177229_b((IProperty)BlockBolloomBud.OPENED)).booleanValue())) {
            this.setUntied(true);
        }
        if (!this.isOpenPathBelowFruit()) {
            this.setUntied(true);
        }
        this.func_70066_B();
        this.incrementTicksExisted();
    }

    public boolean isOpenPathBelowFruit() {
        for (int i = 0; i < this.getVineHeight(); ++i) {
            BlockPos pos = this.func_180425_c().func_177979_c(i);
            if (!this.func_130014_f_().isAreaLoaded(pos, 1) || this.func_130014_f_().func_180495_p(pos).func_196958_f()) continue;
            return false;
        }
        return true;
    }

    private void doParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, ((Block)EEBlocks.BOLLOOM_PARTICLE.get()).func_176223_P()), this.field_70165_t, this.field_70163_u + (double)this.func_213302_cg() / 1.5, this.field_70161_v, 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    public float getOriginalY() {
        return ((Float)this.func_184212_Q().func_187225_a(ORIGINAL_Y)).floatValue();
    }

    public void setOriginalPositions(float x, float y, float z) {
        this.field_70180_af.func_187227_b(ORIGINAL_X, (Object)Float.valueOf(x));
        this.field_70180_af.func_187227_b(ORIGINAL_Y, (Object)Float.valueOf(y));
        this.field_70180_af.func_187227_b(ORIGINAL_Z, (Object)Float.valueOf(z));
    }

    public int getTicksExisted() {
        return (Integer)this.func_184212_Q().func_187225_a(TICKS_EXISTED);
    }

    public void setTicksExisted(int ticks) {
        this.func_184212_Q().func_187227_b(TICKS_EXISTED, (Object)ticks);
    }

    public void incrementTicksExisted() {
        this.func_184212_Q().func_187227_b(TICKS_EXISTED, (Object)(this.getTicksExisted() + 1));
    }

    public float getVineAngle() {
        return (float)Math.atan(this.getSway() / (float)this.getVineHeight());
    }

    public void setVineHeight(int height) {
        this.func_184212_Q().func_187227_b(VINE_HEIGHT, (Object)height);
    }

    public int getVineHeight() {
        return (Integer)this.func_184212_Q().func_187225_a(VINE_HEIGHT);
    }

    public void setSway(float degree) {
        this.func_184212_Q().func_187227_b(SWAY, (Object)Float.valueOf(degree));
    }

    public float getSway() {
        return ((Float)this.func_184212_Q().func_187225_a(SWAY)).floatValue();
    }

    public void setAngle(float degree) {
        this.func_184212_Q().func_187227_b(ANGLE, (Object)Float.valueOf(degree));
    }

    public float getAngle() {
        return ((Float)this.func_184212_Q().func_187225_a(ANGLE)).floatValue();
    }

    public void setDesiredAngle(float angle) {
        this.func_184212_Q().func_187227_b(DESIRED_ANGLE, (Object)Float.valueOf(angle));
    }

    public float getDesiredAngle() {
        return ((Float)this.func_184212_Q().func_187225_a(DESIRED_ANGLE)).floatValue();
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.func_184212_Q().func_187225_a(BUD_POS);
    }

    public void setOrigin(BlockPos budPos) {
        this.func_184212_Q().func_187227_b(BUD_POS, (Object)budPos);
    }

    public boolean isUntied() {
        return (Boolean)this.func_184212_Q().func_187225_a(UNTIED);
    }

    public float[] getOriginalPos() {
        return new float[]{((Float)this.func_184212_Q().func_187225_a(ORIGINAL_X)).floatValue(), ((Float)this.func_184212_Q().func_187225_a(ORIGINAL_Y)).floatValue(), ((Float)this.func_184212_Q().func_187225_a(ORIGINAL_Z)).floatValue()};
    }

    public void setUntied(boolean untied) {
        this.field_70180_af.func_187227_b(UNTIED, (Object)untied);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getVineAnimation(float partialTicks) {
        return new float[]{MathHelper.func_219799_g((float)partialTicks, (float)this.prevVineAngle, (float)this.getVineAngle()), MathHelper.func_219799_g((float)partialTicks, (float)this.prevAngle, (float)this.getAngle())};
    }

    public void onBroken(@Nullable Entity brokenEntity, boolean dropFruit) {
        if (dropFruit) {
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)new ItemStack((IItemProvider)EEItems.BOLLOOM_FRUIT.get()));
        }
        this.func_184185_a(SoundEvents.field_211414_dn, 1.0f, 1.0f);
        this.doParticles();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)EEItems.BOLLOOM_FRUIT.get());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.func_70089_S() && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            this.onBroken(source.func_76346_g(), true);
        }
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.func_190530_aW() && source != DamageSource.field_76380_i && source != DamageSource.field_191291_g;
    }

    public boolean func_85031_j(Entity entityIn) {
        return entityIn instanceof PlayerEntity ? this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)entityIn)), 0.0f) : false;
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof EntityBolloomFruit) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.field_70163_u >= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    public AxisAlignedBB func_184177_bl() {
        return super.func_184177_bl().func_186662_g(5.0);
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean func_70104_M() {
        return this.func_70089_S();
    }

    public boolean func_70067_L() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

