/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities.booflo;

import endergeticexpansion.api.endimator.Endimation;
import endergeticexpansion.api.endimator.entity.EndimatedEntity;
import endergeticexpansion.api.entity.util.EntityItemStackHelper;
import endergeticexpansion.common.entities.booflo.EntityBooflo;
import endergeticexpansion.common.entities.booflo.EntityBoofloAdolescent;
import endergeticexpansion.common.entities.booflo.ai.BabyFollowParentGoal;
import endergeticexpansion.core.registry.EEEntities;
import endergeticexpansion.core.registry.EEItems;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityBoofloBaby
extends EndimatedEntity {
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(EntityBoofloBaby.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> BEING_BORN = EntityDataManager.func_187226_a(EntityBoofloBaby.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> MOTHER_IMMUNITY_TICKS = EntityDataManager.func_187226_a(EntityBoofloBaby.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final Endimation BIRTH = new Endimation(60);
    public boolean wasBred;
    public int growingAge;
    public int forcedAge;
    public int forcedAgeTimer;
    private float prevTailAnimation;
    private float tailAnimation;
    private float tailSpeed;

    public EntityBoofloBaby(EntityType<? extends EntityBoofloBaby> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new BoofloBabyMoveContoller(this);
        this.field_70749_g = new BoofloBabyLookController(this, 10);
        this.prevTailAnimation = this.tailAnimation = this.field_70146_Z.nextFloat();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(MOVING, (Object)false);
        this.func_184212_Q().func_187214_a(BEING_BORN, (Object)false);
        this.func_184212_Q().func_187214_a(MOTHER_IMMUNITY_TICKS, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.85);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BabyFollowParentGoal(this, 1.2f));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomFlyingGoal(this, 1.1, 20));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return this.field_75513_b.func_180495_p(pos).func_196958_f();
            }
        };
    }

    public void func_213352_e(Vec3d vec3d) {
        if (this.func_70613_aW() && !this.func_70090_H()) {
            this.func_213309_a(0.012f, vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (!this.isMoving()) {
                this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, 0.0025, 0.0));
            }
        } else {
            super.func_213352_e(vec3d);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Moving", this.isMoving());
        compound.func_74757_a("IsBeingBorn", this.isBeingBorn());
        compound.func_74768_a("Age", this.getGrowingAge());
        compound.func_74768_a("MotherImmunityTicks", this.getMotherNoClipTicks());
        compound.func_74768_a("ForcedAge", this.forcedAge);
        compound.func_74757_a("WasBred", this.wasBred);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMoving(compound.func_74767_n("Moving"));
        this.setBeingBorn(compound.func_74767_n("IsBeingBorn"));
        this.setGrowingAge(compound.func_74762_e("Age"));
        this.setMotherNoClipTicks(compound.func_74762_e("MotherImmunityTicks"));
        this.forcedAge = compound.func_74762_e("ForcedAge");
        this.wasBred = compound.func_74767_n("WasBred");
    }

    public boolean isMoving() {
        return (Boolean)this.func_184212_Q().func_187225_a(MOVING);
    }

    public void setMoving(boolean moving) {
        this.func_184212_Q().func_187227_b(MOVING, (Object)moving);
    }

    public boolean isBeingBorn() {
        return (Boolean)this.func_184212_Q().func_187225_a(BEING_BORN);
    }

    public void setBeingBorn(boolean beingBorn) {
        this.func_184212_Q().func_187227_b(BEING_BORN, (Object)beingBorn);
    }

    public int getMotherNoClipTicks() {
        return (Integer)this.func_184212_Q().func_187225_a(MOTHER_IMMUNITY_TICKS);
    }

    public void setMotherNoClipTicks(int ticks) {
        this.func_184212_Q().func_187227_b(MOTHER_IMMUNITY_TICKS, (Object)ticks);
    }

    public int getGrowingAge() {
        if (this.field_70170_p.field_72995_K) {
            return -1;
        }
        return this.growingAge;
    }

    public void setGrowingAge(int age) {
        int oldAge = this.growingAge;
        this.growingAge = age;
        if (oldAge < 0 && age >= 0 || oldAge > 0 && age < 0) {
            this.growUp();
        }
    }

    public void addGrowth(int growth) {
        this.ageUp(growth, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailAnimation(float ptc) {
        return MathHelper.func_219799_g((float)ptc, (float)this.prevTailAnimation, (float)this.tailAnimation);
    }

    public boolean func_175446_cd() {
        return this.isBeingBorn() || super.func_175446_cd();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.wasBred;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.prevTailAnimation = this.tailAnimation;
            this.tailSpeed = this.func_70090_H() ? 1.0f : (this.isMoving() ? (this.tailSpeed < 0.5f ? 1.0f : (this.tailSpeed += (0.25f - this.tailSpeed) * 0.1f)) : (this.tailSpeed += (0.1875f - this.tailSpeed) * 0.1f));
            this.tailAnimation += this.tailSpeed;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.func_70089_S()) {
            int growingAge = this.getGrowingAge();
            if (growingAge < 0) {
                this.setGrowingAge(++growingAge);
            } else if (growingAge > 0) {
                this.setGrowingAge(--growingAge);
            }
        }
        if (this.getMotherNoClipTicks() > 0) {
            this.setMotherNoClipTicks(this.getMotherNoClipTicks() - 1);
        }
        if (this.isBeingBorn() && this.isNoEndimationPlaying()) {
            this.setPlayingEndimation(BIRTH);
        }
        if (this.isEndimationPlaying(BIRTH)) {
            if (this.getAnimationTick() == 59) {
                double[] oldPosition = new double[]{this.field_70165_t, this.field_70163_u, this.field_70161_v};
                this.func_184210_p();
                this.setBeingBorn(false);
                this.func_70107_b(oldPosition[0], oldPosition[1], oldPosition[2]);
                this.field_70125_A = 180.0f;
                this.setMotherNoClipTicks(50);
            } else if (this.field_70173_aa > 260) {
                this.func_184210_p();
                this.setBeingBorn(false);
            }
        }
    }

    public void growUp() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.func_199702_a((IItemProvider)EEItems.BOOFLO_HIDE.get(), 1);
            EntityBoofloAdolescent booflo = (EntityBoofloAdolescent)((EntityType)EEEntities.BOOFLO_ADOLESCENT.get()).func_200721_a(this.field_70170_p);
            booflo.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            if (this.func_145818_k_()) {
                booflo.func_200203_b(this.func_200201_e());
                booflo.func_174805_g(this.func_174833_aM());
            }
            if (this.func_110167_bD()) {
                booflo.func_110162_b(this.func_110166_bE(), true);
                this.func_110160_i(true, false);
            }
            if (this.func_184187_bx() != null) {
                booflo.func_184220_m(this.func_184187_bx());
            }
            booflo.func_70606_j(booflo.func_110138_aP());
            booflo.setGrowingAge(-24000);
            booflo.wasBred = this.wasBred;
            this.field_70170_p.func_217376_c((Entity)booflo);
            this.func_70106_y();
        }
    }

    public void ageUp(int growthSeconds, boolean updateForcedAge) {
        int growingAge;
        int j = growingAge = this.getGrowingAge();
        if ((growingAge += growthSeconds * 20) > 0) {
            growingAge = 0;
        }
        int k = growingAge - j;
        this.setGrowingAge(growingAge);
        if (updateForcedAge) {
            this.forcedAge += k;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getGrowingAge() == 0) {
            this.setGrowingAge(this.forcedAge);
        }
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == EEItems.BOLLOOM_FRUIT.get()) {
            EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            this.ageUp((int)((float)(-this.getGrowingAge() / 20) * 0.1f), true);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.setGrowingAge(-24000);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)EEItems.BOOFLO_SPAWN_EGG.get());
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof EntityBooflo)) {
            super.func_82167_n(entityIn);
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || source == DamageSource.field_188406_j || super.func_180431_b(source);
    }

    @Override
    public Endimation[] getEndimations() {
        return new Endimation[]{BIRTH};
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    class BoofloBabyLookController
    extends LookController {
        private final int angleLimit;

        public BoofloBabyLookController(EntityBoofloBaby baby, int angleLimit) {
            super((MobEntity)baby);
            this.angleLimit = angleLimit;
        }

        public void func_75649_a() {
            if (this.field_75655_d) {
                this.field_75655_d = false;
                this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.func_220678_h() + 20.0f, this.field_75657_b);
                this.field_75659_a.field_70125_A = this.func_220675_a(this.field_75659_a.field_70125_A, this.func_220677_g() + 10.0f, this.field_75658_c);
            } else {
                if (this.field_75659_a.func_70661_as().func_75500_f()) {
                    this.field_75659_a.field_70125_A = this.func_220675_a(this.field_75659_a.field_70125_A, 0.0f, 5.0f);
                }
                this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.field_75659_a.field_70761_aq, this.field_75657_b);
            }
            float wrappedDegrees = MathHelper.func_76142_g((float)(this.field_75659_a.field_70759_as - this.field_75659_a.field_70761_aq));
            if (wrappedDegrees < (float)(-this.angleLimit)) {
                this.field_75659_a.field_70761_aq -= 4.0f;
            } else if (wrappedDegrees > (float)this.angleLimit) {
                this.field_75659_a.field_70761_aq += 4.0f;
            }
        }
    }

    static class BoofloBabyMoveContoller
    extends MovementController {
        private final EntityBoofloBaby booflo;

        public BoofloBabyMoveContoller(EntityBoofloBaby booflo) {
            super((MobEntity)booflo);
            this.booflo = booflo;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.booflo.func_70661_as().func_75500_f()) {
                Vec3d vec3d = new Vec3d(this.field_75646_b - this.booflo.field_70165_t, this.field_75647_c - this.booflo.field_70163_u, this.field_75644_d - this.booflo.field_70161_v);
                double d0 = vec3d.func_72433_c();
                double d1 = vec3d.field_72448_b / d0;
                float f = (float)(MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) * 57.2957763671875) - 90.0f;
                this.booflo.field_70761_aq = this.booflo.field_70177_z = this.func_75639_a(this.booflo.field_70177_z, f, 10.0f);
                this.booflo.field_70759_as = this.booflo.field_70177_z;
                float f1 = (float)(this.field_75645_e * this.booflo.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.booflo.func_70689_ay(), (float)f1);
                this.booflo.func_70659_e(f2);
                double d3 = Math.cos(this.booflo.field_70177_z * ((float)Math.PI / 180));
                double d4 = Math.sin(this.booflo.field_70177_z * ((float)Math.PI / 180));
                double d5 = Math.sin((double)(this.booflo.field_70173_aa + this.booflo.func_145782_y()) * 0.75) * 0.05;
                if (!this.booflo.func_70090_H()) {
                    float f3 = -((float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)MathHelper.func_76133_a((double)(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c))) * 57.2957763671875));
                    f3 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f3), (float)-85.0f, (float)85.0f);
                    this.booflo.field_70125_A = this.func_75639_a(this.booflo.field_70125_A, f3, 5.0f);
                }
                this.booflo.func_213317_d(this.booflo.func_213322_ci().func_72441_c(0.0, d5 * (d4 + d3) * 0.25 + (double)f2 * d1 * 0.02, 0.0));
                this.booflo.setMoving(true);
            } else {
                this.booflo.func_70659_e(0.0f);
                this.booflo.setMoving(false);
            }
        }
    }

    static class RandomFlyingGoal
    extends RandomWalkingGoal {
        public RandomFlyingGoal(CreatureEntity p_i48937_1_, double p_i48937_2_, int p_i48937_4_) {
            super(p_i48937_1_, p_i48937_2_, p_i48937_4_);
        }

        @Nullable
        protected Vec3d func_190864_f() {
            Vec3d vec3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)7, (int)4);
            int i = 0;
            while (vec3d != null && !this.field_75457_a.field_70170_p.func_180495_p(new BlockPos(vec3d)).func_196957_g((IBlockReader)this.field_75457_a.field_70170_p, new BlockPos(vec3d), PathType.WATER) && i++ < 10) {
                vec3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)7, (int)4);
            }
            return vec3d;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_75457_a.func_70090_H();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !this.field_75457_a.func_70090_H();
        }
    }
}

