/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities.booflo.ai;

import endergeticexpansion.common.entities.booflo.EntityBooflo;
import endergeticexpansion.common.entities.puffbug.EntityPuffBug;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;

public class BoofloAttackGoal
extends Goal {
    private final int UPPER_DISTANCE = 16;
    private final EntityBooflo booflo;
    private Path path;
    private BlockPos upperAirPos;
    private int delayCounter;

    public BoofloAttackGoal(EntityBooflo booflo) {
        this.booflo = booflo;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        Entity target = this.booflo.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (!this.booflo.hasAggressiveAttackTarget()) {
            return false;
        }
        if (!this.booflo.isBoofed()) {
            return false;
        }
        if (this.booflo.getBoofloAttackTarget() instanceof EntityPuffBug) {
            return false;
        }
        this.upperAirPos = this.getUpperPosToTarget(target, this.booflo.func_70681_au());
        if (this.upperAirPos == null) {
            Path newPath = this.booflo.func_70661_as().func_75494_a(target, 0);
            this.upperAirPos = newPath != null ? newPath.func_224770_k() : null;
            return this.upperAirPos != null;
        }
        this.path = this.booflo.func_70661_as().func_179680_a(this.upperAirPos, 0);
        return this.path != null && this.booflo.hasAggressiveAttackTarget();
    }

    public boolean func_75253_b() {
        Entity target = this.booflo.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (!this.booflo.isBoofed()) {
            return false;
        }
        if (this.booflo.func_180425_c().func_177951_i((Vec3i)this.upperAirPos) > 16.0) {
            return false;
        }
        return !(target instanceof PlayerEntity) || !target.func_175149_v() && !((PlayerEntity)target).func_184812_l_();
    }

    public void func_75249_e() {
        this.booflo.func_70661_as().func_75484_a(this.path, (double)1.35f);
        this.booflo.func_213395_q(true);
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        Entity target = this.booflo.getBoofloAttackTarget();
        if (!EntityPredicates.field_188444_d.test(target)) {
            this.booflo.setBoofloAttackTargetId(0);
        }
        this.booflo.func_213395_q(false);
        this.booflo.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        --this.delayCounter;
        Entity target = this.booflo.getBoofloAttackTarget();
        if (target != null && this.upperAirPos != null) {
            this.booflo.func_70671_ap().func_75650_a((double)this.upperAirPos.func_177958_n(), (double)this.upperAirPos.func_177956_o(), (double)this.upperAirPos.func_177952_p(), 10.0f, 10.0f);
            double distToEnemySqr = this.booflo.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
            if (this.delayCounter <= 0 && !target.func_82150_aj()) {
                this.delayCounter = 4 + this.booflo.func_70681_au().nextInt(7);
                if (distToEnemySqr > 256.0) {
                    this.delayCounter += 5;
                }
                if (this.path != null && !this.booflo.func_70661_as().func_75492_a((double)this.path.func_224770_k().func_177958_n(), (double)this.path.func_224770_k().func_177956_o(), (double)this.path.func_224770_k().func_177952_p(), (double)1.35f)) {
                    this.delayCounter += 5;
                }
            }
        }
    }

    @Nullable
    private BlockPos getUpperPosToTarget(Entity target, Random rand) {
        BlockPos startingPos = target.func_180425_c();
        BlockPos targetPos = BlockPos.field_177992_a;
        boolean isOpenBelow = true;
        for (int y = 0; y < 16; ++y) {
            if (!target.field_70170_p.func_180495_p(startingPos.func_177981_b(y)).func_196952_d((IBlockReader)target.field_70170_p, startingPos.func_177981_b(y)).func_197766_b()) {
                isOpenBelow = false;
            }
            if (!target.field_70170_p.func_180495_p(startingPos.func_177981_b(y)).func_196952_d((IBlockReader)target.field_70170_p, startingPos.func_177981_b(y)).func_197766_b() || y <= 9) continue;
            targetPos = startingPos.func_177981_b(y);
        }
        return isOpenBelow ? targetPos : null;
    }
}

