/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities.booflo.ai;

import endergeticexpansion.api.util.NetworkUtil;
import endergeticexpansion.common.entities.booflo.EntityBooflo;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.stats.Stats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class BoofloBreedGoal
extends Goal {
    private static final EntityPredicate MATE_CHECKER = new EntityPredicate().func_221013_a(16.0).func_221008_a().func_221011_b().func_221014_c();
    protected final EntityBooflo booflo;
    protected EntityBooflo mate;
    private int impregnateDelay;

    public BoofloBreedGoal(EntityBooflo booflo) {
        this.booflo = booflo;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.booflo.isBoofed() || !this.booflo.field_70122_E && this.booflo.func_184187_bx() == null || !this.booflo.isInLove() || this.booflo.isPregnant()) {
            return false;
        }
        this.mate = this.getNearbyMate();
        return this.mate != null && !this.mate.isPregnant();
    }

    public boolean func_75253_b() {
        return !this.booflo.isBoofed() && this.mate.func_70089_S() && this.mate.isInLove() && this.impregnateDelay < 100;
    }

    public void func_75251_c() {
        this.mate = null;
        this.impregnateDelay = 0;
    }

    public void func_75246_d() {
        if (this.booflo.hopDelay == 0 && this.booflo.isNoEndimationPlaying() && !this.isBeingRidenOrRiding()) {
            NetworkUtil.setPlayingAnimationMessage(this.booflo, EntityBooflo.HOP);
        }
        if (this.booflo.func_70605_aq() instanceof EntityBooflo.GroundMoveHelperController && !this.isBeingRidenOrRiding()) {
            ((EntityBooflo.GroundMoveHelperController)this.booflo.func_70605_aq()).setSpeed(0.1);
        }
        double dx = this.mate.field_70165_t - this.booflo.field_70165_t;
        double dz = this.mate.field_70161_v - this.booflo.field_70161_v;
        float angle = (float)(MathHelper.func_181159_b((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        if (this.booflo.func_70605_aq() instanceof EntityBooflo.GroundMoveHelperController && !this.isBeingRidenOrRiding()) {
            ((EntityBooflo.GroundMoveHelperController)this.booflo.func_70605_aq()).setDirection(angle, false);
        }
        this.booflo.func_70661_as().func_75497_a((Entity)this.mate, 1.0);
        ++this.impregnateDelay;
        if (this.impregnateDelay >= 60 && this.booflo.func_70068_e((Entity)this.mate) < 10.0) {
            this.impregnateBooflo();
        }
    }

    protected void impregnateBooflo() {
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((MobEntity)this.booflo, (MobEntity)this.mate, null);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        if (cancelled) {
            this.booflo.resetInLove();
            this.mate.resetInLove();
            return;
        }
        ServerPlayerEntity serverplayerentity = this.booflo.getLoveCause();
        if (serverplayerentity == null && this.mate.getLoveCause() != null) {
            serverplayerentity = this.mate.getLoveCause();
        }
        if (serverplayerentity != null) {
            serverplayerentity.func_195066_a(Stats.field_151186_x);
        }
        if (!this.mate.isPregnant()) {
            this.booflo.setPregnant(true);
        }
        this.booflo.resetInLove();
        this.mate.resetInLove();
        this.booflo.breedDelay = 1400;
        this.mate.breedDelay = 1400;
        this.booflo.field_70170_p.func_72960_a((Entity)this.booflo, (byte)18);
        if (this.booflo.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.booflo.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.booflo.field_70170_p, this.booflo.field_70165_t, this.booflo.field_70163_u, this.booflo.field_70161_v, this.booflo.func_70681_au().nextInt(7) + 1));
        }
    }

    @Nullable
    private EntityBooflo getNearbyMate() {
        List list = this.booflo.field_70170_p.func_217374_a(EntityBooflo.class, MATE_CHECKER, (LivingEntity)this.booflo, this.booflo.func_174813_aQ().func_186662_g(16.0));
        double d0 = Double.MAX_VALUE;
        EntityBooflo booflo = null;
        for (EntityBooflo booflos : list) {
            if (!this.booflo.canMateWith(booflos) || !(this.booflo.func_70068_e((Entity)booflos) < d0)) continue;
            booflo = booflos;
            d0 = this.booflo.func_70068_e((Entity)booflos);
        }
        return booflo;
    }

    private boolean isBeingRidenOrRiding() {
        return this.booflo.func_184218_aH() || this.booflo.func_184207_aI();
    }
}

