/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities.booflo.ai;

import endergeticexpansion.common.entities.bolloom.EntityBolloomFruit;
import endergeticexpansion.common.entities.booflo.EntityBooflo;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockPos;

public class BoofloHuntFruitGoal
extends Goal {
    private final EntityBooflo booflo;
    protected int attackTick;
    private final double speedTowardsTarget;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private long field_220720_k;

    public BoofloHuntFruitGoal(EntityBooflo booflo, double speed) {
        this.booflo = booflo;
        this.speedTowardsTarget = speed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        long i = this.booflo.field_70170_p.func_82737_E();
        if (i - this.field_220720_k < 20L) {
            return false;
        }
        this.field_220720_k = i;
        Entity target = this.booflo.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (this.booflo.hasAggressiveAttackTarget()) {
            return false;
        }
        if (!this.booflo.isBoofed()) {
            return false;
        }
        this.path = this.booflo.func_70661_as().func_179680_a(new BlockPos(target), 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(target) >= this.booflo.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
    }

    public boolean func_75253_b() {
        Entity target = this.booflo.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (!this.booflo.isBoofed()) {
            return false;
        }
        if (!this.booflo.func_213389_a(new BlockPos(target))) {
            return false;
        }
        return !(target instanceof PlayerEntity) || !target.func_175149_v() && !((PlayerEntity)target).func_184812_l_();
    }

    public void func_75249_e() {
        this.booflo.func_70661_as().func_75484_a(this.path, 1.0);
        this.booflo.func_213395_q(true);
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        Entity target = this.booflo.getBoofloAttackTarget();
        if (!EntityPredicates.field_188444_d.test(target)) {
            this.booflo.setBoofloAttackTargetId(0);
        }
        this.booflo.func_213395_q(false);
        this.booflo.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        --this.delayCounter;
        Entity target = this.booflo.getBoofloAttackTarget();
        double distToEnemySqr = this.booflo.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
        this.booflo.func_70671_ap().func_75650_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 10.0f, 10.0f);
        if (this.delayCounter <= 0 || target.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.booflo.func_70681_au().nextFloat() < 0.05f) {
            this.targetX = target.field_70165_t;
            this.targetY = target.func_174813_aQ().field_72338_b;
            this.targetZ = target.field_70161_v;
            this.delayCounter = 4 + this.booflo.func_70681_au().nextInt(7);
            if (distToEnemySqr > 1024.0) {
                this.delayCounter += 5;
            } else if (distToEnemySqr > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.booflo.func_70661_as().func_75497_a(target, this.speedTowardsTarget)) {
                this.delayCounter += 5;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.tryToCapturePrey(target, distToEnemySqr);
    }

    protected void tryToCapturePrey(Entity prey, double distToEnemySqr) {
        double attackReach = this.getAttackReachSqr(prey);
        if (distToEnemySqr <= attackReach && this.attackTick <= 0) {
            this.attackTick = 20;
            if (prey instanceof EntityBolloomFruit) {
                ((EntityBolloomFruit)prey).onBroken((Entity)this.booflo, false);
                this.booflo.setCaughtFruit(true);
                this.booflo.setHungry(false);
                prey.func_70106_y();
            }
        }
    }

    protected double getAttackReachSqr(Entity attackTarget) {
        return (this.booflo.func_213311_cf() * 2.0f * this.booflo.func_213311_cf() * 2.0f + attackTarget.func_213311_cf()) * 0.85f;
    }
}

