/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.items;

import endergeticexpansion.common.entities.EntityEndergeticBoat;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemEndergeticBoat
extends Item {
    private static final Predicate<Entity> field_219989_a = EntityPredicates.field_180132_d.and(Entity::func_70067_L);
    private final EntityEndergeticBoat.Type type;

    public ItemEndergeticBoat(EntityEndergeticBoat.Type typeIn, Item.Properties properties) {
        super(properties);
        this.type = typeIn;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new DispenserBoatBehavior(typeIn));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        RayTraceResult raytraceresult = ItemEndergeticBoat.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        Vec3d vec3d = playerIn.func_70676_i(1.0f);
        List list = worldIn.func_175674_a((Entity)playerIn, playerIn.func_174813_aQ().func_216361_a(vec3d.func_186678_a(5.0)).func_186662_g(1.0), field_219989_a);
        if (!list.isEmpty()) {
            Vec3d vec3d1 = playerIn.func_174824_e(1.0f);
            for (Entity entity : list) {
                AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                if (!axisalignedbb.func_72318_a(vec3d1)) continue;
                return new ActionResult(ActionResultType.PASS, (Object)itemstack);
            }
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            EntityEndergeticBoat boatentity = new EntityEndergeticBoat(worldIn, raytraceresult.func_216347_e().field_72450_a, raytraceresult.func_216347_e().field_72448_b, raytraceresult.func_216347_e().field_72449_c);
            boatentity.setBoatModel(this.type);
            boatentity.field_70177_z = playerIn.field_70177_z;
            if (!worldIn.func_195586_b((Entity)boatentity, boatentity.func_174813_aQ().func_186662_g(-0.1))) {
                return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_217376_c((Entity)boatentity);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemstack);
    }

    static class DispenserBoatBehavior
    extends DefaultDispenseItemBehavior {
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
        private final EntityEndergeticBoat.Type type;

        public DispenserBoatBehavior(EntityEndergeticBoat.Type type) {
            this.type = type;
        }

        public ItemStack func_82487_b(IBlockSource iBlockSource, ItemStack stack) {
            double adjustY;
            Direction direction = (Direction)iBlockSource.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
            World world = iBlockSource.func_197524_h();
            double x = iBlockSource.func_82615_a() + (double)((float)direction.func_82601_c() * 1.125f);
            double y = iBlockSource.func_82617_b() + (double)((float)direction.func_96559_d() * 1.125f);
            double z = iBlockSource.func_82616_c() + (double)((float)direction.func_82599_e() * 1.125f);
            BlockPos pos = iBlockSource.func_180699_d().func_177972_a(direction);
            if (world.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a)) {
                adjustY = 1.0;
            } else {
                if (!world.func_180495_p(pos).func_196958_f() || !world.func_204610_c(pos.func_177977_b()).func_206884_a(FluidTags.field_206959_a)) {
                    return this.defaultDispenseItemBehavior.dispense(iBlockSource, stack);
                }
                adjustY = 0.0;
            }
            EntityEndergeticBoat boat = new EntityEndergeticBoat(world, x, y + adjustY, z);
            boat.setBoatModel(this.type);
            boat.field_70177_z = direction.func_185119_l();
            world.func_217376_c((Entity)boat);
            stack.func_190918_g(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource iBlockSource) {
            iBlockSource.func_197524_h().func_217379_c(1000, iBlockSource.func_180699_d(), 0);
        }
    }
}

