/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.network.entity;

import endergeticexpansion.api.EndergeticAPI;
import endergeticexpansion.api.endimator.entity.IEndimatedEntity;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageCAnimation {
    private int entityId;
    private int animationIndex;

    public MessageCAnimation(int entityID, int animationIndex) {
        this.entityId = entityID;
        this.animationIndex = animationIndex;
    }

    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.animationIndex);
    }

    public static MessageCAnimation deserialize(PacketBuffer buf) {
        int entityId = buf.readInt();
        int animationIndex = buf.readInt();
        return new MessageCAnimation(entityId, animationIndex);
    }

    public static void handle(MessageCAnimation message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        IEndimatedEntity endimatedEntity = (IEndimatedEntity)EndergeticAPI.ClientInfo.getClientPlayerWorld().func_73045_a(message.entityId);
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                if (endimatedEntity != null) {
                    if (message.animationIndex == -1) {
                        endimatedEntity.setPlayingEndimation(IEndimatedEntity.BLANK_ANIMATION);
                    } else {
                        endimatedEntity.setPlayingEndimation(endimatedEntity.getEndimations()[message.animationIndex]);
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

