/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.network.entity;

import endergeticexpansion.common.entities.EntityBoofBlock;
import endergeticexpansion.common.entities.EntityPoiseCluster;
import endergeticexpansion.common.entities.bolloom.EntityBolloomBalloon;
import endergeticexpansion.common.entities.bolloom.EntityBolloomFruit;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSBoofEntity {
    private double velX;
    private double velY;
    private double velZ;
    private int radius;

    public MessageSBoofEntity(double velX, double velY, double velZ, int radius) {
        this.velX = velX;
        this.velY = velY;
        this.velZ = velZ;
        this.radius = radius;
    }

    public void serialize(PacketBuffer buf) {
        buf.writeDouble(this.velX);
        buf.writeDouble(this.velY);
        buf.writeDouble(this.velZ);
        buf.writeInt(this.radius);
    }

    public static MessageSBoofEntity deserialize(PacketBuffer buf) {
        double velX = buf.readDouble();
        double velY = buf.readDouble();
        double velZ = buf.readDouble();
        int radius = buf.readInt();
        return new MessageSBoofEntity(velX, velY, velZ, radius);
    }

    public static void handle(MessageSBoofEntity message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                AxisAlignedBB bb = player.func_174813_aQ().func_186662_g((double)message.radius);
                List entities = player.func_130014_f_().func_217357_a(Entity.class, bb);
                for (int i = 0; i < entities.size(); ++i) {
                    Entity entity = (Entity)entities.get(i);
                    if (entity.func_145782_y() == player.func_145782_y() || entity instanceof EntityBoofBlock || entity instanceof ShulkerEntity || entity instanceof PaintingEntity || entity instanceof EntityPoiseCluster || entity instanceof ItemFrameEntity) continue;
                    if (entity instanceof EntityBolloomFruit) {
                        if (!((EntityBolloomFruit)entity).isUntied()) continue;
                        entity.func_70024_g((double)MathHelper.func_76126_a((float)((float)((double)entity.field_70177_z * Math.PI / 180.0))) * message.velX * 0.1, message.velY, (double)(-MathHelper.func_76134_b((float)((float)((double)entity.field_70177_z * Math.PI / 180.0)))) * message.velZ * 0.1);
                        continue;
                    }
                    if (entity instanceof EntityBolloomBalloon) {
                        if (!((EntityBolloomBalloon)entity).isUntied()) continue;
                        entity.func_70024_g((double)MathHelper.func_76126_a((float)((float)((double)entity.field_70177_z * Math.PI / 180.0))) * message.velX * 0.1, message.velY, (double)(-MathHelper.func_76134_b((float)((float)((double)entity.field_70177_z * Math.PI / 180.0)))) * message.velZ * 0.1);
                        continue;
                    }
                    entity.func_70024_g((double)MathHelper.func_76126_a((float)((float)((double)entity.field_70177_z * Math.PI / 180.0))) * message.velX * 0.1, message.velY, (double)(-MathHelper.func_76134_b((float)((float)((double)entity.field_70177_z * Math.PI / 180.0)))) * message.velZ * 0.1);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

