/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.network.entity;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSSetVelocity {
    private int entityId;
    private double vecX;
    private double vecY;
    private double vecZ;

    public MessageSSetVelocity(Vec3d motion, int entityId) {
        this.entityId = entityId;
        this.vecX = motion.func_82615_a();
        this.vecY = motion.func_82617_b();
        this.vecZ = motion.func_82616_c();
    }

    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.vecX);
        buf.writeDouble(this.vecY);
        buf.writeDouble(this.vecZ);
    }

    public static MessageSSetVelocity deserialize(PacketBuffer buf) {
        int entityId = buf.readInt();
        double vecX = buf.readDouble();
        double vecY = buf.readDouble();
        double vecZ = buf.readDouble();
        return new MessageSSetVelocity(new Vec3d(vecX, vecY, vecZ), entityId);
    }

    public static void handle(MessageSSetVelocity message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayerEntity player = ctx.get().getSender();
        Entity entity = player.func_130014_f_().func_73045_a(message.entityId);
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> entity.func_70016_h(message.vecX, message.vecY, message.vecZ));
            context.setPacketHandled(true);
        }
    }
}

