/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.network.entity;

import endergeticexpansion.api.EndergeticAPI;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageTeleport {
    private int entityId;
    private double posX;
    private double posY;
    private double posZ;

    public MessageTeleport(int entityID, double posX, double posY, double posZ) {
        this.entityId = entityID;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static MessageTeleport deserialize(PacketBuffer buf) {
        int entityId = buf.readInt();
        return new MessageTeleport(entityId, buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(MessageTeleport message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        Entity entity = EndergeticAPI.ClientInfo.getClientPlayerWorld().func_73045_a(message.entityId);
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> entity.func_70012_b(message.posX, message.posY, message.posZ, entity.field_70177_z, entity.field_70125_A));
            context.setPacketHandled(true);
        }
    }
}

