/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.network.entity.booflo;

import endergeticexpansion.api.util.NetworkUtil;
import endergeticexpansion.common.entities.booflo.EntityBooflo;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSSetPlayerNotBoosting {
    private int entityId;

    public MessageSSetPlayerNotBoosting(int entityId) {
        this.entityId = entityId;
    }

    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.entityId);
    }

    public static MessageSSetPlayerNotBoosting deserialize(PacketBuffer buf) {
        return new MessageSSetPlayerNotBoosting(buf.readInt());
    }

    public static void handle(MessageSSetPlayerNotBoosting message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                Entity entity = context.getSender().field_70170_p.func_73045_a(message.entityId);
                if (entity instanceof EntityBooflo) {
                    EntityBooflo booflo = (EntityBooflo)entity;
                    booflo.setPlayerBoosting(false);
                    booflo.setDelayDecrementing(true);
                    booflo.func_184185_a(booflo.getInflateSound(), 0.75f, 1.0f);
                    booflo.setBoostPower(MathHelper.func_76131_a((float)((float)booflo.getRideControlDelay() * 0.01f), (float)0.35f, (float)1.82f));
                    NetworkUtil.setPlayingAnimationMessage(booflo, EntityBooflo.INFLATE);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

