/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.network.entity.puffbug;

import endergeticexpansion.api.EndergeticAPI;
import endergeticexpansion.common.entities.puffbug.EntityPuffBug;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageRotate {
    private int entityId;
    private int tickLength;
    private float yaw;
    private float pitch;
    private float roll;

    public MessageRotate(int entityId, int tickLength, float yaw, float pitch, float roll) {
        this.entityId = entityId;
        this.tickLength = tickLength;
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.tickLength);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.writeFloat(this.roll);
    }

    public static MessageRotate deserialize(PacketBuffer buf) {
        return new MessageRotate(buf.readInt(), buf.readInt(), buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public static void handle(MessageRotate message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = EndergeticAPI.ClientInfo.getClientPlayerWorld().func_73045_a(message.entityId);
                if (entity instanceof EntityPuffBug) {
                    ((EntityPuffBug)entity).getRotationController().rotate(message.yaw, message.pitch, message.roll, message.tickLength);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

