/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.world;

import com.google.common.collect.Sets;
import endergeticexpansion.common.world.util.EndergeticLayerUtil;
import endergeticexpansion.core.registry.EEBiomes;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProviderSettings;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.layer.Layer;

public class EndergeticBiomeProvider
extends EndBiomeProvider {
    private final Layer genBiomes;
    private final Layer biomeFactoryLayer;
    private final SimplexNoiseGenerator generator;
    private final SharedSeedRandom random;
    private final Biome[] biomes = new Biome[]{Biomes.field_76779_k, Biomes.field_201938_R, Biomes.field_201937_Q, Biomes.field_201936_P, Biomes.field_201939_S, (Biome)EEBiomes.POISE_FOREST.get()};

    public EndergeticBiomeProvider(EndBiomeProviderSettings settings) {
        super(settings);
        this.random = new SharedSeedRandom(settings.func_205445_a());
        this.random.func_202423_a(17292);
        this.generator = new SimplexNoiseGenerator((Random)this.random);
        Layer[] alayer = EndergeticLayerUtil.createGenLayers(settings.func_205445_a(), WorldType.field_77137_b);
        this.genBiomes = alayer[0];
        this.biomeFactoryLayer = alayer[1];
    }

    public Biome func_201545_a(int x, int y) {
        int i = x >> 4;
        int j = y >> 4;
        if ((long)i * (long)i + (long)j * (long)j <= 4096L) {
            return Biomes.field_76779_k;
        }
        float f = this.func_222365_c(i * 2 + 1, j * 2 + 1);
        if (f >= 0.0f) {
            return this.biomeFactoryLayer.func_215738_a(x, y) == EEBiomes.CHORUS_PLAINS.get() ? this.getBiomeOriginal(x, y) : this.biomeFactoryLayer.func_215738_a(x, y);
        }
        return f < -20.0f ? Biomes.field_201936_P : (this.biomeFactoryLayer.func_215738_a(x, y) == EEBiomes.CHORUS_PLAINS.get() ? this.getBiomeOriginal(x, y) : this.biomeFactoryLayer.func_215738_a(x, y));
    }

    public Biome findBiome(int x, int y) {
        int i = x >> 4;
        int j = y >> 4;
        if ((long)i * (long)i + (long)j * (long)j <= 4096L) {
            return Biomes.field_76779_k;
        }
        float f = this.func_222365_c(i * 2 + 1, j * 2 + 1);
        if (f >= 0.0f) {
            return this.biomeFactoryLayer.func_215738_a(x, y) == EEBiomes.CHORUS_PLAINS.get() ? this.getBiomeOriginal(x, y) : (Biome)EEBiomes.POISE_FOREST.get();
        }
        return f < -20.0f ? Biomes.field_201936_P : (this.biomeFactoryLayer.func_215738_a(x, y) == EEBiomes.CHORUS_PLAINS.get() ? this.getBiomeOriginal(x, y) : (Biome)EEBiomes.POISE_FOREST.get());
    }

    public Biome getBiomeOriginal(int x, int y) {
        int i = x >> 4;
        int j = y >> 4;
        if ((long)i * (long)i + (long)j * (long)j <= 4096L) {
            return Biomes.field_76779_k;
        }
        float f = this.func_222365_c(i * 2 + 1, j * 2 + 1);
        if (f > 40.0f) {
            return Biomes.field_201938_R;
        }
        if (f >= 0.0f) {
            return Biomes.field_201937_Q;
        }
        return f < -20.0f ? Biomes.field_201936_P : Biomes.field_201939_S;
    }

    public Biome[] func_201537_a(int x, int z, int width, int length, boolean cacheFlag) {
        Biome[] abiome = new Biome[width * length];
        Long2ObjectOpenHashMap long2objectmap = new Long2ObjectOpenHashMap();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < length; ++j) {
                int k = i + x;
                int l = j + z;
                long i1 = ChunkPos.func_77272_a((int)k, (int)l);
                Biome biome = (Biome)long2objectmap.get(i1);
                if (biome == null) {
                    if (this.findBiome(k, l) == EEBiomes.POISE_FOREST.get()) {
                        return this.biomeFactoryLayer.func_202833_a(x, z, width, length);
                    }
                    biome = this.func_201545_a(k, l);
                    long2objectmap.put(i1, (Object)biome);
                }
                abiome[i + j * width] = biome;
            }
        }
        return abiome;
    }

    public Set<Biome> func_201538_a(int centerX, int centerZ, int sideLength) {
        int i = centerX - sideLength >> 2;
        int j = centerZ - sideLength >> 2;
        int k = centerX + sideLength >> 2;
        int l = centerZ + sideLength >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        return Sets.newHashSet((Object[])this.func_201539_b(i, j, i1, j1));
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        Biome[] abiome = this.func_201539_b(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            if (!biomes.contains(abiome[l1])) continue;
            if (blockpos == null || random.nextInt(k1 + 1) == 0) {
                blockpos = new BlockPos(i2, 0, j2);
            }
            ++k1;
        }
        return blockpos;
    }

    public float func_222365_c(int p_222365_1_, int p_222365_2_) {
        int i = p_222365_1_ / 2;
        int j = p_222365_2_ / 2;
        int k = p_222365_1_ % 2;
        int l = p_222365_2_ % 2;
        float f = 100.0f - MathHelper.func_76129_c((float)(p_222365_1_ * p_222365_1_ + p_222365_2_ * p_222365_2_)) * 8.0f;
        f = MathHelper.func_76131_a((float)f, (float)-100.0f, (float)80.0f);
        for (int i1 = -12; i1 <= 12; ++i1) {
            for (int j1 = -12; j1 <= 12; ++j1) {
                long k1 = i + i1;
                long l1 = j + j1;
                if (k1 * k1 + l1 * l1 <= 4096L || !(this.generator.func_151605_a((double)k1, (double)l1) < (double)-0.9f)) continue;
                float f1 = (MathHelper.func_76135_e((float)k1) * 3439.0f + MathHelper.func_76135_e((float)l1) * 147.0f) % 13.0f + 9.0f;
                float f2 = k - i1 * 2;
                float f3 = l - j1 * 2;
                float f4 = 100.0f - MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3)) * f1;
                f4 = MathHelper.func_76131_a((float)f4, (float)-100.0f, (float)80.0f);
                f = Math.max(f, f4);
            }
        }
        return f;
    }

    public Biome func_222366_b(int x, int y) {
        int i = x >> 4;
        int j = y >> 4;
        if ((long)i * (long)i + (long)j * (long)j <= 4096L) {
            return super.func_222366_b(x, y);
        }
        float f = this.func_222365_c(i * 2 + 1, j * 2 + 1);
        if (f >= 0.0f) {
            return this.genBiomes.func_215738_a(x, y);
        }
        return f < -20.0f ? super.func_222366_b(x, y) : this.genBiomes.func_215738_a(x, y);
    }

    public boolean func_205004_a(Structure<?> structureIn) {
        return this.field_205005_a.computeIfAbsent(structureIn, p_205008_1_ -> {
            for (Biome biome : this.biomes) {
                if (!biome.func_201858_a(p_205008_1_)) continue;
                return true;
            }
            return false;
        });
    }

    public Set<BlockState> func_205706_b() {
        if (this.field_205707_b.isEmpty()) {
            for (Biome biome : this.biomes) {
                this.field_205707_b.add(biome.func_203944_q().func_204108_a());
            }
        }
        return this.field_205707_b;
    }
}

