/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.world;

import com.google.common.collect.Lists;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EndergeticDragonFightManager
extends DragonFightManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Predicate<BlockState> IS_PORTAL_BLOCK = state -> {
        Block block = state.func_177230_c();
        return block == EEBlocks.MYSTICAL_OBSIDIAN.get() || block == EEBlocks.MYSTICAL_OBSIDIAN_ACTIVATION_RUNE.get() || block == EEBlocks.MYSTICAL_OBSIDIAN_ACTIVATION_RUNE_ACTIVE.get() || block == EEBlocks.MYSTICAL_OBSIDIAN_RUNE.get();
    };
    private final BlockPattern portalPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"       ", "       ", "       ", "   #   ", "       ", "       ", "       "}).func_177659_a(new String[]{"  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  "}).func_177659_a(new String[]{"       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       "}).func_177662_a('#', CachedBlockInfo.func_177510_a(IS_PORTAL_BLOCK)).func_177661_b();

    public EndergeticDragonFightManager(ServerWorld worldIn, CompoundNBT compound, EndDimension dim) {
        super(worldIn, compound, dim);
    }

    public void func_186106_e() {
        if (this.field_186117_k && this.field_186122_p == null) {
            BlockPos blockpos = this.field_186121_o;
            if (blockpos == null) {
                LOGGER.debug("Tried to respawn, but need to find the portal first.");
                BlockPattern.PatternHelper blockpattern$patternhelper = this.func_186091_h();
                if (blockpattern$patternhelper == null) {
                    LOGGER.debug("Couldn't find a portal, so we made one.");
                    this.func_186094_a(true);
                } else {
                    LOGGER.debug("Found the exit portal & temporarily using it.");
                }
                blockpos = this.field_186121_o;
            }
            ArrayList list1 = Lists.newArrayList();
            BlockPos blockpos1 = blockpos.func_177981_b(2);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                List list = this.field_186110_d.func_217357_a(EnderCrystalEntity.class, new AxisAlignedBB(blockpos1.func_177967_a(direction, 2)));
                if (list.isEmpty()) {
                    return;
                }
                list1.addAll(list);
            }
            LOGGER.debug("Found all crystals, respawning dragon.");
            this.func_186093_a(list1);
        }
    }

    @Nullable
    public BlockPattern.PatternHelper func_186091_h() {
        int height;
        for (int x = -8; x <= 8; ++x) {
            for (int z = -8; z <= 8; ++z) {
                Chunk chunk = this.field_186110_d.func_212866_a_(x, z);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    BlockPattern.PatternHelper portalPattern;
                    if (!(tileentity instanceof EndPortalTileEntity) || (portalPattern = this.portalPattern.func_177681_a((IWorldReader)this.field_186110_d, tileentity.func_174877_v())) == null) continue;
                    BlockPos blockpos = portalPattern.func_177670_a(3, 3, 3).func_177508_d();
                    if (this.field_186121_o == null && blockpos.func_177958_n() == 0 && blockpos.func_177952_p() == 0) {
                        this.field_186121_o = blockpos;
                    }
                    return portalPattern;
                }
            }
        }
        for (int y = height = this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a.func_177984_a()).func_177956_o(); y >= 0; --y) {
            BlockPattern.PatternHelper blockpattern$patternhelper1 = this.portalPattern.func_177681_a((IWorldReader)this.field_186110_d, new BlockPos(EndPodiumFeature.field_186139_a.func_177958_n(), y, EndPodiumFeature.field_186139_a.func_177952_p()));
            if (blockpattern$patternhelper1 == null) continue;
            if (this.field_186121_o == null) {
                this.field_186121_o = blockpattern$patternhelper1.func_177670_a(3, 3, 3).func_177508_d();
            }
            return blockpattern$patternhelper1;
        }
        return null;
    }
}

