/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.world.util;

import com.google.common.collect.ImmutableList;
import endergeticexpansion.common.world.EndergeticGenLayerBiome;
import endergeticexpansion.common.world.util.LazyAreaContextEndergetic;
import java.util.function.LongFunction;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.VoroniZoomLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer0;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class EndergeticLayerUtil {
    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> createBiomeFactory(IAreaFactory<T> landFactory, LongFunction<C> contextFactory) {
        IAreaFactory biomeFactory = EndergeticGenLayerBiome.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        biomeFactory = LayerUtil.func_202829_a((long)200L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)biomeFactory, (int)2, contextFactory);
        return biomeFactory;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> ImmutableList<IAreaFactory<T>> createAreaFactories(WorldType worldType, LongFunction<C> contextFactory) {
        IAreaFactory landFactory = GenLayerLand.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        IAreaFactory biomesFactory = EndergeticLayerUtil.createBiomeFactory(landFactory, contextFactory);
        biomesFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), biomesFactory);
        biomesFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1001L), biomesFactory);
        biomesFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1002L), biomesFactory);
        biomesFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1003L), biomesFactory);
        biomesFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1004L), biomesFactory);
        biomesFactory = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(100L), biomesFactory);
        IAreaFactory voroniZoomBiomesFactory = VoroniZoomLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(10L), biomesFactory);
        return ImmutableList.of((Object)biomesFactory, (Object)voroniZoomBiomesFactory, (Object)biomesFactory);
    }

    public static Layer[] createGenLayers(long seed, WorldType worldType) {
        ImmutableList factoryList = EndergeticLayerUtil.createAreaFactories(worldType, seedModifier -> new LazyAreaContextEndergetic(25, seed, seedModifier));
        Layer biomesLayer = new Layer((IAreaFactory)factoryList.get(0));
        Layer voroniZoomBiomesLayer = new Layer((IAreaFactory)factoryList.get(1));
        Layer biomesLayer2 = new Layer((IAreaFactory)factoryList.get(2));
        return new Layer[]{biomesLayer, voroniZoomBiomesLayer, biomesLayer2};
    }

    public static enum GenLayerLand implements IAreaTransformer0
    {
        INSTANCE;


        public int func_215735_a(INoiseRandom random, int x, int z) {
            return 1;
        }
    }
}

