/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.core.keybinds;

import com.google.common.collect.Lists;
import endergeticexpansion.api.util.MathUtils;
import endergeticexpansion.api.util.NetworkUtil;
import endergeticexpansion.common.entities.EntityBoofBlock;
import endergeticexpansion.common.entities.EntityPoiseCluster;
import endergeticexpansion.common.entities.bolloom.EntityBolloomBalloon;
import endergeticexpansion.common.entities.bolloom.EntityBolloomFruit;
import endergeticexpansion.common.entities.booflo.EntityBooflo;
import endergeticexpansion.common.items.ItemBoofloVest;
import endergeticexpansion.core.registry.EEItems;
import endergeticexpansion.core.registry.EESounds;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="endergetic", value={Dist.CLIENT})
public class KeybindHandler {
    private static List<KeyBinding> keyBinds = Lists.newArrayList();
    public static KeyBinding BOOF_VEST = KeybindHandler.registerKeybind(new KeyBinding("key.endergetic.boof_vest", 32, "key.categories.movement"));
    public static KeyBinding BOOFLO_INFLATE = KeybindHandler.registerKeybind(new KeyBinding("key.endergetic.booflo_inflate", 32, "key.categories.gameplay"));
    public static KeyBinding BOOFLO_SLAM = KeybindHandler.registerKeybind(new KeyBinding("key.endergetic.booflo_slam", 88, "key.categories.gameplay"));

    public static void registerKeys() {
        for (KeyBinding keys : keyBinds) {
            ClientRegistry.registerKeyBinding((KeyBinding)keys);
        }
    }

    private static KeyBinding registerKeybind(KeyBinding keybind) {
        keyBinds.add(keybind);
        return keybind;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onKeyPressed(InputEvent.KeyInputEvent event) {
        EntityBooflo booflo;
        Entity ridingEntity;
        ClientPlayerEntity player;
        if (BOOF_VEST.func_151468_f()) {
            ItemBoofloVest vest;
            player = Minecraft.func_71410_x().field_71439_g;
            Random rand = player.func_70681_au();
            ItemStack stack = player.field_71071_by.func_70440_f(2);
            if (!stack.func_190926_b() && stack.func_77973_b() == EEItems.BOOFLO_VEST.get() && !player.field_70122_E && Minecraft.func_71410_x().field_71462_r == null && !player.func_175149_v() && (vest = (ItemBoofloVest)stack.func_77973_b()).canBoof(stack, (PlayerEntity)player)) {
                int i;
                CompoundNBT tag = stack.func_77978_p();
                tag.func_74757_a("boofed", true);
                tag.func_74768_a("timesBoofed", tag.func_74762_e("timesBoofed") + 1);
                vest.setDelayForBoofedAmount(stack, (PlayerEntity)player);
                NetworkUtil.updateSItemNBT(stack);
                double[] vars = new double[]{4.0, player.field_70177_z, Math.PI, 180.0};
                player.func_70016_h((double)(-MathHelper.func_76126_a((float)((float)(vars[1] * vars[2] / vars[3])))) * vars[0] * 0.1, 0.75, (double)MathHelper.func_76134_b((float)((float)(vars[1] * vars[2] / vars[3]))) * vars[0] * 0.1);
                AxisAlignedBB bb = player.func_174813_aQ().func_186662_g(2.0);
                List entities = player.func_130014_f_().func_217357_a(Entity.class, bb);
                for (i = 0; i < entities.size(); ++i) {
                    Entity entity = (Entity)entities.get(i);
                    if (entity.func_145782_y() == player.func_145782_y() || entity instanceof EntityBoofBlock || entity instanceof ShulkerEntity || entity instanceof PaintingEntity || entity instanceof EntityPoiseCluster || entity instanceof ItemFrameEntity) continue;
                    if (entity instanceof EntityBolloomFruit) {
                        if (!((EntityBolloomFruit)entity).isUntied()) continue;
                        entity.func_70024_g((double)MathHelper.func_76126_a((float)((float)((double)entity.field_70177_z * vars[2] / vars[3]))) * vars[0] * (double)0.1f, 0.75, (double)(-MathHelper.func_76134_b((float)((float)((double)entity.field_70177_z * vars[2] / vars[3])))) * vars[0] * (double)0.1f);
                        continue;
                    }
                    if (entity instanceof EntityBolloomBalloon) {
                        if (!((EntityBolloomBalloon)entity).isUntied()) continue;
                        entity.func_70024_g((double)MathHelper.func_76126_a((float)((float)((double)entity.field_70177_z * vars[2] / vars[3]))) * vars[0] * (double)0.1f, 0.75, (double)(-MathHelper.func_76134_b((float)((float)((double)entity.field_70177_z * vars[2] / vars[3])))) * vars[0] * (double)0.1f);
                        continue;
                    }
                    entity.func_70024_g((double)MathHelper.func_76126_a((float)((float)((double)entity.field_70177_z * vars[2] / vars[3]))) * vars[0] * (double)0.1f, 0.75, (double)(-MathHelper.func_76134_b((float)((float)((double)entity.field_70177_z * vars[2] / vars[3])))) * vars[0] * (double)0.1f);
                }
                for (i = 0; i < 8; ++i) {
                    double offsetX = MathUtils.makeNegativeRandomly(rand.nextFloat() * 0.15f, rand);
                    double offsetZ = MathUtils.makeNegativeRandomly(rand.nextFloat() * 0.15f, rand);
                    double x = player.field_70165_t + offsetX;
                    double y = player.field_70163_u + (double)(rand.nextFloat() * 0.05f) + 1.25;
                    double z = player.field_70161_v + offsetZ;
                    NetworkUtil.spawnParticleC2S2C("endergetic:short_poise_bubble", x, y, z, MathUtils.makeNegativeRandomly(rand.nextFloat() * 0.3f, rand) + (double)0.025f, rand.nextFloat() * 0.15f + 0.1f, MathUtils.makeNegativeRandomly(rand.nextFloat() * 0.3f, rand) + (double)0.025f);
                }
                player.func_184185_a((SoundEvent)EESounds.BOOFLO_VEST_INFLATE.get(), 1.0f, MathHelper.func_76131_a((float)(1.3f - (float)tag.func_74762_e("timesBoofed") * 0.15f), (float)0.25f, (float)1.0f));
                NetworkUtil.SBoofEntity(4.0, 0.75, 4.0, 2);
            }
        }
        if (BOOFLO_INFLATE.func_151468_f() && Minecraft.func_71410_x().field_71462_r == null) {
            player = Minecraft.func_71410_x().field_71439_g;
            ridingEntity = player.func_184187_bx();
            if (KeybindHandler.checkRidden((PlayerEntity)player) && !((EntityBooflo)ridingEntity).isOnGround() && !(booflo = (EntityBooflo)ridingEntity).isBoofed() && booflo.func_184186_bw() && booflo.getRideControlDelay() <= 0) {
                NetworkUtil.inflateBooflo(booflo.func_145782_y());
            }
        }
        if (BOOFLO_INFLATE.func_151470_d() && Minecraft.func_71410_x().field_71462_r == null) {
            player = Minecraft.func_71410_x().field_71439_g;
            ridingEntity = player.func_184187_bx();
            if (KeybindHandler.checkRidden((PlayerEntity)player) && !((EntityBooflo)ridingEntity).isOnGround() && (booflo = (EntityBooflo)ridingEntity).isBoofed() && booflo.func_184186_bw() && !booflo.isDelayDecrementing() && !booflo.isDelayExpanding() && booflo.getRideControlDelay() <= 182) {
                if (booflo.getRideControlDelay() >= 182) {
                    NetworkUtil.setPlayerNotBoosting(booflo.func_145782_y());
                } else {
                    NetworkUtil.incrementBoofloBoostTimer(booflo.func_145782_y());
                }
            }
        } else {
            player = Minecraft.func_71410_x().field_71439_g;
            if (KeybindHandler.checkRidden((PlayerEntity)player) && Minecraft.func_71410_x().field_71462_r == null && (booflo = (EntityBooflo)(ridingEntity = player.func_184187_bx())).isBoofed() && !booflo.isDelayDecrementing() && !booflo.isDelayExpanding() && booflo.wasPlayerBoosting()) {
                NetworkUtil.setPlayerNotBoosting(booflo.func_145782_y());
            }
        }
        if (BOOFLO_SLAM.func_151468_f() && Minecraft.func_71410_x().field_71462_r == null) {
            player = Minecraft.func_71410_x().field_71439_g;
            ridingEntity = player.func_184187_bx();
            if (KeybindHandler.checkRidden((PlayerEntity)player) && (booflo = (EntityBooflo)ridingEntity).isBoofed() && booflo.getRideControlDelay() <= 0 && booflo.isNoEndimationPlaying()) {
                NetworkUtil.slamBooflo(booflo.func_145782_y());
            }
        }
    }

    public static boolean checkRidden(PlayerEntity player) {
        return player != null && player.func_184218_aH() && player.func_184187_bx() instanceof EntityBooflo;
    }

    public static boolean isPlayerOnGroundReal(PlayerEntity player) {
        World world = player.field_70170_p;
        BlockPos pos = player.func_180425_c().func_177977_b();
        return world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_212434_a(Direction.UP).func_197766_b();
    }
}

