/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.core.registry;

import endergeticexpansion.common.world.biomes.BiomeChorusPlains;
import endergeticexpansion.common.world.biomes.BiomePoiseForest;
import endergeticexpansion.common.world.biomes.EndergeticBiome;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class EEBiomes {
    private static int TOTAL_WEIGHT;
    public static final DeferredRegister<Biome> BIOMES;
    public static final RegistryObject<EndergeticBiome> POISE_FOREST;
    public static final RegistryObject<EndergeticBiome> CHORUS_PLAINS;

    public static void applyBiomeInfo() {
        BIOMES.getEntries().forEach(biome -> {
            Biome endBiome = (Biome)biome.get();
            if (endBiome instanceof EndergeticBiome && endBiome != null) {
                BiomeDictionary.addTypes((Biome)endBiome, (BiomeDictionary.Type[])((EndergeticBiome)endBiome).getBiomeTypes());
                ((EndergeticBiome)endBiome).addSpawnsAndFeatures();
            }
        });
    }

    private static RegistryObject<EndergeticBiome> createEndBiome(String name, Supplier<EndergeticBiome> supplier) {
        TOTAL_WEIGHT += supplier.get().getWeight();
        return BIOMES.register(name, supplier);
    }

    public static Biome getRandomBiome(INoiseRandom context) {
        Biome biome;
        int weight = context.func_202696_a(TOTAL_WEIGHT);
        Iterator iterator = BIOMES.getEntries().iterator();
        while ((weight -= ((EndergeticBiome)(biome = (Biome)((RegistryObject)iterator.next()).get())).getWeight()) >= 0) {
        }
        return biome;
    }

    static {
        BIOMES = new DeferredRegister(ForgeRegistries.BIOMES, "endergetic");
        POISE_FOREST = EEBiomes.createEndBiome("poise_forest", BiomePoiseForest::new);
        CHORUS_PLAINS = EEBiomes.createEndBiome("chorus_plains", BiomeChorusPlains::new);
    }
}

