/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.core.registry;

import endergeticexpansion.common.entities.EntityBoofBlock;
import endergeticexpansion.common.entities.EntityEndergeticBoat;
import endergeticexpansion.common.entities.EntityPoiseCluster;
import endergeticexpansion.common.entities.bolloom.EntityBolloomBalloon;
import endergeticexpansion.common.entities.bolloom.EntityBolloomFruit;
import endergeticexpansion.common.entities.bolloom.EntityBolloomKnot;
import endergeticexpansion.common.entities.booflo.EntityBooflo;
import endergeticexpansion.common.entities.booflo.EntityBoofloAdolescent;
import endergeticexpansion.common.entities.booflo.EntityBoofloBaby;
import endergeticexpansion.common.entities.puffbug.EntityPuffBug;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="endergetic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EEEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = new DeferredRegister(ForgeRegistries.ENTITIES, "endergetic");
    public static final RegistryObject<EntityType<EntityPoiseCluster>> POISE_CLUSTER = ENTITY_TYPES.register("poise_cluster", () -> EEEntities.createLivingEntity(EntityPoiseCluster::new, EntityClassification.MISC, "poise_cluster", 1.0f, 1.0f));
    public static final RegistryObject<EntityType<EntityBolloomFruit>> BOLLOOM_FRUIT = ENTITY_TYPES.register("bolloom_fruit", () -> EEEntities.createEntity(EntityBolloomFruit::new, EntityBolloomFruit::new, EntityClassification.MISC, "bolloom_fruit", 0.5f, 0.5f));
    public static final RegistryObject<EntityType<EntityBoofBlock>> BOOF_BLOCK = ENTITY_TYPES.register("boof_block", () -> EEEntities.createLivingEntity(EntityBoofBlock::new, EntityClassification.MISC, "boof_block", 1.6f, 1.6f));
    public static final RegistryObject<EntityType<EntityPuffBug>> PUFF_BUG = ENTITY_TYPES.register("puff_bug", () -> EEEntities.createLivingEntity(EntityPuffBug::new, EntityClassification.CREATURE, "puff_bug", 0.3f, 1.15f));
    public static final RegistryObject<EntityType<EntityEndergeticBoat>> BOAT = ENTITY_TYPES.register("boat", () -> EEEntities.createEntity(EntityEndergeticBoat::new, EntityEndergeticBoat::new, EntityClassification.MISC, "boat", 1.375f, 0.5625f));
    public static final RegistryObject<EntityType<EntityBolloomBalloon>> BOLLOOM_BALLOON = ENTITY_TYPES.register("bolloom_balloon", () -> EEEntities.createEntity(EntityBolloomBalloon::new, EntityBolloomBalloon::new, EntityClassification.MISC, "bolloom_balloon", 0.5f, 0.5f));
    public static final RegistryObject<EntityType<EntityBolloomKnot>> BOLLOOM_KNOT = ENTITY_TYPES.register("bolloom_knot", () -> EEEntities.createEntity(EntityBolloomKnot::new, EntityBolloomKnot::new, EntityClassification.MISC, "bolloom_knot", 0.375f, 0.19f));
    public static final RegistryObject<EntityType<EntityBoofloBaby>> BOOFLO_BABY = ENTITY_TYPES.register("booflo_baby", () -> EEEntities.createLivingEntity(EntityBoofloBaby::new, EntityClassification.CREATURE, "booflo_baby", 0.375f, 0.325f));
    public static final RegistryObject<EntityType<EntityBoofloAdolescent>> BOOFLO_ADOLESCENT = ENTITY_TYPES.register("booflo_adolescent", () -> EEEntities.createLivingEntity(EntityBoofloAdolescent::new, EntityClassification.CREATURE, "booflo_adolescent", 0.8f, 0.7f));
    public static final RegistryObject<EntityType<EntityBooflo>> BOOFLO = ENTITY_TYPES.register("booflo", () -> EEEntities.createLivingEntity(EntityBooflo::new, EntityClassification.CREATURE, "booflo", 1.3f, 1.3f));

    private static <T extends LivingEntity> EntityType<T> createLivingEntity(EntityType.IFactory<T> factory, EntityClassification entityClassification, String name, float width, float height) {
        ResourceLocation location = new ResourceLocation("endergetic", name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).func_206830_a(location.toString());
        return entity;
    }

    private static <T extends Entity> EntityType<T> createEntity(EntityType.IFactory<T> factory, BiFunction<FMLPlayMessages.SpawnEntity, World, T> clientFactory, EntityClassification entityClassification, String name, float width, float height) {
        ResourceLocation location = new ResourceLocation("endergetic", name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).setCustomClientFactory(clientFactory).func_206830_a(location.toString());
        return entity;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BOOFLO.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, EEEntities::endIslandCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BOOFLO_ADOLESCENT.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, EEEntities::endIslandCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)PUFF_BUG.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EEEntities::endIslandCondition);
    }

    private static boolean endIslandCondition(EntityType<? extends CreatureEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return pos.func_177956_o() >= 40;
    }

    public static class EEEntityClassifications {
        public static final EntityClassification END_CREATURE = EntityClassification.create((String)"endergetic:end_creature", (String)"END_CREATURE", (int)20, (boolean)false, (boolean)true);
    }
}

