/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.core.registry.other;

import com.google.common.collect.Lists;
import endergeticexpansion.common.world.biomes.EndergeticBiome;
import endergeticexpansion.core.registry.EEBiomes;
import endergeticexpansion.core.registry.EESounds;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="endergetic", value={Dist.CLIENT})
public class EEAmbientSoundHandlers {
    private static final List<IAmbientSoundHandler> SOUND_HANDLERS = Lists.newArrayList();

    public static void registerBiomeAmbientSoundPlayer(Supplier<Biome> biome, Supplier<SoundEvent> loopSound, Supplier<SoundEvent> additionSound, Supplier<SoundEvent> moodSound) {
        SOUND_HANDLERS.add(new BiomeAmbientSoundPlayer(biome, loopSound, additionSound, moodSound));
    }

    @SubscribeEvent
    public static void onClientPlayerTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            SoundHandler soundHandler = mc.func_147118_V();
            SOUND_HANDLERS.forEach(ambientSoundHandler -> {
                if (player != null && player.canUpdate()) {
                    ambientSoundHandler.tickMainAmbience(player, soundHandler);
                    ambientSoundHandler.tickAdditions(player, soundHandler);
                }
            });
        }
    }

    static {
        EEAmbientSoundHandlers.registerBiomeAmbientSoundPlayer(() -> (EndergeticBiome)EEBiomes.POISE_FOREST.get(), () -> (SoundEvent)EESounds.POISE_FOREST_LOOP.get(), () -> (SoundEvent)EESounds.POISE_FOREST_ADDITIONS.get(), () -> (SoundEvent)EESounds.POISE_FOREST_MOOD.get());
    }

    private static interface IAmbientSoundHandler {
        public void tickMainAmbience(ClientPlayerEntity var1, SoundHandler var2);

        public void tickAdditions(ClientPlayerEntity var1, SoundHandler var2);

        public Biome getBiome();

        default public boolean isInBiome(ClientPlayerEntity player) {
            return player.field_70170_p.func_180494_b(player.func_180425_c()) == this.getBiome();
        }
    }

    private static class BiomeAmbientSoundPlayer
    implements IAmbientSoundHandler {
        private final Supplier<Biome> biomeToPlayIn;
        private final List<Supplier<SoundEvent>> soundsToPlay = Lists.newArrayList();
        private int delay = 0;
        private int ticksInBiome;
        private int ticksTillNextMood = this.generateTicksTillNextMood();
        private boolean isInBiome;

        public BiomeAmbientSoundPlayer(Supplier<Biome> biomeToPlayIn, Supplier<SoundEvent> loopSound, Supplier<SoundEvent> additionSound, Supplier<SoundEvent> moodSound) {
            this.biomeToPlayIn = biomeToPlayIn;
            this.soundsToPlay.add(loopSound);
            this.soundsToPlay.add(additionSound);
            this.soundsToPlay.add(moodSound);
        }

        @Override
        public void tickMainAmbience(ClientPlayerEntity player, SoundHandler soundHandler) {
            boolean wasInBiome = this.isInBiome;
            boolean isInBiome = this.updateIsInBiome(player);
            if (!wasInBiome && isInBiome) {
                soundHandler.func_147682_a((ISound)new BiomeAmbienceSound(player, this.soundsToPlay.get(0).get(), this.getBiome()));
            }
        }

        @Override
        public void tickAdditions(ClientPlayerEntity player, SoundHandler soundHandler) {
            --this.delay;
            if (this.isInBiome(player)) {
                ++this.ticksInBiome;
                if (!Minecraft.func_71410_x().func_147113_T()) {
                    if (this.delay <= 0 && player.func_70681_au().nextFloat() < 0.0175f) {
                        soundHandler.func_147682_a((ISound)new BiomeAmbienceAdditionSound(player, this.soundsToPlay.get(1).get()));
                        this.delay = 60;
                    }
                    if (this.ticksTillNextMood <= this.ticksInBiome) {
                        soundHandler.func_147682_a((ISound)new BiomeAmbienceAdditionSound(player, this.soundsToPlay.get(2).get()));
                        this.ticksTillNextMood = this.generateTicksTillNextMood();
                        this.ticksInBiome = 0;
                        this.delay = 20;
                    }
                }
            } else {
                this.ticksInBiome = 0;
            }
        }

        @Override
        public Biome getBiome() {
            return this.biomeToPlayIn.get();
        }

        private boolean updateIsInBiome(ClientPlayerEntity player) {
            this.isInBiome = this.isInBiome(player);
            return this.isInBiome;
        }

        private int generateTicksTillNextMood() {
            return new Random().nextInt(100) + 6000;
        }

        class BiomeAmbienceAdditionSound
        extends TickableSound {
            private final ClientPlayerEntity player;

            BiomeAmbienceAdditionSound(ClientPlayerEntity player, SoundEvent sound) {
                super(sound, SoundCategory.AMBIENT);
                this.player = player;
                this.field_147659_g = false;
                this.field_147665_h = 0;
                this.field_147662_b = 0.5f;
                this.field_147663_c = new Random().nextFloat() * 0.2f + 0.9f;
                this.field_204201_l = true;
                this.field_217862_m = true;
            }

            public void func_73660_a() {
                if (!this.player.func_70089_S() || this.player.field_71093_bK != DimensionType.field_223229_c_) {
                    this.field_147668_j = true;
                }
            }
        }

        class BiomeAmbienceSound
        extends TickableSound {
            private final ClientPlayerEntity player;
            private final Biome biome;
            private int ticksInBiome;

            public BiomeAmbienceSound(ClientPlayerEntity player, SoundEvent sound, Biome biome) {
                super(sound, SoundCategory.AMBIENT);
                this.player = player;
                this.biome = biome;
                this.field_147659_g = true;
                this.field_147665_h = 0;
                this.field_147662_b = 1.0f;
                this.field_204201_l = true;
                this.field_217862_m = true;
            }

            public void func_73660_a() {
                if (this.player.func_70089_S() && this.ticksInBiome >= 0) {
                    BlockPos pos = this.player.func_180425_c();
                    this.ticksInBiome = this.player.field_70170_p.isAreaLoaded(pos, 1) && this.player.field_70170_p.func_180494_b(pos) == this.biome ? ++this.ticksInBiome : --this.ticksInBiome;
                    this.ticksInBiome = Math.min(this.ticksInBiome, 40);
                    this.field_147662_b = MathHelper.func_76131_a((float)((float)this.ticksInBiome / 40.0f), (float)0.0f, (float)1.0f);
                } else {
                    this.field_147668_j = true;
                }
            }
        }
    }
}

