/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.core.registry.util;

import endergeticexpansion.client.render.item.EETileEntityItemRenderer;
import endergeticexpansion.common.items.EndergeticSpawnEgg;
import endergeticexpansion.common.items.itemblocks.ItemBlockCorrockCrown;
import endergeticexpansion.common.items.itemblocks.ItemBlockCorrockCrownS;
import endergeticexpansion.core.registry.EEBlocks;
import endergeticexpansion.core.registry.EEItems;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.TallBlockItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;

public class RegistryUtils {
    public static BlockItem createSimpleBlockItem(Block blockForInput, ItemGroup itemGroup) {
        return (BlockItem)new BlockItem(blockForInput, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(blockForInput.getRegistryName());
    }

    public static BlockItem createNoTabBlockItem(Block blockForInput) {
        return (BlockItem)new BlockItem(blockForInput, new Item.Properties()).setRegistryName(blockForInput.getRegistryName());
    }

    public static BlockItem createWallOrFloorItem(Block floorBlock, Block wallBlock, ItemGroup itemGroup) {
        return (BlockItem)new WallOrFloorItem(floorBlock, wallBlock, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(floorBlock.getRegistryName());
    }

    public static BlockItem createTallItemBlock(Block blockForInput, ItemGroup itemGroup) {
        return (BlockItem)new TallBlockItem(blockForInput, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(blockForInput.getRegistryName());
    }

    public static BlockItem createWallOrFloorItemUpsideDownAllowed(Block floorBlock, Block wallBlock, ItemGroup itemGroup) {
        return (BlockItem)new ItemBlockCorrockCrown(floorBlock, wallBlock, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(floorBlock.getRegistryName());
    }

    public static Item createSimpleItem(String name, ItemGroup itemGroup) {
        return (Item)new Item(new Item.Properties().func_200916_a(itemGroup)).setRegistryName("endergetic", name);
    }

    public static Item createSpawnEggForEntity(EntityType entityType, int eggColor1, int eggColor2, ItemGroup itemGroup) {
        return (Item)new SpawnEggItem(entityType, eggColor1, eggColor2, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(entityType.getRegistryName() + "_spawn_egg");
    }

    public static Item.Properties createSimpleItemProperty(int stackSize, ItemGroup itemGroup) {
        return new Item.Properties().func_200916_a(itemGroup).func_200917_a(stackSize);
    }

    public static <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier) {
        RegistryObject item = EEItems.ITEMS.register(name, supplier);
        return item;
    }

    public static RegistryObject<Item> createSpawnEggItem(String entityName, Supplier<EntityType<?>> supplier, int primaryColor, int secondaryColor) {
        RegistryObject spawnEgg = EEItems.ITEMS.register(entityName + "_spawn_egg", () -> new EndergeticSpawnEgg(supplier, primaryColor, secondaryColor, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        EEItems.SPAWN_EGGS.add((RegistryObject<Item>)spawnEgg);
        return spawnEgg;
    }

    public static <B extends Block> RegistryObject<B> createBlockNoItem(String name, Supplier<? extends B> supplier) {
        RegistryObject block = EEBlocks.BLOCKS.register(name, supplier);
        return block;
    }

    public static <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = EEBlocks.BLOCKS.register(name, supplier);
        EEItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public static <B extends Block> RegistryObject<B> createBlockWithTESIR(String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = EEBlocks.BLOCKS.register(name, supplier);
        EEItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group).setTEISR(() -> EETileEntityItemRenderer::new)));
        return block;
    }

    public static <B extends Block> RegistryObject<B> createTallBlock(String name, Supplier<? extends B> supplier, ItemGroup group) {
        RegistryObject block = EEBlocks.BLOCKS.register(name, supplier);
        EEItems.ITEMS.register(name, () -> new TallBlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public static <B extends Block> RegistryObject<B> createCorrockStandingBlock(String name, Supplier<? extends B> standingSupplier, Supplier<? extends B> wallSupplier, @Nullable ItemGroup group) {
        RegistryObject standingBlock = EEBlocks.BLOCKS.register(name, standingSupplier);
        EEItems.ITEMS.register(name, () -> new ItemBlockCorrockCrownS((Block)standingBlock.get(), () -> RegistryUtils.lambda$null$5((Supplier)wallSupplier), new Item.Properties().func_200916_a(group)));
        return standingBlock;
    }

    public static <B extends Block> RegistryObject<B> createCompatBlock(String name, String modName, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        ItemGroup determinedGroup = ModList.get().isLoaded(modName) || modName == "indev" ? group : null;
        RegistryObject block = EEBlocks.BLOCKS.register(name, supplier);
        EEItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(determinedGroup)));
        return block;
    }

    private static /* synthetic */ Block lambda$null$5(Supplier wallSupplier) {
        return (Block)wallSupplier.get();
    }
}

