/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.blocks.poise;

import com.teamabnormals.abnormals_core.core.utils.ItemStackUtils;
import com.teamabnormals.abnormals_core.core.utils.MathUtils;
import endergeticexpansion.client.particle.EEParticles;
import endergeticexpansion.common.world.other.PoiseTree;
import endergeticexpansion.core.registry.EESounds;
import endergeticexpansion.core.registry.other.EETags;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class PoiseTallBushBlock
extends Block
implements IGrowable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final IntegerProperty STAGE = BlockStateProperties.field_208137_al;

    public PoiseTallBushBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(0))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World world, BlockPos pos, Random rand) {
        if (stateIn.func_177229_b(HALF) == DoubleBlockHalf.LOWER || rand.nextFloat() > 0.2f) {
            return;
        }
        double offsetX = MathUtils.makeNegativeRandomly((double)(rand.nextFloat() * 0.25f), (Random)rand);
        double offsetZ = MathUtils.makeNegativeRandomly((double)(rand.nextFloat() * 0.25f), (Random)rand);
        double x = (double)pos.func_177958_n() + 0.5 + offsetX;
        double y = (double)pos.func_177956_o() + 0.95 + (double)(rand.nextFloat() * 0.05f);
        double z = (double)pos.func_177952_p() + 0.5 + offsetZ;
        world.func_195594_a((IParticleData)EEParticles.POISE_BUBBLE.get(), x, y, z, 0.0, 0.0, 0.0);
        if (rand.nextInt(8) == 0) {
            float rngFloat = rand.nextFloat();
            SoundEvent soundToPlay = rngFloat > 0.9f ? (SoundEvent)EESounds.POISE_BUSH_AMBIENT_LONG.get() : (SoundEvent)EESounds.POISE_BUSH_AMBIENT.get();
            float volume = rngFloat < 0.9f ? 0.1f + rand.nextFloat() * 0.075f : 0.05f + rand.nextFloat() * 0.05f;
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundToPlay, SoundCategory.BLOCKS, volume, 0.9f + rand.nextFloat() * 0.15f, false);
        }
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public int func_149750_m(BlockState state) {
        return 10;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return (Integer)state.func_177229_b((IProperty)STAGE) <= 0;
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return block.func_203417_a(EETags.Blocks.POISE_PLANTABLE) || block.func_203417_a(EETags.Blocks.END_PLANTABLE);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.func_177229_b(HALF);
        if (facing.func_176740_k() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.func_177230_c() == this && facingState.func_177229_b(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        return blockpos.func_177956_o() < context.func_195991_k().func_201675_m().getHeight() - 1 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context) ? super.func_196258_a(context) : null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) != DoubleBlockHalf.UPPER) {
            return this.isValidGround(worldIn.func_180495_p(pos.func_177977_b()), (IBlockReader)worldIn, pos);
        }
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() != this) {
            this.isValidGround(worldIn.func_180495_p(pos.func_177977_b()), (IBlockReader)worldIn, pos);
        }
        return blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }

    public void placeAt(IWorld p_196390_1_, BlockPos p_196390_2_, int flags) {
        p_196390_1_.func_180501_a(p_196390_2_, (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER), flags);
        p_196390_1_.func_180501_a(p_196390_2_.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), flags);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) != doubleblockhalf) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                PoiseTallBushBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
                PoiseTallBushBlock.func_220054_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos, null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HALF, STAGE});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177979_c(state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).func_177956_o(), (int)pos.func_177952_p());
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return worldIn.field_73012_v.nextFloat() <= 0.35f;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    public void grow(ServerWorld worldIn, BlockPos pos, BlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)STAGE), 4);
        } else {
            if (!ForgeEventFactory.saplingGrowTree((IWorld)worldIn, (Random)rand, (BlockPos)pos)) {
                return;
            }
            PoiseTree tree = new PoiseTree();
            BlockPos treePos = state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
            tree.spawn((IWorld)worldIn, worldIn.func_72863_F().func_201711_g(), treePos, state, rand);
        }
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (ItemStackUtils.isInGroup((Item)this.func_199767_j(), (ItemGroup)group)) {
            int targetIndex = ItemStackUtils.findIndexOfItem((Item)Items.field_221918_fq, items);
            if (targetIndex != -1) {
                items.add(targetIndex + 1, (Object)new ItemStack((IItemProvider)this));
            } else {
                super.func_149666_a(group, items);
            }
        }
    }
}

