/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.tileentities;

import com.google.common.collect.Lists;
import endergeticexpansion.api.entity.util.DetectionHelper;
import endergeticexpansion.common.entities.puffbug.PuffBugEntity;
import endergeticexpansion.core.registry.EETileEntities;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PuffBugHiveTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final List<HiveOccupantData> hiveOccupants = Lists.newArrayList();
    private int ticksTillResetTeleport;
    private int teleportCooldown;
    private boolean shouldReset;

    public PuffBugHiveTileEntity() {
        super((TileEntityType)EETileEntities.PUFFBUG_HIVE.get());
    }

    public void func_73660_a() {
        World world = this.field_145850_b;
        if (!world.field_72995_K && !this.hiveOccupants.isEmpty()) {
            if (this.ticksTillResetTeleport > 0) {
                --this.ticksTillResetTeleport;
            } else if (this.shouldReset) {
                this.hiveOccupants.forEach(occupent -> ((HiveOccupantData)occupent).teleportSide = null);
                this.shouldReset = false;
            }
            if (this.teleportCooldown > 0) {
                --this.teleportCooldown;
            }
            for (int i = 0; i < this.hiveOccupants.size(); ++i) {
                HiveOccupantData hiveOccupant = this.hiveOccupants.get(i);
                if (hiveOccupant.occupant == null) {
                    this.hiveOccupants.remove(i);
                    continue;
                }
                hiveOccupant.tick(world);
            }
        }
    }

    public void addBugToHive(PuffBugEntity puffBug) {
        if (!this.isHiveFull()) {
            this.hiveOccupants.add(new HiveOccupantData(puffBug.func_110124_au()));
        }
    }

    public void alertPuffBugs(@Nullable LivingEntity breaker) {
        this.hiveOccupants.forEach(Occupant -> {
            PuffBugEntity puffBug = Occupant.getOccupant(this.field_145850_b);
            BlockPos hivePos = this.field_174879_c;
            if (puffBug != null) {
                if (puffBug.func_70638_az() == null) {
                    puffBug.setAttachedHiveSide(Direction.UP);
                    puffBug.tryToTeleportToHive(hivePos);
                }
                if (breaker == null) {
                    Object target = DetectionHelper.getClosestEntity(this.field_145850_b.func_175647_a(LivingEntity.class, new AxisAlignedBB(hivePos).func_186662_g(12.0), PuffBugEntity.CAN_ANGER), hivePos.func_177958_n(), hivePos.func_177956_o(), hivePos.func_177952_p());
                    if (target != null && puffBug.func_70638_az() == null) {
                        puffBug.func_70624_b((LivingEntity)target);
                    }
                } else {
                    puffBug.func_70624_b(breaker);
                    puffBug.setHivePos(null);
                }
            }
        });
        this.addTeleportCooldown();
    }

    public List<HiveOccupantData> getHiveOccupants() {
        return this.hiveOccupants;
    }

    public int getTotalBugsInHive() {
        return this.hiveOccupants.size();
    }

    public boolean isHiveFull() {
        return this.getTotalBugsInHive() >= 5;
    }

    public boolean canTeleportTo() {
        return this.teleportCooldown <= 0;
    }

    public void addTeleportCooldown() {
        this.teleportCooldown = 500;
    }

    @Nullable
    private HiveOccupantData getOccupentByUUID(UUID uuid) {
        for (HiveOccupantData occupents : this.hiveOccupants) {
            if (occupents.occupant != uuid) continue;
            return occupents;
        }
        return null;
    }

    public void setBeingTeleportedToBy(PuffBugEntity puffbug, Direction side) {
        HiveOccupantData occupentData = this.getOccupentByUUID(puffbug.func_110124_au());
        if (occupentData != null) {
            occupentData.teleportSide = side;
            this.ticksTillResetTeleport = 250;
            this.shouldReset = true;
        }
    }

    public boolean isSideBeingTeleportedTo(Direction side) {
        for (HiveOccupantData occupents : this.hiveOccupants) {
            if (occupents.teleportSide != side) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("HiveOccupants", (INBT)HiveOccupantData.createCompoundList(this));
        compound.func_74768_a("TeleportCooldown", this.teleportCooldown);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        this.hiveOccupants.clear();
        ListNBT Occupants = compound.func_150295_c("HiveOccupants", 10);
        for (int i = 0; i < Occupants.size(); ++i) {
            CompoundNBT Occupant = Occupants.func_150305_b(i);
            String OccupantUUID = Occupant.func_150297_b("OccupantUUID", 8) ? Occupant.func_74779_i("OccupantUUID") : "";
            UUID foundUUID = !OccupantUUID.isEmpty() ? UUID.fromString(OccupantUUID) : null;
            this.hiveOccupants.add(new HiveOccupantData(foundUUID));
        }
        this.teleportCooldown = compound.func_74762_e("TeleportCooldown");
        super.func_145839_a(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 9, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_183000_F() {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(1084.0);
    }

    public double func_145833_n() {
        return 16384.0;
    }

    public static class HiveOccupantData {
        @Nullable
        private UUID occupant;
        @Nullable
        private Direction teleportSide;

        public HiveOccupantData(@Nullable UUID occupant) {
            this.occupant = occupant;
        }

        public void tick(World world) {
            if (this.getOccupant(world) == null) {
                this.occupant = null;
            }
        }

        @Nullable
        public PuffBugEntity getOccupant(World world) {
            Entity entity;
            if (!world.field_72995_K && (entity = ((ServerWorld)world).func_217461_a(this.occupant)) instanceof PuffBugEntity) {
                return (PuffBugEntity)entity;
            }
            return null;
        }

        public static ListNBT createCompoundList(PuffBugHiveTileEntity hive) {
            ListNBT listnbt = new ListNBT();
            for (HiveOccupantData occuptentData : hive.hiveOccupants) {
                CompoundNBT compound = new CompoundNBT();
                if (occuptentData.occupant == null) {
                    compound.func_74778_a("OccupantUUID", "");
                } else {
                    compound.func_74778_a("OccupantUUID", occuptentData.occupant.toString());
                }
                listnbt.add((Object)compound);
            }
            return listnbt;
        }

        public static boolean isHiveSideEmpty(PuffBugHiveTileEntity hive, Direction direction) {
            for (int i = 0; i < hive.getTotalBugsInHive(); ++i) {
                PuffBugEntity bug = hive.getHiveOccupants().get(i).getOccupant(hive.field_145850_b);
                if (bug == null || bug.getAttachedHiveSide() != direction) continue;
                return false;
            }
            return true;
        }
    }
}

