/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.world;

import endergeticexpansion.common.world.util.EndergeticLayerUtil;
import endergeticexpansion.core.registry.EEBiomes;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProviderSettings;
import net.minecraft.world.gen.layer.Layer;

public class EndergeticBiomeProvider
extends EndBiomeProvider {
    private final Layer noiseBiomeLayer;
    private final SharedSeedRandom random;

    public EndergeticBiomeProvider(EndBiomeProviderSettings settings) {
        super(settings);
        this.random = new SharedSeedRandom(settings.func_205445_a());
        this.random.func_202423_a(17292);
        Layer[] alayer = EndergeticLayerUtil.createGenLayers(settings.func_205445_a(), WorldType.field_77137_b);
        this.noiseBiomeLayer = alayer[1];
    }

    public Biome func_225526_b_(int x, int y, int z) {
        int i = x >> 2;
        int j = z >> 2;
        if ((long)i * (long)i + (long)j * (long)j <= 4096L) {
            return Biomes.field_76779_k;
        }
        float f = this.func_222365_c(i * 2 + 1, j * 2 + 1);
        if (f >= 0.0f) {
            return this.isAreaChorus(x, z) ? super.func_225526_b_(x, y, z) : this.getBiomeForArea(x, z);
        }
        return f < -20.0f ? Biomes.field_201936_P : (this.isAreaChorus(x, z) ? super.func_225526_b_(x, y, z) : this.getBiomeForArea(x, z));
    }

    private Biome getChorusBiome(int x, int y, int z) {
        int i = x >> 2;
        int j = z >> 2;
        if ((long)i * (long)i + (long)j * (long)j <= 4096L) {
            return Biomes.field_76779_k;
        }
        float f = this.func_222365_c(i * 2 + 1, j * 2 + 1);
        if (f > 40.0f) {
            return (Biome)EEBiomes.END_HIGHLANDS.get();
        }
        if (f >= 0.0f) {
            return (Biome)EEBiomes.END_MIDLANDS.get();
        }
        return f < -20.0f ? Biomes.field_201936_P : Biomes.field_201939_S;
    }

    private boolean isAreaChorus(int x, int z) {
        return this.getBiomeForArea(x, z) == EEBiomes.CHORUS_PLAINS.get();
    }

    private Biome getBiomeForArea(int x, int z) {
        return this.noiseBiomeLayer.func_215738_a(x, z);
    }
}

