/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.core;

import com.teamabnormals.abnormals_core.core.library.api.AmbienceMusicPlayer;
import endergeticexpansion.client.particle.EEParticles;
import endergeticexpansion.client.render.entity.BolloomBalloonRenderer;
import endergeticexpansion.client.render.entity.BolloomFruitRenderer;
import endergeticexpansion.client.render.entity.BolloomKnotRenderer;
import endergeticexpansion.client.render.entity.BoofBlockRenderer;
import endergeticexpansion.client.render.entity.PoiseClusterRender;
import endergeticexpansion.client.render.entity.PuffBugRenderer;
import endergeticexpansion.client.render.entity.booflo.BoofloAdolescentRenderer;
import endergeticexpansion.client.render.entity.booflo.BoofloBabyRenderer;
import endergeticexpansion.client.render.entity.booflo.BoofloRenderer;
import endergeticexpansion.client.render.tile.BolloomBudTileEntityRenderer;
import endergeticexpansion.client.render.tile.BoofBlockTileEntityRenderer;
import endergeticexpansion.client.render.tile.CorrockCrownTileEntityRenderer;
import endergeticexpansion.client.render.tile.EndStoneCoverTileEntityRenderer;
import endergeticexpansion.client.render.tile.FrisbloomStemTileEntityRenderer;
import endergeticexpansion.client.render.tile.PuffBugHiveTileEntityRenderer;
import endergeticexpansion.common.network.entity.SBoofEntityMessage;
import endergeticexpansion.common.network.entity.SSetCooldownMessage;
import endergeticexpansion.common.network.entity.booflo.SIncrementBoostDelayMessage;
import endergeticexpansion.common.network.entity.booflo.SInflateMessage;
import endergeticexpansion.common.network.entity.booflo.SSetPlayerNotBoostingMessage;
import endergeticexpansion.common.network.entity.booflo.SSlamMessage;
import endergeticexpansion.common.network.entity.puffbug.RotateMessage;
import endergeticexpansion.common.network.nbt.SUpdateNBTTagMessage;
import endergeticexpansion.common.world.EEWorldGenHandler;
import endergeticexpansion.common.world.EndOverrideHandler;
import endergeticexpansion.common.world.biomes.EndergeticBiome;
import endergeticexpansion.common.world.features.EEFeatures;
import endergeticexpansion.common.world.surfacebuilders.EESurfaceBuilders;
import endergeticexpansion.core.config.EEConfig;
import endergeticexpansion.core.keybinds.KeybindHandler;
import endergeticexpansion.core.registry.EEBiomes;
import endergeticexpansion.core.registry.EEEntities;
import endergeticexpansion.core.registry.EESounds;
import endergeticexpansion.core.registry.EETileEntities;
import endergeticexpansion.core.registry.other.EEBlockRegistrars;
import endergeticexpansion.core.registry.other.EECapabilities;
import endergeticexpansion.core.registry.other.EEDataSerializers;
import endergeticexpansion.core.registry.other.EEDispenserBehaviors;
import endergeticexpansion.core.registry.other.EEFlammables;
import endergeticexpansion.core.registry.util.EndergeticRegistryHelper;
import java.util.Arrays;
import net.minecraft.client.renderer.entity.EnderCrystalRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="endergetic")
public class EndergeticExpansion {
    public static final String MOD_ID = "endergetic";
    public static final Logger LOGGER = LogManager.getLogger((String)"endergetic".toUpperCase());
    public static final String NETWORK_PROTOCOL = "EE1";
    public static EndergeticExpansion instance;
    public static final EndergeticRegistryHelper REGISTRY_HELPER;
    public static final SimpleChannel CHANNEL;

    public EndergeticExpansion() {
        instance = this;
        this.setupMessages();
        EEDataSerializers.registerSerializers();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        REGISTRY_HELPER.getDeferredItemRegister().register(modEventBus);
        REGISTRY_HELPER.getDeferredBlockRegister().register(modEventBus);
        REGISTRY_HELPER.getDeferredSoundRegister().register(modEventBus);
        REGISTRY_HELPER.getDeferredTileEntityRegister().register(modEventBus);
        EEParticles.PARTICLES.register(modEventBus);
        REGISTRY_HELPER.getDeferredEntityRegister().register(modEventBus);
        EESurfaceBuilders.SURFACE_BUILDERS.register(modEventBus);
        EEFeatures.FEATURES.register(modEventBus);
        EEBiomes.BIOMES.register(modEventBus);
        modEventBus.addListener(event -> {
            ModConfig config = event.getConfig();
            if (config.getSpec() == EEConfig.COMMON_SPEC) {
                EEConfig.ValuesHolder.updateCommonValuesFromConfig(config);
            }
        });
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(EventPriority.LOWEST, this::registerItemColors);
            modEventBus.addListener(EventPriority.LOWEST, this::setupClient);
        });
        modEventBus.addListener(EventPriority.LOWEST, this::setupCommon);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, EEConfig.COMMON_SPEC);
    }

    void setupCommon(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            EEDispenserBehaviors.registerAll();
            EEFlammables.registerFlammables();
            EEBiomes.applyBiomeInfo();
            EEBlockRegistrars.registerFireInfo();
            EEWorldGenHandler.overrideFeatures();
        });
        EECapabilities.registerCaps();
        EndOverrideHandler.overrideEndFactory();
    }

    @OnlyIn(value=Dist.CLIENT)
    void setupClient(FMLClientSetupEvent event) {
        EEBlockRegistrars.setupRenderLayers();
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.FRISBLOOM_STEM.get()), FrisbloomStemTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.CORROCK_CROWN.get()), CorrockCrownTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.ENDSTONE_COVER.get()), EndStoneCoverTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.BOLLOOM_BUD.get()), BolloomBudTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.PUFFBUG_HIVE.get()), PuffBugHiveTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EETileEntities.BOOF_BLOCK_DISPENSED.get()), BoofBlockTileEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOLLOOM_FRUIT.get()), BolloomFruitRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.POISE_CLUSTER.get()), PoiseClusterRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOOF_BLOCK.get()), BoofBlockRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOLLOOM_KNOT.get()), BolloomKnotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOLLOOM_BALLOON.get()), BolloomBalloonRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.PUFF_BUG.get()), PuffBugRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOOFLO_BABY.get()), BoofloBabyRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOOFLO_ADOLESCENT.get()), BoofloAdolescentRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EEEntities.BOOFLO.get()), BoofloRenderer::new);
        KeybindHandler.registerKeys();
        AmbienceMusicPlayer.registerBiomeAmbientSoundPlayer(Arrays.asList(() -> (EndergeticBiome)EEBiomes.POISE_FOREST.get()), () -> (SoundEvent)EESounds.POISE_FOREST_LOOP.get(), () -> (SoundEvent)EESounds.POISE_FOREST_ADDITIONS.get(), () -> (SoundEvent)EESounds.POISE_FOREST_MOOD.get());
        EnderCrystalRenderer.field_110787_a = new ResourceLocation(MOD_ID, "textures/entity/end_crystal.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item event) {
        REGISTRY_HELPER.processSpawnEggColors(event);
    }

    private void setupMessages() {
        int id = -1;
        CHANNEL.messageBuilder(SUpdateNBTTagMessage.class, id++).encoder(SUpdateNBTTagMessage::serialize).decoder(SUpdateNBTTagMessage::deserialize).consumer(SUpdateNBTTagMessage::handle).add();
        CHANNEL.messageBuilder(SSetCooldownMessage.class, id++).encoder(SSetCooldownMessage::serialize).decoder(SSetCooldownMessage::deserialize).consumer(SSetCooldownMessage::handle).add();
        CHANNEL.messageBuilder(SBoofEntityMessage.class, id++).encoder(SBoofEntityMessage::serialize).decoder(SBoofEntityMessage::deserialize).consumer(SBoofEntityMessage::handle).add();
        CHANNEL.messageBuilder(SInflateMessage.class, id++).encoder(SInflateMessage::serialize).decoder(SInflateMessage::deserialize).consumer(SInflateMessage::handle).add();
        CHANNEL.messageBuilder(SIncrementBoostDelayMessage.class, id++).encoder(SIncrementBoostDelayMessage::serialize).decoder(SIncrementBoostDelayMessage::deserialize).consumer(SIncrementBoostDelayMessage::handle).add();
        CHANNEL.messageBuilder(SSetPlayerNotBoostingMessage.class, id++).encoder(SSetPlayerNotBoostingMessage::serialize).decoder(SSetPlayerNotBoostingMessage::deserialize).consumer(SSetPlayerNotBoostingMessage::handle).add();
        CHANNEL.messageBuilder(SSlamMessage.class, id++).encoder(SSlamMessage::serialize).decoder(SSlamMessage::deserialize).consumer(SSlamMessage::handle).add();
        CHANNEL.messageBuilder(RotateMessage.class, id++).encoder(RotateMessage::serialize).decoder(RotateMessage::deserialize).consumer(RotateMessage::handle).add();
    }

    static {
        REGISTRY_HELPER = new EndergeticRegistryHelper(MOD_ID);
        CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MOD_ID, "net")).networkProtocolVersion(() -> NETWORK_PROTOCOL).clientAcceptedVersions(NETWORK_PROTOCOL::equals).serverAcceptedVersions(NETWORK_PROTOCOL::equals).simpleChannel();
    }
}

