/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.blocks;

import com.google.common.collect.Maps;
import endergeticexpansion.common.blocks.CorrockBlock;
import endergeticexpansion.core.events.PlayerEvents;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CorrockPlantBlock
extends Block
implements IWaterLoggable {
    private static final Map<DimensionType, Supplier<Block>> CONVERSIONS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), conversions -> {
        conversions.put(CorrockBlock.DimensionTypeAccessor.OVERWORLD, () -> (Block)EEBlocks.CORROCK_OVERWORLD.get());
        conversions.put(CorrockBlock.DimensionTypeAccessor.THE_NETHER, () -> (Block)EEBlocks.CORROCK_NETHER.get());
        conversions.put(CorrockBlock.DimensionTypeAccessor.THE_END, () -> (Block)EEBlocks.CORROCK_END.get());
    });
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    public final boolean petrified;

    public CorrockPlantBlock(AbstractBlock.Properties properties, boolean petrified) {
        super(properties);
        this.petrified = petrified;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return SoundType.field_211383_n;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!this.petrified && !this.isInProperDimension((World)world)) {
            world.func_175656_a(pos, ((Block)((Supplier)CONVERSIONS.getOrDefault(world.func_230315_m_(), (Supplier<Block>)EEBlocks.CORROCK_OVERWORLD)).get()).func_176223_P());
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            if (!this.petrified) {
                return PlayerEvents.convertCorrockBlock(stateIn);
            }
        }
        if (!this.isInProperDimension(worldIn.func_201672_e())) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 60 + worldIn.func_201674_k().nextInt(40));
        }
        return stateIn;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!this.isInProperDimension(context.func_195991_k())) {
            context.func_195991_k().func_205220_G_().func_205360_a(context.func_195995_a(), (Object)this, 60 + context.func_195991_k().func_201674_k().nextInt(40));
        }
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && fluidState.func_206882_g() >= 8));
    }

    public boolean isInProperDimension(World world) {
        return !this.petrified && ((Supplier)CONVERSIONS.getOrDefault(world.func_230315_m_(), (Supplier<Block>)EEBlocks.CORROCK_OVERWORLD)).get() == this;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.NONE;
    }
}

