/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.entities.booflo;

import com.google.common.collect.Maps;
import com.teamabnormals.abnormals_core.core.library.endimator.ControlledEndimation;
import com.teamabnormals.abnormals_core.core.library.endimator.Endimation;
import com.teamabnormals.abnormals_core.core.library.endimator.entity.EndimatedEntity;
import com.teamabnormals.abnormals_core.core.utils.MathUtils;
import com.teamabnormals.abnormals_core.core.utils.NetworkUtil;
import endergeticexpansion.api.entity.pathfinding.EndergeticFlyingPathNavigator;
import endergeticexpansion.api.entity.util.DetectionHelper;
import endergeticexpansion.api.entity.util.EntityItemStackHelper;
import endergeticexpansion.api.entity.util.RayTraceHelper;
import endergeticexpansion.client.particle.EEParticles;
import endergeticexpansion.common.advancement.EECriteriaTriggers;
import endergeticexpansion.common.blocks.poise.PoiseClusterBlock;
import endergeticexpansion.common.entities.bolloom.BolloomFruitEntity;
import endergeticexpansion.common.entities.booflo.BoofloAdolescentEntity;
import endergeticexpansion.common.entities.booflo.BoofloBabyEntity;
import endergeticexpansion.common.entities.booflo.ai.BoofloAttackGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloBoofGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloBreedGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloEatFruitGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloEatPuffBugGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloFaceRandomGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloGiveBirthGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloGroundHopGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloHuntFruitGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloHuntPuffBugGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloNearestAttackableTargetGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloSinkGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloSlamGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloSwimGoal;
import endergeticexpansion.common.entities.booflo.ai.BoofloTemptGoal;
import endergeticexpansion.common.entities.puffbug.PuffBugEntity;
import endergeticexpansion.core.registry.EEBlocks;
import endergeticexpansion.core.registry.EEEntities;
import endergeticexpansion.core.registry.EEItems;
import endergeticexpansion.core.registry.EESounds;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoofloEntity
extends EndimatedEntity {
    public static final Predicate<Entity> IS_SCARED_BY = entity -> {
        if (entity instanceof PlayerEntity) {
            return !entity.func_175149_v() && !((PlayerEntity)entity).func_184812_l_();
        }
        return false;
    };
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> LAST_FED_UNIQUE_ID = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> ON_GROUND = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MOVING_IN_AIR = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BOOFED = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PREGNANT = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HUNGRY = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_FRUIT = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DELAY_DECREMENTING = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_EXPANDING_DELAY = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PREV_PLAYER_BOOSTING = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PLAYER_BOOSTING = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> FRUITS_NEEDED = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RIDE_CONTROL_DELAY = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LOVE_TICKS = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ATTACK_TARGET = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BRACELETS_COLOR = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> BOOST_POWER = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> LOCKED_YAW = EntityDataManager.func_187226_a(BoofloEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final Endimation CROAK = new Endimation(55);
    public static final Endimation HOP = new Endimation(25);
    public static final Endimation HURT = new Endimation(15);
    public static final Endimation BIRTH = new Endimation(140);
    public static final Endimation INFLATE = new Endimation(10);
    public static final Endimation SWIM = new Endimation(20);
    public static final Endimation EAT = new Endimation(160);
    public static final Endimation CHARGE = new Endimation(75);
    public static final Endimation SLAM = new Endimation(10);
    public static final Endimation GROWL = new Endimation(60);
    private static final EntitySize BOOFED_SIZE = EntitySize.func_220311_c((float)2.0f, (float)1.5f);
    public final ControlledEndimation OPEN_JAW = new ControlledEndimation(25, 0);
    public final ControlledEndimation FRUIT_HOVER = new ControlledEndimation(8, 0);
    private final EndergeticFlyingPathNavigator attackingNavigator = new EndergeticFlyingPathNavigator((MobEntity)this, this.field_70170_p);
    private UUID playerInLove;
    public int hopDelay;
    public int breedDelay;
    private int croakDelay;
    private int deflateDelay;
    public boolean wasBred;
    private boolean shouldPlayLandSound;
    private boolean wasOnGround;

    public BoofloEntity(EntityType<? extends BoofloEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new GroundMoveHelperController(this);
        this.hopDelay = this.getDefaultGroundHopDelay();
        this.field_70138_W = 1.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
        this.func_184212_Q().func_187214_a(LAST_FED_UNIQUE_ID, Optional.empty());
        this.func_184212_Q().func_187214_a(ON_GROUND, (Object)false);
        this.func_184212_Q().func_187214_a(TAMED, (Object)false);
        this.func_184212_Q().func_187214_a(MOVING_IN_AIR, (Object)false);
        this.func_184212_Q().func_187214_a(BOOFED, (Object)false);
        this.func_184212_Q().func_187214_a(PREGNANT, (Object)false);
        this.func_184212_Q().func_187214_a(HUNGRY, (Object)(this.func_70681_au().nextFloat() < 0.6f ? 1 : 0));
        this.func_184212_Q().func_187214_a(HAS_FRUIT, (Object)false);
        this.func_184212_Q().func_187214_a(DELAY_DECREMENTING, (Object)false);
        this.func_184212_Q().func_187214_a(IS_EXPANDING_DELAY, (Object)false);
        this.func_184212_Q().func_187214_a(PREV_PLAYER_BOOSTING, (Object)false);
        this.func_184212_Q().func_187214_a(PLAYER_BOOSTING, (Object)false);
        this.func_184212_Q().func_187214_a(FRUITS_NEEDED, (Object)(this.func_70681_au().nextInt(3) + 2));
        this.func_184212_Q().func_187214_a(RIDE_CONTROL_DELAY, (Object)0);
        this.func_184212_Q().func_187214_a(LOVE_TICKS, (Object)0);
        this.func_184212_Q().func_187214_a(ATTACK_TARGET, (Object)0);
        this.func_184212_Q().func_187214_a(BRACELETS_COLOR, (Object)DyeColor.YELLOW.func_196059_a());
        this.func_184212_Q().func_187214_a(BOOST_POWER, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(LOCKED_YAW, (Object)Float.valueOf(0.0f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BoofloGiveBirthGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new BoofloEatPuffBugGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BoofloBoofGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BoofloSlamGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BoofloBreedGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BoofloEatFruitGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BoofloSinkGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new BoofloTemptGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new BoofloHuntPuffBugGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new BoofloAttackGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new BoofloHuntFruitGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new BoofloSwimGoal((CreatureEntity)this, 1.0, 15));
        this.field_70714_bg.func_75776_a(9, (Goal)new BoofloFaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new BoofloGroundHopGoal(this));
        this.field_70715_bh.func_75776_a(1, new BoofloNearestAttackableTargetGoal<PuffBugEntity>((MobEntity)this, PuffBugEntity.class, 175, true, false));
        this.field_70715_bh.func_75776_a(2, new BoofloNearestAttackableTargetGoal<BolloomFruitEntity>((MobEntity)this, BolloomFruitEntity.class, true));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.breedDelay > 0) {
            --this.breedDelay;
        }
        if (this.deflateDelay > 0) {
            --this.deflateDelay;
        }
        if (this.croakDelay > 0) {
            --this.croakDelay;
        }
        if (this.isBoofed()) {
            if (this.hasAggressiveAttackTarget()) {
                this.field_70699_by = this.attackingNavigator;
            } else {
                if (this.field_70699_by instanceof EndergeticFlyingPathNavigator) {
                    this.field_70699_by = new FlyingPathNavigator((MobEntity)this, this.field_70170_p){

                        public boolean func_188555_b(BlockPos pos) {
                            return this.field_75513_b.func_175623_d(pos);
                        }
                    };
                }
                if (this.getBoofloAttackTarget() == null && this.func_70781_l() && this.func_213322_ci().func_72433_c() < 0.25 && RayTraceHelper.rayTrace((Entity)this, 2.0, 1.0f).func_216346_c() == RayTraceResult.Type.BLOCK) {
                    this.func_70661_as().func_75499_g();
                }
            }
        }
        if (!this.isWorldRemote() && this.isEndimationPlaying(CHARGE) && this.getAnimationTick() >= 15) {
            this.func_70024_g(0.0, -0.225f, 0.0);
        }
        if (!this.isWorldRemote()) {
            this.setOnGround(!this.field_70170_p.func_226664_a_(DetectionHelper.checkOnGround(this.func_174813_aQ())));
            if (this.getRideControlDelay() > 0 && !this.isDelayExpanding() && this.isDelayDecrementing()) {
                this.setRideControlDelay(this.getRideControlDelay() - 2);
            } else if (this.isDelayExpanding() && this.getRideControlDelay() < 182) {
                this.setRideControlDelay(this.getRideControlDelay() + 10);
            }
            if (this.getRideControlDelay() >= 182 && this.isDelayExpanding()) {
                this.setDelayDecrementing(true);
                this.setDelayExpanding(false);
            }
            if (this.isDelayDecrementing() && this.getRideControlDelay() <= 0) {
                this.setDelayDecrementing(false);
            }
            if (this.isOnGround() && !this.isBoofed() && !this.isDelayDecrementing()) {
                this.setDelayDecrementing(true);
            }
            if (this.isBoofed() && !this.isOnGround()) {
                this.setBoofed(true);
            }
            if (this.isBoofed() && this.isNoEndimationPlaying() && this.isMovingInAir() && RayTraceHelper.rayTrace((Entity)this, 2.0, 1.0f).func_216346_c() != RayTraceResult.Type.BLOCK) {
                NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)SWIM);
            }
            if (this.isEndimationPlaying(SWIM) && this.getAnimationTick() <= 15) {
                this.setMovingInAir(true);
            }
            if (this.isEndimationPlaying(EAT) && this.getAnimationTick() > 20 && this.getAnimationTick() <= 140) {
                if (this.getAnimationTick() % 20 == 0) {
                    if (this.field_70170_p instanceof ServerWorld && this.hasCaughtFruit()) {
                        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)EEItems.BOLLOOM_FRUIT.get())), this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 1.5, this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
                    }
                    if (this.hasCaughtPuffBug()) {
                        ((Entity)this.func_184188_bt().get(0)).func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 0.0f);
                    }
                    this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                }
                if (this.getAnimationTick() == 140) {
                    this.setCaughtFruit(false);
                    this.func_70691_i(5.0f);
                    if (this.hasCaughtPuffBug()) {
                        this.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, 0.75f);
                        ((Entity)this.func_184188_bt().get(0)).func_70106_y();
                    }
                }
            }
            if (this.isEndimationPlaying(HOP) && this.getAnimationTick() == 10) {
                this.func_184185_a(this.getHopSound(false), 0.95f, this.func_70647_i());
                this.shouldPlayLandSound = true;
            }
            if (this.shouldPlayLandSound && this.field_70122_E && !this.wasOnGround) {
                this.func_184185_a(this.getHopSound(true), 0.95f, this.func_70647_i());
                this.shouldPlayLandSound = false;
            }
        }
        if (this.isEndimationPlaying(INFLATE) && this.getAnimationTick() == 2) {
            this.boof(1.0f, 1.0f);
        }
        if (!this.isWorldRemote() && this.isEndimationPlaying(GROWL)) {
            if (this.getAnimationTick() == 10) {
                this.func_184185_a(this.getGrowlSound(), 0.75f, this.func_70647_i());
            }
            if (this.getAnimationTick() >= 20) {
                for (PlayerEntity players : this.getNearbyPlayers(0.4f)) {
                    if (this.hasAggressiveAttackTarget()) continue;
                    this.setBoofloAttackTargetId(players.func_145782_y());
                }
            }
        }
        if (this.isEndimationPlaying(SLAM) && this.getAnimationTick() == 3) {
            this.boof(1.2f, 2.2f);
            this.func_184185_a(this.getSlamSound(), 0.75f, 1.0f);
        }
        if (this.func_70090_H()) {
            if (!this.isBoofed()) {
                this.setBoofed(true);
            } else if (this.isBoofed() && this.func_70681_au().nextFloat() < 0.7f) {
                this.func_70024_g(0.0, 0.05f, 0.0);
            }
        }
        if (this.isOnGround() && this.isBoofed()) {
            if (this.hasAggressiveAttackTarget() && !this.hasCaughtPuffBug()) {
                if (!this.isWorldRemote()) {
                    if (this.isNoEndimationPlaying()) {
                        NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)INFLATE);
                    } else if (this.isEndimationPlaying(CHARGE)) {
                        NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)SLAM);
                    }
                }
            } else if (this.func_184207_aI() && this.isEndimationPlaying(CHARGE)) {
                NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)SLAM);
            } else if (this.deflateDelay <= 0 && !this.isEndimationPlaying(SLAM) && !this.func_70090_H()) {
                this.setBoofed(false);
            }
        }
        if (this.func_70681_au().nextInt(40000) < 10 && !this.hasCaughtFruit() && !this.hasCaughtPuffBug()) {
            this.setHungry(true);
        }
        if (this.isWorldRemote() && this.isBoofed()) {
            this.OPEN_JAW.setDecrementing(this.getBoofloAttackTarget() == null || this.hasCaughtPuffBug() || this.hasAggressiveAttackTarget() && !(this.getBoofloAttackTarget() instanceof PuffBugEntity));
            this.OPEN_JAW.update();
            this.OPEN_JAW.tick();
        }
        this.FRUIT_HOVER.update();
        if (this.isEndimationPlaying(EAT)) {
            if (this.getAnimationTick() >= 20 && this.getAnimationTick() < 140) {
                if (this.getAnimationTick() % 10 == 0) {
                    if (this.getAnimationTick() == 20) {
                        this.FRUIT_HOVER.setDecrementing(false);
                        this.FRUIT_HOVER.setTick(0);
                    }
                    this.FRUIT_HOVER.setDecrementing(!this.FRUIT_HOVER.isDecrementing());
                }
            } else if (this.getAnimationTick() >= 140) {
                this.FRUIT_HOVER.setDecrementing(false);
            }
        }
        this.FRUIT_HOVER.tick();
        this.wasOnGround = this.field_70122_E;
        this.setPlayerWasBoosting(this.isPlayerBoosting());
        if (this.isEndimationPlaying(EAT) && !this.hasCaughtFruit()) {
            this.field_70759_as = this.field_70761_aq = this.getLockedYaw();
            this.field_70177_z = this.field_70761_aq;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.hopDelay > 0) {
            --this.hopDelay;
        }
        if (this.getInLoveTicks() > 0) {
            this.setInLove(this.getInLoveTicks() - 1);
            if (this.getInLoveTicks() % 10 == 0) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
            }
        }
        if (!this.isWorldRemote() && this.croakDelay == 0 && !this.isTempted() && this.func_70089_S() && this.field_70122_E && !this.isBoofed() && this.field_70146_Z.nextInt(1000) < this.field_70757_a++ && this.isNoEndimationPlaying() && this.func_184188_bt().isEmpty()) {
            this.field_70757_a = -this.func_70627_aG();
            NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)CROAK);
        }
        if (this.isEndimationPlaying(CROAK) && this.getAnimationTick() == 5 && !this.isWorldRemote()) {
            this.func_184185_a(this.func_184639_G(), 1.25f, this.func_70647_i());
        }
        if (this.hasAggressiveAttackTarget()) {
            this.field_70177_z = this.field_70759_as;
            Entity attackTarget = this.getBoofloAttackTarget();
            if (!this.isWorldRemote() && (this.func_70068_e(attackTarget) > 1152.0 || attackTarget.func_82150_aj() || attackTarget instanceof PuffBugEntity && attackTarget.func_184218_aH())) {
                this.setBoofloAttackTargetId(0);
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsMovingInAir", this.isMovingInAir());
        compound.func_74757_a("IsBoofed", this.isBoofed());
        compound.func_74757_a("IsPregnant", this.isPregnant());
        compound.func_74757_a("IsHungry", this.isHungry());
        compound.func_74757_a("HasFruit", this.hasCaughtFruit());
        compound.func_74757_a("IsDecrementingBoostTimer", this.isDelayDecrementing());
        compound.func_74757_a("IsDelayExpanding", this.isDelayExpanding());
        compound.func_74757_a("WasPlayerBoosting", this.wasPlayerBoosting());
        compound.func_74757_a("PlayerBoosting", this.isPlayerBoosting());
        compound.func_74757_a("WasBred", this.wasBred);
        compound.func_74768_a("FruitsNeededTillTamed", this.getFruitsNeededTillTamed());
        compound.func_74768_a("RideControlDelay", this.getRideControlDelay());
        compound.func_74768_a("InLove", this.getInLoveTicks());
        compound.func_74768_a("BoofloTargetId", this.getBoofloAttackTargetId());
        compound.func_74774_a("BraceletsColor", (byte)this.getBraceletsColor().func_196059_a());
        compound.func_74776_a("BoostPower", this.getBoostPower());
        compound.func_74776_a("BirthYaw", this.getLockedYaw());
        if (this.playerInLove != null) {
            compound.func_186854_a("LoveCause", this.playerInLove);
        }
        if (this.getOwnerId() != null) {
            compound.func_74778_a("Owner", this.getOwnerId().toString());
        }
        if (this.getLastFedId() != null) {
            compound.func_74778_a("LastFed", this.getLastFedId().toString());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        UUID lastFedUUID;
        super.func_70037_a(compound);
        this.setMovingInAir(compound.func_74767_n("IsMovingInAir"));
        this.setBoofed(compound.func_74767_n("IsBoofed"));
        this.setPregnant(compound.func_74767_n("IsPregnant"));
        this.setHungry(compound.func_74767_n("IsHungry"));
        this.setCaughtFruit(compound.func_74767_n("HasFruit"));
        this.setDelayDecrementing(compound.func_74767_n("IsDecrementingBoostTimer"));
        this.setDelayExpanding(compound.func_74767_n("IsDelayExpanding"));
        this.setPlayerWasBoosting(compound.func_74767_n("WasPlayerBoosting"));
        this.setPlayerBoosting(compound.func_74767_n("PlayerBoosting"));
        this.setRideControlDelay(compound.func_74762_e("RideControlDelay"));
        this.setInLove(compound.func_74762_e("InLove"));
        this.setBoofloAttackTargetId(compound.func_74762_e("BoofloTargetId"));
        this.setBoostPower(compound.func_74760_g("BoostPower"));
        this.setLockedYaw(compound.func_74760_g("BirthYaw"));
        this.playerInLove = compound.func_186855_b("LoveCause") ? compound.func_186857_a("LoveCause") : null;
        this.wasBred = compound.func_74767_n("WasBred");
        if (compound.func_150297_b("BraceletsColor", 99)) {
            this.setBraceletsColor(DyeColor.func_196056_a((int)compound.func_74762_e("BraceletsColor")));
        }
        if (compound.func_74764_b("FruitsNeededTillTamed")) {
            this.setFruitsNeeded(compound.func_74762_e("FruitsNeededTillTamed"));
        }
        UUID ownerUUID = compound.func_186855_b("Owner") ? compound.func_186857_a("Owner") : PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)compound.func_74779_i("Owner"));
        UUID uUID = lastFedUUID = compound.func_186855_b("LastFed") ? compound.func_186857_a("LastFed") : PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)compound.func_74779_i("LastFed"));
        if (ownerUUID != null) {
            try {
                this.setOwnerId(ownerUUID);
                this.setTamed(true);
            }
            catch (Throwable throwable) {
                this.setTamed(false);
            }
        }
        if (lastFedUUID != null) {
            try {
                this.setLastFedId(lastFedUUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (BOOFED.equals(key)) {
            this.func_213323_x_();
            if (this.isBoofed()) {
                this.field_70699_by = new FlyingPathNavigator((MobEntity)this, this.field_70170_p){

                    public boolean func_188555_b(BlockPos pos) {
                        return this.field_75513_b.func_175623_d(pos);
                    }
                };
                this.field_70765_h = new FlyingMoveController(this);
                this.field_70749_g = new FlyingLookController(this, 10);
                if (!this.isWorldRemote() && this.field_70173_aa > 5) {
                    this.func_184185_a(this.getInflateSound(), this.func_70599_aP(), this.func_70647_i());
                }
                this.deflateDelay = 10;
            } else {
                this.field_70699_by = this.func_175447_b(this.field_70170_p);
                this.field_70765_h = new GroundMoveHelperController(this);
                this.field_70749_g = new LookController((MobEntity)this);
                if (!this.isWorldRemote() && this.field_70173_aa > 5) {
                    this.func_184185_a(this.getDeflateSound(), this.func_70599_aP(), this.func_70647_i());
                }
                if (this.isWorldRemote()) {
                    this.OPEN_JAW.setTick(0);
                    this.setBoofloAttackTargetId(0);
                }
            }
        }
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.func_70089_S() && this.func_184207_aI() && this.func_82171_bF()) {
            LivingEntity rider = (LivingEntity)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = rider.field_70177_z;
            this.field_70125_A = 0.0f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            float playerMoveFoward = rider.field_191988_bg;
            if (!this.isWorldRemote() && playerMoveFoward > 0.0f) {
                if (this.isOnGround() && this.isNoEndimationPlaying() && !this.isBoofed()) {
                    NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)HOP);
                } else if (!this.isOnGround() && this.isNoEndimationPlaying() && this.isBoofed()) {
                    NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)SWIM);
                }
            }
            if (this.isBoofed()) {
                float gravity;
                float f = gravity = this.getRideControlDelay() > 0 ? 0.01f : 0.035f;
                if (this.func_70781_l()) {
                    this.func_70661_as().func_75499_g();
                }
                if (this.getBoofloAttackTarget() != null) {
                    this.setBoofloAttackTargetId(0);
                }
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
                if (!this.func_70090_H()) {
                    this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, (double)gravity, 0.0));
                }
            } else {
                if (this.field_70122_E && this.isEndimationPlaying(HOP) && this.getAnimationTick() == 10) {
                    Vector3d motion = this.func_213322_ci();
                    EffectInstance jumpBoost = this.func_70660_b(Effects.field_76430_j);
                    float boostPower = jumpBoost == null ? 1.0f : (float)(jumpBoost.func_76458_c() + 1);
                    this.func_213293_j(motion.field_72450_a, 0.55f * boostPower, motion.field_72449_c);
                    this.field_70160_al = true;
                    float xMotion = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)((float)Math.PI / 180));
                    float zMotion = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)((float)Math.PI / 180));
                    float multiplier = 0.35f + (float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e();
                    this.func_213317_d(this.func_213322_ci().func_72441_c((double)(xMotion * multiplier), 0.0, (double)(zMotion * multiplier)));
                }
                if (this.func_184186_bw()) {
                    super.func_213352_e(new Vector3d(0.0, vec3d.field_72448_b, 0.0));
                } else {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
            }
        } else if (this.func_70613_aW() && this.isBoofed()) {
            this.func_213309_a(0.0f, vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (!this.isMovingInAir()) {
                this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, 0.01, 0.0));
            }
        } else {
            super.func_213352_e(vec3d);
        }
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (reason == SpawnReason.NATURAL) {
            Random rand = new Random();
            if (rand.nextFloat() < 0.2f) {
                this.setPregnant(true);
            }
            this.setFruitsNeeded(rand.nextInt(3) + 2);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID ownerId) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(ownerId));
    }

    @Nullable
    public UUID getLastFedId() {
        return ((Optional)this.field_70180_af.func_187225_a(LAST_FED_UNIQUE_ID)).orElse(null);
    }

    public void setLastFedId(@Nullable UUID ownerId) {
        this.field_70180_af.func_187227_b(LAST_FED_UNIQUE_ID, Optional.ofNullable(ownerId));
    }

    public boolean isOnGround() {
        return (Boolean)this.field_70180_af.func_187225_a(ON_GROUND);
    }

    public void setOnGround(boolean onGround) {
        this.field_70180_af.func_187227_b(ON_GROUND, (Object)onGround);
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.field_70180_af.func_187227_b(TAMED, (Object)tamed);
    }

    public boolean isMovingInAir() {
        return (Boolean)this.func_184212_Q().func_187225_a(MOVING_IN_AIR);
    }

    public void setMovingInAir(boolean moving) {
        this.func_184212_Q().func_187227_b(MOVING_IN_AIR, (Object)moving);
    }

    public boolean isBoofed() {
        return (Boolean)this.field_70180_af.func_187225_a(BOOFED);
    }

    public void setBoofed(boolean boofed) {
        this.field_70180_af.func_187227_b(BOOFED, (Object)boofed);
        this.shouldPlayLandSound = false;
    }

    public boolean isPregnant() {
        return (Boolean)this.field_70180_af.func_187225_a(PREGNANT);
    }

    public void setPregnant(boolean pregnant) {
        this.field_70180_af.func_187227_b(PREGNANT, (Object)pregnant);
    }

    public boolean isHungry() {
        return (Boolean)this.field_70180_af.func_187225_a(HUNGRY);
    }

    public void setHungry(boolean hungry) {
        this.field_70180_af.func_187227_b(HUNGRY, (Object)hungry);
    }

    public boolean hasCaughtFruit() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_FRUIT);
    }

    public boolean hasCaughtPuffBug() {
        return !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof PuffBugEntity;
    }

    public void setCaughtFruit(boolean hasCaughtFruit) {
        this.field_70180_af.func_187227_b(HAS_FRUIT, (Object)hasCaughtFruit);
    }

    public boolean isDelayDecrementing() {
        return (Boolean)this.field_70180_af.func_187225_a(DELAY_DECREMENTING);
    }

    public void setDelayDecrementing(boolean decrementing) {
        this.field_70180_af.func_187227_b(DELAY_DECREMENTING, (Object)decrementing);
    }

    public boolean isDelayExpanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_EXPANDING_DELAY);
    }

    public void setDelayExpanding(boolean expandingDelay) {
        this.field_70180_af.func_187227_b(IS_EXPANDING_DELAY, (Object)expandingDelay);
    }

    public boolean wasPlayerBoosting() {
        return (Boolean)this.field_70180_af.func_187225_a(PREV_PLAYER_BOOSTING);
    }

    public void setPlayerWasBoosting(boolean wasBoosting) {
        this.field_70180_af.func_187227_b(PREV_PLAYER_BOOSTING, (Object)wasBoosting);
    }

    public boolean isPlayerBoosting() {
        return (Boolean)this.field_70180_af.func_187225_a(PLAYER_BOOSTING);
    }

    public void setPlayerBoosting(boolean isBoosting) {
        this.field_70180_af.func_187227_b(PLAYER_BOOSTING, (Object)isBoosting);
    }

    public float getLockedYaw() {
        return ((Float)this.field_70180_af.func_187225_a(LOCKED_YAW)).floatValue();
    }

    public void setLockedYaw(float yaw) {
        this.field_70180_af.func_187227_b(LOCKED_YAW, (Object)Float.valueOf(yaw));
    }

    public float getBoostPower() {
        return ((Float)this.field_70180_af.func_187225_a(BOOST_POWER)).floatValue();
    }

    public void setBoostPower(float boostPower) {
        this.field_70180_af.func_187227_b(BOOST_POWER, (Object)Float.valueOf(boostPower));
    }

    public int getBoofloAttackTargetId() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TARGET);
    }

    @Nullable
    public Entity getBoofloAttackTarget() {
        Entity entity = this.field_70170_p.func_73045_a(this.getBoofloAttackTargetId());
        if (entity == null || entity != null && !entity.func_70089_S() || entity instanceof BoofloEntity) {
            this.setBoofloAttackTargetId(0);
        }
        if (this.getOwner() != null && this.getOwner() == entity) {
            this.setBoofloAttackTargetId(0);
        }
        return this.getBoofloAttackTargetId() > 0 ? entity : null;
    }

    public boolean hasAggressiveAttackTarget() {
        return this.getBoofloAttackTarget() instanceof LivingEntity;
    }

    public void setBoofloAttackTargetId(int id) {
        this.field_70180_af.func_187227_b(ATTACK_TARGET, (Object)id);
    }

    public void setInLove(@Nullable PlayerEntity player) {
        this.setInLove(600);
        if (player != null) {
            this.playerInLove = player.func_110124_au();
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public void setFruitsNeeded(int fruitsNeeded) {
        this.field_70180_af.func_187227_b(FRUITS_NEEDED, (Object)fruitsNeeded);
    }

    public int getFruitsNeededTillTamed() {
        return (Integer)this.field_70180_af.func_187225_a(FRUITS_NEEDED);
    }

    public void setRideControlDelay(int ticks) {
        this.field_70180_af.func_187227_b(RIDE_CONTROL_DELAY, (Object)ticks);
    }

    public int getRideControlDelay() {
        return (Integer)this.field_70180_af.func_187225_a(RIDE_CONTROL_DELAY);
    }

    public DyeColor getBraceletsColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(BRACELETS_COLOR)));
    }

    public void setBraceletsColor(DyeColor color) {
        this.field_70180_af.func_187227_b(BRACELETS_COLOR, (Object)color.func_196059_a());
    }

    public void setInLove(int ticks) {
        this.field_70180_af.func_187227_b(LOVE_TICKS, (Object)ticks);
    }

    public int getInLoveTicks() {
        return (Integer)this.field_70180_af.func_187225_a(LOVE_TICKS);
    }

    public boolean canBreed() {
        return this.isTamed() && this.getInLoveTicks() <= 0 && !this.isPregnant() && this.breedDelay <= 0;
    }

    public boolean isInLove() {
        if (this.isPregnant()) {
            return false;
        }
        return this.getInLoveTicks() > 0;
    }

    public void resetInLove() {
        this.setInLove(0);
    }

    @Nullable
    public ServerPlayerEntity getLoveCause() {
        if (this.playerInLove == null) {
            return null;
        }
        PlayerEntity playerentity = this.field_70170_p.func_217371_b(this.playerInLove);
        return playerentity instanceof ServerPlayerEntity ? (ServerPlayerEntity)playerentity : null;
    }

    public void setTamedBy(PlayerEntity player) {
        this.setTamed(true);
        this.setOwnerId(player.func_110124_au());
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            CriteriaTriggers.field_193136_w.func_193178_a(serverPlayer, (AnimalEntity)EntityType.field_200724_aC.func_200721_a(this.field_70170_p));
            if (!this.isWorldRemote()) {
                EECriteriaTriggers.TAME_BOOFLO.trigger(serverPlayer);
            }
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    @Nullable
    public LivingEntity getLastFedPlayer() {
        try {
            UUID uuid = this.getLastFedId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    public boolean canMateWith(BoofloEntity possibleMate) {
        if (possibleMate == this) {
            return false;
        }
        return this.isInLove() && possibleMate.isInLove();
    }

    public int getDefaultGroundHopDelay() {
        return this.isInLove() ? this.field_70146_Z.nextInt(10) + 25 : this.field_70146_Z.nextInt(40) + 80;
    }

    public void boof(float internalStrength, float offensiveStrength) {
        float verticalStrength = 1.0f;
        if (this.getBoostPower() > 0.0f && !this.isEndimationPlaying(SLAM)) {
            internalStrength *= this.getBoostPower();
            offensiveStrength *= MathHelper.func_76131_a((float)(this.getBoostPower() / 2.0f), (float)0.5f, (float)1.85f);
            float xMotion = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
            float zMotion = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
            float multiplier = (double)this.getBoostPower() > 0.35 ? this.getBoostPower() * 2.0f : this.getBoostPower();
            Vector3d boostFowardForce = new Vector3d((double)xMotion, (double)(1.3f * (verticalStrength *= MathHelper.func_76131_a((float)this.getBoostPower(), (float)0.35f, (float)1.5f))), (double)zMotion).func_72432_b().func_186678_a((double)multiplier);
            this.func_213293_j(boostFowardForce.func_82615_a(), 1.3f * verticalStrength, boostFowardForce.func_82616_c());
        } else {
            this.func_70024_g(-MathHelper.func_76126_a((float)((float)((double)this.field_70177_z * Math.PI / 180.0))) * (4.0f * internalStrength * (this.field_70146_Z.nextFloat() + 0.1f)) * 0.1f, 1.3f * verticalStrength, MathHelper.func_76134_b((float)((float)((double)this.field_70177_z * Math.PI / 180.0))) * (4.0f * internalStrength * (this.field_70146_Z.nextFloat() + 0.1f)) * 0.1f);
        }
        if (offensiveStrength > 2.0f) {
            for (int i = 0; i < 12; ++i) {
                double offsetX = MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.25f), (Random)this.field_70146_Z);
                double offsetZ = MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.25f), (Random)this.field_70146_Z);
                double x = this.func_226277_ct_() + 0.5 + offsetX;
                double y = this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * 0.05f);
                double z = this.func_226281_cx_() + 0.5 + offsetZ;
                if (!this.isWorldRemote()) continue;
                this.field_70170_p.func_195594_a((IParticleData)EEParticles.POISE_BUBBLE.get(), x, y, z, MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.3f), (Random)this.field_70146_Z) + (double)0.025f, (double)(this.field_70146_Z.nextFloat() * 0.15f + 0.1f), MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextFloat() * 0.3f), (Random)this.field_70146_Z) + (double)0.025f);
            }
        }
        for (Entity entity : this.field_70170_p.func_217357_a(Entity.class, this.func_174813_aQ().func_186662_g((double)(3.5f * MathHelper.func_76131_a((float)(offensiveStrength / 2.0f), (float)1.0f, (float)(offensiveStrength / 2.0f)))))) {
            boolean flyingPlayerFlag;
            boolean bl = flyingPlayerFlag = !(entity instanceof PlayerEntity) || !((PlayerEntity)entity).func_184812_l_() || !((PlayerEntity)entity).field_71075_bZ.field_75100_b;
            if (entity == this || !(entity instanceof ItemEntity) && !(entity instanceof LivingEntity) || !flyingPlayerFlag) continue;
            float resistancy = this.isResistantToBoof(entity) ? 0.15f : 1.0f;
            float amount = 0.2f * offensiveStrength * resistancy;
            if (offensiveStrength > 2.0f && resistancy > 0.15f && entity != this.func_184179_bs()) {
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
                entity.field_70133_I = false;
            }
            Vector3d result = entity.func_213303_ch().func_178788_d(this.func_213303_ch());
            entity.func_70024_g(result.field_72450_a * (double)amount, ((double)this.field_70146_Z.nextFloat() * 0.75 + 0.25) * (double)(offensiveStrength * 0.75f), result.field_72449_c * (double)amount);
        }
        this.setBoostPower(0.0f);
    }

    public void growDown() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            BoofloAdolescentEntity boofloAdolescent = (BoofloAdolescentEntity)((EntityType)EEEntities.BOOFLO_ADOLESCENT.get()).func_200721_a(this.field_70170_p);
            boofloAdolescent.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            if (this.func_145818_k_()) {
                boofloAdolescent.func_200203_b(this.func_200201_e());
                boofloAdolescent.func_174805_g(this.func_174833_aM());
            }
            if (this.func_110167_bD()) {
                boofloAdolescent.func_110162_b(this.func_110166_bE(), true);
                this.func_110160_i(true, false);
            }
            if (this.func_184187_bx() != null) {
                boofloAdolescent.func_184220_m(this.func_184187_bx());
            }
            boofloAdolescent.wasBred = this.wasBred;
            boofloAdolescent.func_70606_j(boofloAdolescent.func_110138_aP());
            this.field_70170_p.func_217376_c((Entity)boofloAdolescent);
            this.func_70106_y();
        }
    }

    public void catchPuffBug(PuffBugEntity puffbug) {
        puffbug.func_184205_a((Entity)this, true);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isTamed() && !this.wasBred && !this.isPregnant();
    }

    public boolean isTempted() {
        for (Object goals : this.field_70714_bg.func_220888_c().toArray()) {
            if (!(goals instanceof PrioritizedGoal)) continue;
            return ((PrioritizedGoal)goals).func_220772_j() instanceof BoofloTemptGoal;
        }
        return false;
    }

    public List<PlayerEntity> getNearbyPlayers(float multiplier) {
        return this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b((double)(8.0f * multiplier), 4.0, (double)(8.0f * multiplier)), IS_SCARED_BY);
    }

    public boolean isPlayerNear(float multiplier) {
        return !this.getNearbyPlayers(multiplier).isEmpty();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.isBoofed() ? 1.2f : 0.9f;
    }

    public int func_70627_aG() {
        return 120;
    }

    public Endimation[] getEndimations() {
        return new Endimation[]{CROAK, HOP, HURT, BIRTH, INFLATE, SWIM, EAT, CHARGE, SLAM, GROWL};
    }

    public Endimation getHurtAnimation() {
        return HURT;
    }

    public void onEndimationStart(Endimation endimation) {
        if (endimation == SWIM) {
            float pitch = this.func_184207_aI() ? 1.0f : this.field_70125_A;
            float xMotion = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
            float yMotion = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
            float zMotion = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
            double motionScale = this.hasAggressiveAttackTarget() && !this.hasCaughtPuffBug() || !this.func_184188_bt().isEmpty() && !this.hasCaughtPuffBug() ? (double)0.85f : 0.5;
            Vector3d motion = new Vector3d((double)xMotion, (double)yMotion, (double)zMotion).func_72432_b().func_216372_d(motionScale, 0.5, motionScale);
            this.func_70024_g(motion.field_72450_a * (this.func_110148_a(Attributes.field_233821_d_).func_111126_e() - (double)0.05f), motion.field_72448_b, motion.field_72449_c * (this.func_110148_a(Attributes.field_233821_d_).func_111126_e() - (double)0.05f));
        }
    }

    protected void func_70664_aZ() {
        Vector3d vec3d = this.func_213322_ci();
        this.func_213293_j(vec3d.field_72450_a, 0.55, vec3d.field_72449_c);
        this.field_70160_al = true;
    }

    protected void func_82167_n(Entity entity) {
        if (entity instanceof BoofloBabyEntity && (((BoofloBabyEntity)entity).isBeingBorn() || ((BoofloBabyEntity)entity).getMotherNoClipTicks() > 0)) {
            return;
        }
        super.func_82167_n(entity);
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item instanceof SpawnEggItem && ((SpawnEggItem)item).func_208077_a(itemstack.func_77978_p(), this.func_200600_R())) {
            if (!this.isWorldRemote()) {
                BoofloBabyEntity baby = (BoofloBabyEntity)((EntityType)EEEntities.BOOFLO_BABY.get()).func_200721_a(this.field_70170_p);
                baby.setGrowingAge(-24000);
                baby.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)baby);
                if (itemstack.func_82837_s()) {
                    baby.func_200203_b(itemstack.func_200301_q());
                }
                EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            }
            return ActionResultType.CONSUME;
        }
        if (!this.isWorldRemote() && item == ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_199767_j() && this.canBreed()) {
            EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            this.setInLove(player);
            return ActionResultType.CONSUME;
        }
        if (item == EEItems.BOLLOOM_FRUIT.get() && !this.func_213398_dR() && !this.hasCaughtFruit() && this.field_70122_E) {
            BasicParticleType particle = ParticleTypes.field_197633_z;
            EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            this.setCaughtFruit(true);
            this.setHungry(false);
            if (!this.isTamed()) {
                if (this.getFruitsNeededTillTamed() >= 1) {
                    this.setFruitsNeeded(this.getFruitsNeededTillTamed() - 1);
                    this.setLastFedId(player.func_110124_au());
                    particle = ParticleTypes.field_197601_L;
                    if (!this.isWorldRemote()) {
                        NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)GROWL);
                    }
                } else if (player == this.getLastFedPlayer()) {
                    this.setFruitsNeeded(0);
                    this.setTamedBy(player);
                    this.croakDelay = 40;
                }
            }
            if (this.isWorldRemote()) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)particle, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
                }
            }
            return ActionResultType.CONSUME;
        }
        if (item instanceof DyeItem && this.isTamed()) {
            DyeColor dyecolor = ((DyeItem)item).func_195962_g();
            if (dyecolor != this.getBraceletsColor()) {
                this.setBraceletsColor(dyecolor);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return ActionResultType.CONSUME;
            }
        } else {
            ActionResultType result = itemstack.func_111282_a_(player, (LivingEntity)this, hand);
            if (result != ActionResultType.PASS && result != ActionResultType.FAIL || item == EEItems.BOLLOOM_FRUIT.get() || item == ((PoiseClusterBlock)EEBlocks.POISE_CLUSTER.get()).func_199767_j()) {
                return ActionResultType.PASS;
            }
            if (this.isTamed() && !this.func_184207_aI() && !this.isPregnant()) {
                if (!this.field_70170_p.field_72995_K) {
                    player.field_70177_z = this.field_70177_z;
                    player.field_70125_A = this.field_70125_A;
                    player.func_184220_m((Entity)this);
                }
                return ActionResultType.PASS;
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            if (passenger instanceof BoofloBabyEntity) {
                double xOffset;
                int passengerIndex = this.func_184188_bt().indexOf(passenger);
                double d = xOffset = passengerIndex == 0 ? 0.25 : -0.25;
                double zOffset = passengerIndex == 0 ? 0.0 : (passengerIndex == 1 ? -0.25 : 0.25);
                Vector3d ridingOffset = new Vector3d(xOffset, 0.0, zOffset).func_178785_b(-this.getLockedYaw() * ((float)Math.PI / 180) - 1.5707964f);
                passenger.func_70107_b(this.func_226277_ct_() + ridingOffset.field_72450_a, this.func_226278_cu_() + (double)0.9f, this.func_226281_cx_() + ridingOffset.field_72449_c);
            } else if (passenger instanceof PuffBugEntity) {
                PuffBugEntity puffbug = (PuffBugEntity)passenger;
                puffbug.field_70761_aq = puffbug.field_70759_as = this.field_70177_z - 75.0f;
                passenger.field_70177_z = puffbug.field_70759_as;
                if (this.isEndimationPlaying(EAT) && this.getAnimationTick() > 15) {
                    Vector3d ridingPos = new Vector3d(1.0, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
                    float yOffset = puffbug.func_70631_g_() ? 0.1f : 0.3f;
                    passenger.func_70107_b(this.func_226277_ct_() + ridingPos.func_82615_a(), this.func_226278_cu_() - (double)yOffset - (double)(0.15f * this.FRUIT_HOVER.getAnimationProgressServer()), this.func_226281_cx_() + ridingPos.func_82616_c());
                } else {
                    passenger.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 0.25, this.func_226281_cx_());
                }
            } else {
                super.func_184232_k(passenger);
                if (passenger instanceof MobEntity) {
                    this.field_70761_aq = ((MobEntity)passenger).field_70761_aq;
                }
            }
        }
    }

    public double func_70042_X() {
        double original = super.func_70042_X();
        return this.isBoofed() ? original + (double)0.15f : original;
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof PlayerEntity;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    protected boolean func_184219_q(Entity passenger) {
        int limit = this.isPregnant() ? 3 : 1;
        return this.func_184188_bt().size() < limit;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entitySource = source.func_76346_g();
        if (entitySource instanceof LivingEntity && !this.func_184207_aI()) {
            if (entitySource instanceof PlayerEntity) {
                if (!entitySource.func_175149_v() && !((PlayerEntity)entitySource).func_184812_l_()) {
                    this.setBoofloAttackTargetId(entitySource.func_145782_y());
                }
            } else {
                this.setBoofloAttackTargetId(entitySource.func_145782_y());
            }
        }
        float newCalculatedDamage = source == DamageSource.field_76368_d ? 0.5f : amount;
        return super.func_70097_a(source, source.func_76346_g() instanceof PuffBugEntity ? 2.5f : newCalculatedDamage);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        Entity entitySource = damageSrc.func_76346_g();
        if (entitySource instanceof LivingEntity && !this.func_184207_aI()) {
            if (entitySource instanceof PlayerEntity) {
                if (!entitySource.func_175149_v() && !((PlayerEntity)entitySource).func_184812_l_()) {
                    this.setBoofloAttackTargetId(entitySource.func_145782_y());
                }
            } else {
                this.setBoofloAttackTargetId(entitySource.func_145782_y());
            }
        }
        super.func_70665_d(damageSrc, damageAmount);
    }

    public int func_184649_cE() {
        return 1;
    }

    public int func_70641_bl() {
        return 3;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isBoofed() ? BOOFED_SIZE : super.func_213305_a(poseIn);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    protected boolean isResistantToBoof(Entity entity) {
        return entity instanceof BoofloEntity || entity instanceof BoofloAdolescentEntity || entity instanceof BoofloBabyEntity;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70642_aH() {
    }

    public SoundEvent getHopSound(boolean landing) {
        return landing ? (SoundEvent)EESounds.BOOFLO_HOP_LAND.get() : (SoundEvent)EESounds.BOOFLO_HOP.get();
    }

    public SoundEvent getGrowlSound() {
        return (SoundEvent)EESounds.BOOFLO_GROWL.get();
    }

    public SoundEvent getSlamSound() {
        return (SoundEvent)EESounds.BOOFLO_SLAM.get();
    }

    public SoundEvent getInflateSound() {
        return (SoundEvent)EESounds.BOOFLO_INFLATE.get();
    }

    protected SoundEvent getDeflateSound() {
        return (SoundEvent)EESounds.BOOFLO_DEFLATE.get();
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)EESounds.BOOFLO_CROAK.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)EESounds.BOOFLO_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)EESounds.BOOFLO_HURT.get();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)EEItems.BOOFLO_SPAWN_EGG.get());
    }

    public String getNameSuffix() {
        Map customSkins = (Map)Util.func_200696_a((Object)Maps.newHashMap(), skins -> {
            skins.put(Arrays.asList("cameron"), "cam");
            skins.put(Arrays.asList("snakeblock", "theforsakenone"), "snake");
        });
        if (this.func_145818_k_()) {
            for (Map.Entry entries : customSkins.entrySet()) {
                if (!((List)entries.getKey()).contains(this.func_200200_C_().getString().toLowerCase().replaceAll("\\s+", ""))) continue;
                return "_" + (String)entries.getValue();
            }
        }
        return "";
    }

    class FlyingLookController
    extends LookController {
        private final int angleLimit;

        public FlyingLookController(BoofloEntity booflo, int angleLimit) {
            super((MobEntity)booflo);
            this.angleLimit = angleLimit;
        }

        public void func_75649_a() {
            if (this.field_75655_d) {
                this.field_75655_d = false;
                this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.func_220678_h() + 20.0f, this.field_75657_b);
                this.field_75659_a.field_70125_A = this.func_220675_a(this.field_75659_a.field_70125_A, this.func_220677_g() + 10.0f, this.field_75658_c);
            } else {
                if (this.field_75659_a.func_70661_as().func_75500_f()) {
                    this.field_75659_a.field_70125_A = this.func_220675_a(this.field_75659_a.field_70125_A, 0.0f, 5.0f);
                }
                this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.field_75659_a.field_70761_aq, this.field_75657_b);
            }
            float wrappedDegrees = MathHelper.func_76142_g((float)(this.field_75659_a.field_70759_as - this.field_75659_a.field_70761_aq));
            if (wrappedDegrees < (float)(-this.angleLimit)) {
                this.field_75659_a.field_70761_aq -= 4.0f;
            } else if (wrappedDegrees > (float)this.angleLimit) {
                this.field_75659_a.field_70761_aq += 4.0f;
            }
            if (((BoofloEntity)this.field_75659_a).isEndimationPlaying(CHARGE)) {
                this.field_75659_a.field_70125_A = this.func_220675_a(this.field_75659_a.field_70125_A, 0.0f, 10.0f);
            }
        }
    }

    public class FlyingMoveController
    extends MovementController {
        private final BoofloEntity booflo;

        public FlyingMoveController(BoofloEntity booflo) {
            super((MobEntity)booflo);
            this.booflo = booflo;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.booflo.func_70661_as().func_75500_f()) {
                if (this.booflo.hasAggressiveAttackTarget()) {
                    Vector3d vec3d = this.booflo.getMoveControllerPathDistance(this.field_75646_b, this.field_75647_c, this.field_75644_d);
                    this.booflo.field_70761_aq = this.booflo.field_70177_z = this.func_75639_a(this.booflo.field_70177_z, this.booflo.getTargetAngleForPathDistance(vec3d), 10.0f);
                    this.booflo.field_70759_as = this.booflo.field_70177_z;
                    float f1 = (float)(2.0 * this.booflo.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                    float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.booflo.func_70689_ay(), (float)f1);
                    this.booflo.func_70659_e(f2);
                } else {
                    Vector3d vec3d = new Vector3d(this.field_75646_b - this.booflo.func_226277_ct_(), this.field_75647_c - this.booflo.func_226278_cu_(), this.field_75644_d - this.booflo.func_226281_cx_());
                    double d0 = vec3d.func_72433_c();
                    double d1 = vec3d.field_72448_b / d0;
                    float f = (float)(MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) * 57.2957763671875) - 90.0f;
                    this.booflo.field_70761_aq = this.booflo.field_70177_z = this.func_75639_a(this.booflo.field_70177_z, f, 10.0f);
                    this.booflo.field_70759_as = this.booflo.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.booflo.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                    float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.booflo.func_70689_ay(), (float)f1);
                    this.booflo.func_70659_e(f2);
                    double d3 = Math.cos(this.booflo.field_70177_z * ((float)Math.PI / 180));
                    double d4 = Math.sin(this.booflo.field_70177_z * ((float)Math.PI / 180));
                    double d5 = Math.sin((double)(this.booflo.field_70173_aa + this.booflo.func_145782_y()) * 0.75) * 0.05;
                    if (!this.booflo.func_70090_H()) {
                        float f3 = -((float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)MathHelper.func_76133_a((double)(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c))) * 57.2957763671875));
                        f3 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f3), (float)-85.0f, (float)85.0f);
                        this.booflo.field_70125_A = this.func_75639_a(this.booflo.field_70125_A, f3, 5.0f);
                    }
                    this.booflo.func_213317_d(this.booflo.func_213322_ci().func_72441_c(0.0, d5 * (d4 + d3) * 0.25 + (double)f2 * d1 * 0.02, 0.0));
                }
                this.booflo.setMovingInAir(true);
            } else {
                this.booflo.func_70659_e(0.0f);
                this.booflo.setMovingInAir(false);
            }
        }
    }

    public static class GroundMoveHelperController
    extends MovementController {
        private final BoofloEntity booflo;
        private float yRot;
        public int hopDelay;
        public boolean isAggressive;

        public GroundMoveHelperController(BoofloEntity booflo) {
            super((MobEntity)booflo);
            this.booflo = booflo;
            this.yRot = (float)((double)(180.0f * booflo.field_70177_z) / Math.PI);
        }

        public void setDirection(float yRot, boolean aggressive) {
            this.yRot = yRot;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speed) {
            this.field_75645_e = speed;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            if (!this.booflo.hasCaughtPuffBug()) {
                this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
                this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            }
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.func_233570_aj_()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(Attributes.field_233821_d_).func_111126_e()));
                    if (this.booflo.hopDelay == 0 && this.booflo.isEndimationPlaying(HOP) && this.booflo.getAnimationTick() == 10) {
                        this.booflo.func_70683_ar().func_75660_a();
                        this.booflo.hopDelay = this.booflo.getDefaultGroundHopDelay();
                    } else {
                        this.booflo.field_70702_br = 0.0f;
                        this.booflo.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e(0.0f);
                }
            }
        }
    }
}

