/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.items;

import endergeticexpansion.common.entities.bolloom.BolloomBalloonEntity;
import endergeticexpansion.common.entities.bolloom.BolloomKnotEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BolloomBalloonItem
extends Item {
    @Nullable
    private final DyeColor balloonColor;

    public BolloomBalloonItem(Item.Properties properties, @Nullable DyeColor balloonColor) {
        super(properties);
        this.balloonColor = balloonColor;
    }

    @Nullable
    public DyeColor getBalloonColor() {
        return this.balloonColor;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof FenceBlock) {
            if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j() && world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150353_l && world.func_180495_p(pos.func_177981_b(2)).func_185904_a().func_76222_j() && world.func_180495_p(pos.func_177981_b(2)).func_177230_c() != Blocks.field_150353_l && world.func_180495_p(pos.func_177981_b(3)).func_185904_a().func_76222_j() && world.func_180495_p(pos.func_177981_b(3)).func_177230_c() != Blocks.field_150353_l) {
                if (!world.field_72995_K) {
                    this.attachToFence(pos, world, context.func_195996_i());
                }
            } else {
                return ActionResultType.FAIL;
            }
            for (Entity entity : world.func_217357_a(Entity.class, new AxisAlignedBB(pos))) {
                if (!(entity instanceof BolloomKnotEntity) || !((BolloomKnotEntity)entity).hasMaxBalloons()) continue;
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }

    public void attachToFence(BlockPos fencePos, World world, ItemStack stack) {
        for (Entity entity : world.func_217357_a(Entity.class, new AxisAlignedBB(fencePos))) {
            if (!(entity instanceof BolloomKnotEntity) || ((BolloomKnotEntity)entity).hasMaxBalloons()) continue;
            BolloomKnotEntity setKnot = BolloomKnotEntity.getKnotForPosition(world, fencePos);
            setKnot.addBalloon(this.getBalloonColor());
            stack.func_190918_g(1);
        }
        if (BolloomKnotEntity.getKnotForPosition(world, fencePos) == null) {
            BolloomKnotEntity.createStartingKnot(world, fencePos, this.getBalloonColor());
            stack.func_190918_g(1);
        }
    }

    public static class BalloonDispenseBehavior
    extends DefaultDispenseItemBehavior {
        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
            World world = source.func_197524_h();
            BlockState state = world.func_180495_p(blockpos);
            if (state.func_185904_a().func_76222_j() && stack.func_77973_b() instanceof BolloomBalloonItem) {
                BolloomBalloonEntity balloon = new BolloomBalloonEntity(world, blockpos);
                balloon.setColor(((BolloomBalloonItem)stack.func_77973_b()).getBalloonColor());
                world.func_217376_c((Entity)balloon);
                stack.func_190918_g(1);
            } else {
                if (!state.func_185904_a().func_76222_j() && !state.func_177230_c().func_203417_a((ITag)BlockTags.field_219748_G)) {
                    return super.func_82487_b(source, stack);
                }
                if (state.func_177230_c().func_203417_a((ITag)BlockTags.field_219748_G)) {
                    if (BolloomKnotEntity.getKnotForPosition(world, blockpos) == null && stack.func_77973_b() instanceof BolloomBalloonItem) {
                        BolloomKnotEntity.createStartingKnot(world, blockpos, ((BolloomBalloonItem)stack.func_77973_b()).getBalloonColor());
                        stack.func_190918_g(1);
                        return stack;
                    }
                    for (Entity entity : world.func_217357_a(Entity.class, new AxisAlignedBB(blockpos))) {
                        if (!(entity instanceof BolloomKnotEntity) || !(stack.func_77973_b() instanceof BolloomBalloonItem)) continue;
                        if (!((BolloomKnotEntity)entity).hasMaxBalloons()) {
                            BolloomKnotEntity setKnot = BolloomKnotEntity.getKnotForPosition(world, blockpos);
                            setKnot.addBalloon(((BolloomBalloonItem)stack.func_77973_b()).getBalloonColor());
                            stack.func_190918_g(1);
                            continue;
                        }
                        return super.func_82487_b(source, stack);
                    }
                } else {
                    return super.func_82487_b(source, stack);
                }
            }
            return stack;
        }
    }
}

