/*
 * Decompiled with CFR 0.152.
 */
package endergeticexpansion.common.world.features.corrock;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.abnormals_core.core.library.GenerationPiece;
import endergeticexpansion.common.blocks.CorrockCrownStandingBlock;
import endergeticexpansion.common.blocks.CorrockCrownWallBlock;
import endergeticexpansion.common.world.features.EEFeatures;
import endergeticexpansion.common.world.features.corrock.AbstractCorrockFeature;
import endergeticexpansion.core.registry.EEBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class CorrockBranchFeature
extends AbstractCorrockFeature {
    public CorrockBranchFeature(Codec<ProbabilityConfig> configFactory) {
        super(configFactory);
    }

    public boolean func_230362_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, BlockPos pos, ProbabilityConfig config) {
        int baseHeight = rand.nextInt(4) + 4;
        if (rand.nextFloat() > config.field_203622_a) {
            return false;
        }
        ArrayList chorusGrowths = Lists.newArrayList();
        Block belowBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (belowBlock == EEBlocks.CORROCK_END_BLOCK.get() || belowBlock == Blocks.field_150377_bs) {
            int branchCount;
            GenerationPiece[] branchPieces;
            GenerationPiece basePiece = new GenerationPiece((iworld, part) -> world.func_175623_d(part.pos));
            this.createBase(basePiece, (IWorld)world, pos, rand, baseHeight);
            if (basePiece.canPlace((IWorld)world) && (branchPieces = this.createBranches(chorusGrowths, (IWorld)world, pos, rand, branchCount = rand.nextBoolean() ? 1 : rand.nextInt(3) + 1, baseHeight))[0].canPlace((IWorld)world)) {
                basePiece.place((IWorld)world);
                branchPieces[0].place((IWorld)world);
                for (AbstractCorrockFeature.ChorusPlantPart chorusParts : this.getAllChorusPartsMatchingPiece(chorusGrowths, branchPieces[0])) {
                    chorusParts.placeCoveredGrowth((IWorld)world, rand);
                }
                if (branchCount > 1) {
                    if (branchPieces[1].canPlace((IWorld)world)) {
                        branchPieces[1].place((IWorld)world);
                        for (AbstractCorrockFeature.ChorusPlantPart chorusParts : this.getAllChorusPartsMatchingPiece(chorusGrowths, branchPieces[1])) {
                            chorusParts.placeCoveredGrowth((IWorld)world, rand);
                        }
                    }
                    if (branchCount > 2 && branchPieces[2].canPlace((IWorld)world)) {
                        branchPieces[2].place((IWorld)world);
                        for (AbstractCorrockFeature.ChorusPlantPart chorusParts : this.getAllChorusPartsMatchingPiece(chorusGrowths, branchPieces[2])) {
                            chorusParts.placeCoveredGrowth((IWorld)world, rand);
                        }
                    }
                }
                BlockPos downPos = pos.func_177977_b();
                BlockPos groundModifierPos = new BlockPos(downPos.func_177958_n() + (rand.nextInt(3) - rand.nextInt(3)), downPos.func_177956_o(), downPos.func_177952_p() + (rand.nextInt(3) - rand.nextInt(3)));
                ((Feature)EEFeatures.GROUND_PATCH.get()).func_230362_a_(world, manager, generator, rand, groundModifierPos, (IFeatureConfig)new SphereReplaceConfig((BlockState)this.CORROCK_BLOCK.get(), 3, 3, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150377_bs.func_176223_P()})));
                BlockPos.Mutable corrockPlantPos = new BlockPos.Mutable();
                for (int x = pos.func_177958_n() - 4; x < pos.func_177958_n() + 4; ++x) {
                    for (int y = pos.func_177956_o(); y < pos.func_177956_o() + baseHeight + 10; ++y) {
                        for (int z = pos.func_177952_p() - 4; z < pos.func_177952_p() + 4; ++z) {
                            boolean isCorrockBelow;
                            corrockPlantPos.func_181079_c(x, y, z);
                            boolean bl = isCorrockBelow = world.func_180495_p(corrockPlantPos.func_177977_b()).func_177230_c() == EEBlocks.CORROCK_END_BLOCK.get();
                            if (!(isCorrockBelow && rand.nextFloat() < 0.5f) && (isCorrockBelow || !(rand.nextFloat() < 0.025f)) || !world.func_175623_d((BlockPos)corrockPlantPos) || !((BlockState)this.CORROCK.get()).func_196955_c((IWorldReader)world, (BlockPos)corrockPlantPos)) continue;
                            world.func_180501_a((BlockPos)corrockPlantPos, (BlockState)this.CORROCK.get(), 2);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private GenerationPiece[] createBranches(List<AbstractCorrockFeature.ChorusPlantPart> chorusGrowths, IWorld world, BlockPos pos, Random rand, int count, int height) {
        GenerationPiece[] pieces = new GenerationPiece[count];
        for (int i = 0; i < pieces.length; ++i) {
            pieces[i] = this.createBranch(chorusGrowths, world, pos, rand, height);
        }
        return pieces;
    }

    private GenerationPiece createBranch(List<AbstractCorrockFeature.ChorusPlantPart> chorusGrowths, IWorld world, BlockPos pos, Random rand, int height) {
        GenerationPiece basePiece = new GenerationPiece((iworld, part) -> world.func_175623_d(part.pos));
        BlockPos startPos = pos.func_177981_b(height - 1);
        Direction horizontalStep = this.randomHorizontalDirection(rand);
        boolean shouldStep = rand.nextBoolean();
        if (shouldStep) {
            for (int y = 0; y < 3; ++y) {
                basePiece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), startPos.func_177972_a(horizontalStep).func_177981_b(y));
            }
            int branchHeight = rand.nextInt(3) + 4;
            int sideYPos = branchHeight / 2;
            for (int y = 0; y < branchHeight; ++y) {
                basePiece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), startPos.func_177967_a(horizontalStep, 2).func_177981_b(2).func_177981_b(y));
                if (y != branchHeight - 1 || !(rand.nextFloat() < 0.85f)) continue;
                this.createCrownOrbit(null, basePiece, world, startPos.func_177967_a(horizontalStep, 2).func_177981_b(2).func_177981_b(y), rand);
            }
            Direction sideStep = this.randomHorizontalDirection(rand);
            for (int offset = 0; offset < 2; ++offset) {
                basePiece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), startPos.func_177967_a(horizontalStep, 2).func_177967_a(sideStep, offset).func_177981_b(2).func_177981_b(sideYPos));
            }
            int lastBranchHeight = rand.nextInt(3) + 4;
            for (int y = 0; y < lastBranchHeight; ++y) {
                basePiece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), startPos.func_177967_a(horizontalStep, 2).func_177967_a(sideStep, 2).func_177981_b(2).func_177981_b(sideYPos).func_177981_b(y));
                if (y != lastBranchHeight - 1 || !(rand.nextFloat() < 0.85f)) continue;
                this.createCrownOrbit(chorusGrowths, basePiece, world, startPos.func_177967_a(horizontalStep, 2).func_177967_a(sideStep, 2).func_177981_b(2).func_177981_b(sideYPos).func_177981_b(y), rand);
            }
        } else {
            int firstBranchHeight = rand.nextInt(3) + 4;
            int secondBranchYPos = firstBranchHeight / 2;
            for (int y = 0; y < firstBranchHeight; ++y) {
                basePiece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), startPos.func_177972_a(horizontalStep).func_177981_b(y));
                if (y != firstBranchHeight - 1 || !rand.nextBoolean()) continue;
                this.createCrownOrbit(null, basePiece, world, startPos.func_177972_a(horizontalStep).func_177981_b(y), rand);
            }
            Direction sideStep = rand.nextFloat() < 0.6f ? horizontalStep : (rand.nextBoolean() ? horizontalStep.func_176746_e() : horizontalStep.func_176735_f());
            for (int offset = 0; offset < 2; ++offset) {
                basePiece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), startPos.func_177981_b(secondBranchYPos).func_177972_a(horizontalStep).func_177967_a(sideStep, offset));
            }
            int lastBranchHeight = rand.nextInt(3) + 4;
            for (int y = 0; y < lastBranchHeight; ++y) {
                basePiece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), startPos.func_177981_b(secondBranchYPos).func_177972_a(horizontalStep).func_177967_a(sideStep, 2).func_177981_b(y));
                if (y != lastBranchHeight - 1 || !(rand.nextFloat() < 0.85f)) continue;
                this.createCrownOrbit(chorusGrowths, basePiece, world, startPos.func_177981_b(secondBranchYPos).func_177972_a(horizontalStep).func_177967_a(sideStep, 2).func_177981_b(y), rand);
            }
        }
        return basePiece;
    }

    private void createBase(GenerationPiece piece, IWorld world, BlockPos pos, Random rand, int height) {
        for (int y = 0; y < height; ++y) {
            piece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), pos.func_177981_b(y));
            if (y != height - 1 || !(rand.nextFloat() < 0.85f)) continue;
            piece.addBlockPiece(this.randomStandingCorrockCrown(rand), pos.func_177981_b(height));
        }
        for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 2; ++x) {
            for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 2; ++z) {
                BlockPos currentPos;
                if (!(rand.nextFloat() < 0.4f) || !this.tryToMakeAreaBelowPlacableOn(piece, world, currentPos = new BlockPos(x, pos.func_177956_o(), z))) continue;
                int randSideHeight = rand.nextInt(height - 1) + 1;
                for (int y = 0; y < randSideHeight; ++y) {
                    piece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), currentPos.func_177981_b(y));
                }
            }
        }
    }

    private void createCrownOrbit(@Nullable List<AbstractCorrockFeature.ChorusPlantPart> chorusGrowths, GenerationPiece branch, IWorld world, BlockPos pos, Random rand) {
        boolean addedChorusGrowth = false;
        for (Direction horizontals : Direction.Plane.HORIZONTAL) {
            BlockPos placingPos = pos.func_177972_a(horizontals);
            if (rand.nextFloat() < 0.35f && world.func_175623_d(placingPos)) {
                branch.addBlockPiece((BlockState)this.CORROCK_CROWN(true).get().func_206870_a((Property)CorrockCrownWallBlock.FACING, (Comparable)horizontals), placingPos);
                continue;
            }
            if (chorusGrowths == null || !world.func_175623_d(placingPos) || !(rand.nextFloat() < 0.3f) || addedChorusGrowth) continue;
            chorusGrowths.add(new AbstractCorrockFeature.ChorusPlantPart(branch, placingPos, horizontals));
            addedChorusGrowth = true;
        }
        if (rand.nextBoolean()) {
            branch.addBlockPiece(this.randomStandingCorrockCrown(rand), pos.func_177984_a());
        }
    }

    private boolean tryToMakeAreaBelowPlacableOn(GenerationPiece piece, IWorld world, BlockPos pos) {
        boolean[] flags = new boolean[]{world.func_175623_d(pos.func_177977_b()), world.func_175623_d(pos.func_177979_c(2)), world.func_175623_d(pos.func_177979_c(3))};
        if (flags[0]) {
            if (flags[2]) {
                return false;
            }
            piece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), pos.func_177977_b());
            if (flags[1]) {
                piece.addBlockPiece((BlockState)this.CORROCK_BLOCK.get(), pos.func_177979_c(2));
            }
        }
        return true;
    }

    public List<AbstractCorrockFeature.ChorusPlantPart> getAllChorusPartsMatchingPiece(List<AbstractCorrockFeature.ChorusPlantPart> parts, GenerationPiece piece) {
        List<AbstractCorrockFeature.ChorusPlantPart> newParts = parts;
        newParts.removeIf(part -> part.piece != piece);
        return newParts;
    }

    private Direction randomHorizontalDirection(Random rand) {
        return Direction.func_82600_a((int)(rand.nextInt(4) + 2));
    }

    private BlockState randomStandingCorrockCrown(Random rand) {
        return (BlockState)this.CORROCK_CROWN(false).get().func_206870_a((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(rand.nextInt(16)));
    }
}

