/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core;

import cofh.core.client.renderer.entity.SpriteRendererCoFH;
import cofh.core.client.renderer.entity.TNTRendererCoFH;
import cofh.core.client.renderer.model.SimpleModelLoader;
import cofh.core.client.renderer.model.entity.ArmorModelFullSuit;
import cofh.core.registries.DeferredRegisterCoFH;
import cofh.core.util.FeatureRecipeCondition;
import cofh.core.util.ProxyUtils;
import cofh.thermal.core.client.gui.device.DeviceHiveExtractorScreen;
import cofh.thermal.core.client.gui.device.DeviceTreeExtractorScreen;
import cofh.thermal.core.client.gui.workbench.TinkerBenchScreen;
import cofh.thermal.core.client.renderer.entity.BasalzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BasalzRenderer;
import cofh.thermal.core.client.renderer.entity.BlitzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BlitzRenderer;
import cofh.thermal.core.client.renderer.entity.BlizzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BlizzRenderer;
import cofh.thermal.core.client.renderer.model.DynamoBakedModel;
import cofh.thermal.core.client.renderer.model.ReconfigurableBakedModel;
import cofh.thermal.core.client.renderer.model.UnderlayBakedModel;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.common.ThermalFeatures;
import cofh.thermal.core.common.ThermalRecipeManagers;
import cofh.thermal.core.init.TCoreBlocks;
import cofh.thermal.core.init.TCoreEntities;
import cofh.thermal.core.init.TCoreFluids;
import cofh.thermal.core.init.TCoreItems;
import cofh.thermal.core.init.TCoreRecipeManagers;
import cofh.thermal.core.init.TCoreRecipeSerializers;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.core.util.loot.TileNBTSync;
import cofh.thermal.core.world.ThermalWorld;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="thermal")
public class ThermalCore {
    public static final Logger LOG = LogManager.getLogger((String)"thermal");
    public static final DeferredRegisterCoFH<Block> BLOCKS = new DeferredRegisterCoFH(ForgeRegistries.BLOCKS, "thermal");
    public static final DeferredRegisterCoFH<Fluid> FLUIDS = new DeferredRegisterCoFH(ForgeRegistries.FLUIDS, "thermal");
    public static final DeferredRegisterCoFH<Item> ITEMS = new DeferredRegisterCoFH(ForgeRegistries.ITEMS, "thermal");
    public static final DeferredRegisterCoFH<ContainerType<?>> CONTAINERS = new DeferredRegisterCoFH(ForgeRegistries.CONTAINERS, "thermal");
    public static final DeferredRegisterCoFH<EntityType<?>> ENTITIES = new DeferredRegisterCoFH(ForgeRegistries.ENTITIES, "thermal");
    public static final DeferredRegisterCoFH<IRecipeSerializer<?>> RECIPE_SERIALIZERS = new DeferredRegisterCoFH(ForgeRegistries.RECIPE_SERIALIZERS, "thermal");
    public static final DeferredRegisterCoFH<SoundEvent> SOUND_EVENTS = new DeferredRegisterCoFH(ForgeRegistries.SOUND_EVENTS, "thermal");
    public static final DeferredRegisterCoFH<TileEntityType<?>> TILE_ENTITIES = new DeferredRegisterCoFH(ForgeRegistries.TILE_ENTITIES, "thermal");

    public ThermalCore() {
        this.setFeatureFlags();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(this::recipesUpdated);
        BLOCKS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        ENTITIES.register(modEventBus);
        FLUIDS.register(modEventBus);
        ITEMS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        ThermalConfig.register();
        CraftingHelper.register((IConditionSerializer)new FeatureRecipeCondition.Serializer(ThermalFeatures.manager(), new ResourceLocation("thermal", "flag")));
    }

    private void setFeatureFlags() {
        ThermalFeatures.setFeature(ThermalFeatures.FLAG_RESOURCE_NITER, true);
        ThermalFeatures.setFeature(ThermalFeatures.FLAG_RESOURCE_SULFUR, true);
        ThermalFeatures.setFeature(ThermalFeatures.FLAG_RESOURCE_COPPER, true);
        ThermalFeatures.setFeature(ThermalFeatures.FLAG_RESOURCE_TIN, true);
        ThermalFeatures.setFeature(ThermalFeatures.FLAG_RESOURCE_LEAD, true);
        ThermalFeatures.setFeature(ThermalFeatures.FLAG_RESOURCE_SILVER, true);
        ThermalFeatures.setFeature(ThermalFeatures.FLAG_RESOURCE_NICKEL, true);
        ThermalFeatures.setFeature(ThermalFeatures.FLAG_AREA_AUGMENTS, true);
        ThermalFeatures.setFeature(ThermalFeatures.FLAG_STORAGE_AUGMENTS, true);
        ThermalFeatures.setFeature(ThermalFeatures.FLAG_UPGRADE_AUGMENTS, true);
        ThermalFeatures.setFeature("tinker_bench", true);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(TCoreBlocks::setup);
        DeferredWorkQueue.runLater(TCoreItems::setup);
        DeferredWorkQueue.runLater(TCoreEntities::setup);
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new TileNBTSync.Serializer());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_HIVE_EXTRACTOR_CONTAINER, DeviceHiveExtractorScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_TREE_EXTRACTOR_CONTAINER, DeviceTreeExtractorScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.TINKER_BENCH_CONTAINER, TinkerBenchScreen::new);
        RenderType cutout = RenderType.func_228643_e_();
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("obsidian_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("signalum_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("lumium_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("enderium_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("machine_frame")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("device_tree_extractor")), (RenderType)cutout);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("thermal", "underlay"), (IModelLoader)new SimpleModelLoader(UnderlayBakedModel::new));
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("thermal", "dynamo"), (IModelLoader)new SimpleModelLoader(DynamoBakedModel::new));
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("thermal", "reconfigurable"), (IModelLoader)new SimpleModelLoader(ReconfigurableBakedModel::new));
        ProxyUtils.addModel((Item)((Item)ITEMS.get("beekeeper_helmet")), (Object)ArmorModelFullSuit.LARGE);
        ProxyUtils.addModel((Item)((Item)ITEMS.get("beekeeper_chestplate")), (Object)ArmorModelFullSuit.DEFAULT);
        ProxyUtils.addModel((Item)((Item)ITEMS.get("diving_helmet")), (Object)ArmorModelFullSuit.LARGE);
        ProxyUtils.addModel((Item)((Item)ITEMS.get("diving_chestplate")), (Object)ArmorModelFullSuit.DEFAULT);
        ProxyUtils.addModel((Item)((Item)ITEMS.get("hazmat_helmet")), (Object)ArmorModelFullSuit.LARGE);
        ProxyUtils.addModel((Item)((Item)ITEMS.get("hazmat_chestplate")), (Object)ArmorModelFullSuit.DEFAULT);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BASALZ_ENTITY, BasalzRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLITZ_ENTITY, BlitzRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLIZZ_ENTITY, BlizzRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BASALZ_PROJECTILE_ENTITY, BasalzProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLITZ_PROJECTILE_ENTITY, BlitzProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLIZZ_PROJECTILE_ENTITY, BlizzProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.EXPLOSIVE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.PHYTO_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.FIRE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.EARTH_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.ICE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.LIGHTNING_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.NUKE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.PHYTO_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.FIRE_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.EARTH_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.ICE_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.LIGHTNING_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.NUKE_TNT_ENTITY, TNTRendererCoFH::new);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        ThermalRecipeManagers.instance().setServerRecipeManager(event.getServer().func_199529_aN());
        ThermalWorld.setup();
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new ReloadListener<Void>(){

            protected Void prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
                return null;
            }

            protected void apply(Void nothing, IResourceManager resourceManagerIn, IProfiler profilerIn) {
                ThermalRecipeManagers.instance().refreshServer();
            }
        });
    }

    private void serverStarted(FMLServerStartedEvent event) {
    }

    private void serverStopping(FMLServerStoppingEvent event) {
    }

    private void serverStopped(FMLServerStoppedEvent event) {
        ThermalRecipeManagers.instance().setServerRecipeManager(null);
    }

    private void recipesUpdated(RecipesUpdatedEvent event) {
        ThermalRecipeManagers.instance().refreshClient(event.getRecipeManager());
    }

    static {
        TCoreBlocks.register();
        TCoreItems.register();
        TCoreFluids.register();
        TCoreEntities.register();
        TCoreSounds.register();
        TCoreRecipeManagers.register();
        TCoreRecipeSerializers.register();
        TCoreRecipeTypes.register();
    }
}

