/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.gui;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.ElementEnergyStorage;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.inventory.container.ContainerCoFH;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.GuiHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermal.core.client.gui.ThermalGuiHelper;
import cofh.thermal.core.client.gui.ThermalScreenBase;
import cofh.thermal.core.tileentity.DynamoTileBase;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DynamoScreenBase<T extends ContainerCoFH>
extends ThermalScreenBase<T> {
    protected DynamoTileBase tile;

    public DynamoScreenBase(T container, PlayerInventory inv, DynamoTileBase tile, ITextComponent titleIn) {
        super(container, inv, tile, titleIn);
        this.tile = tile;
    }

    @Override
    public void init() {
        super.init();
        this.addPanel((PanelBase)ThermalGuiHelper.createDefaultEnergyProducerPanel((IGuiAccess)this, this.tile));
        if (this.tile.getEnergyStorage().getMaxEnergyStored() > 0) {
            ElementEnergyStorage throttle = (ElementEnergyStorage)new ElementEnergyStorage((IGuiAccess)this, 125, 22, this.tile.getEnergyStorage()){

                public void addTooltip(List<ITextComponent> tooltipList, int mouseX, int mouseY) {
                    tooltipList.add(new TranslationTextComponent("info.cofh.output", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(": " + StringHelper.DF0.format(100.0 * (double)DynamoScreenBase.this.tile.getCurSpeed() / (double)DynamoScreenBase.this.tile.getMaxSpeed()) + "%")));
                }
            }.setSize(16, 42).setTexture("cofh_core:textures/gui/elements/storage_energy.png", 32, 64);
            this.addElement((ElementBase)GuiHelper.setClearable((ElementEnergyStorage)throttle, (TileCoFH)this.tile, (int)0));
        }
    }
}

