/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.gui;

import cofh.core.client.gui.CoreTextures;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementConditionalLayered;
import cofh.core.client.gui.element.ElementScaled;
import cofh.core.client.gui.element.ElementScaledFluid;
import cofh.core.client.gui.element.panel.PanelResource;
import cofh.core.util.GuiHelper;
import cofh.core.util.constants.Constants;
import cofh.core.util.control.IReconfigurable;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermal.core.client.gui.ThermalTextures;
import cofh.thermal.core.tileentity.ReconfigurableTile4Way;
import cofh.thermal.core.tileentity.ThermalTileBase;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class ThermalGuiHelper {
    private ThermalGuiHelper() {
    }

    public static ElementConditionalLayered createDefaultMachineConfigTop(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String specificTexture = "thermal:block/machines/machine_" + machine + "_top";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(RenderHelper.textureExists((ResourceLocation)new ResourceLocation(specificTexture)) ? specificTexture : "thermal:block/machines/machine_top", Constants.TRUE).addSprite(ThermalTextures.MACHINE_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(Direction.UP) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.MACHINE_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(Direction.UP) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.MACHINE_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(Direction.UP) == IReconfigurable.SideConfig.SIDE_BOTH).addSprite(ThermalTextures.MACHINE_CONFIG_ACCESSIBLE, () -> tile.reconfigControl().getSideConfig(Direction.UP) == IReconfigurable.SideConfig.SIDE_ACCESSIBLE).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultMachineConfigBottom(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String specificTexture = "thermal:block/machines/machine_" + machine + "_bottom";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(RenderHelper.textureExists((ResourceLocation)new ResourceLocation(specificTexture)) ? specificTexture : "thermal:block/machines/machine_bottom", Constants.TRUE).addSprite(ThermalTextures.MACHINE_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(Direction.DOWN) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.MACHINE_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(Direction.DOWN) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.MACHINE_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(Direction.DOWN) == IReconfigurable.SideConfig.SIDE_BOTH).addSprite(ThermalTextures.MACHINE_CONFIG_ACCESSIBLE, () -> tile.reconfigControl().getSideConfig(Direction.DOWN) == IReconfigurable.SideConfig.SIDE_ACCESSIBLE).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultMachineConfigLeft(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String specificTexture = "thermal:block/machines/machine_" + machine + "_side";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(RenderHelper.textureExists((ResourceLocation)new ResourceLocation(specificTexture)) ? specificTexture : "thermal:block/machines/machine_side", Constants.TRUE).addSprite(ThermalTextures.MACHINE_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.left((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.MACHINE_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.left((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.MACHINE_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(BlockHelper.left((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_BOTH).addSprite(ThermalTextures.MACHINE_CONFIG_ACCESSIBLE, () -> tile.reconfigControl().getSideConfig(BlockHelper.left((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_ACCESSIBLE).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultMachineConfigRight(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String specificTexture = "thermal:block/machines/machine_" + machine + "_side";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(RenderHelper.textureExists((ResourceLocation)new ResourceLocation(specificTexture)) ? specificTexture : "thermal:block/machines/machine_side", Constants.TRUE).addSprite(ThermalTextures.MACHINE_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.right((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.MACHINE_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.right((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.MACHINE_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(BlockHelper.right((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_BOTH).addSprite(ThermalTextures.MACHINE_CONFIG_ACCESSIBLE, () -> tile.reconfigControl().getSideConfig(BlockHelper.right((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_ACCESSIBLE).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultMachineConfigFace(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String texture = "thermal:block/machines/machine_" + machine;
        String activeTexture = "thermal:block/machines/machine_" + machine + "_active";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(() -> RenderHelper.getFluidTexture((FluidStack)tile.getRenderFluid()), () -> !tile.getRenderFluid().isEmpty()).addSprite(RenderHelper.textureExists((ResourceLocation)new ResourceLocation(texture)) ? texture : "thermal:block/machines/machine_side", () -> !tile.isActive).addSprite(RenderHelper.textureExists((ResourceLocation)new ResourceLocation(activeTexture)) ? activeTexture : "thermal:block/machines/machine_side", () -> tile.isActive).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultMachineConfigBack(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String specificTexture = "thermal:block/machines/machine_" + machine + "_side";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(RenderHelper.textureExists((ResourceLocation)new ResourceLocation(specificTexture)) ? specificTexture : "thermal:block/machines/machine_side", Constants.TRUE).addSprite(ThermalTextures.MACHINE_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.opposite((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.MACHINE_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.opposite((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.MACHINE_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(BlockHelper.opposite((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_BOTH).addSprite(ThermalTextures.MACHINE_CONFIG_ACCESSIBLE, () -> tile.reconfigControl().getSideConfig(BlockHelper.opposite((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_ACCESSIBLE).setSize(16, 16);
    }

    public static ElementConditionalLayered[] createDefaultMachineConfigs(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        return new ElementConditionalLayered[]{ThermalGuiHelper.createDefaultMachineConfigTop(gui, machine, tile), ThermalGuiHelper.createDefaultMachineConfigLeft(gui, machine, tile), ThermalGuiHelper.createDefaultMachineConfigFace(gui, machine, tile), ThermalGuiHelper.createDefaultMachineConfigRight(gui, machine, tile), ThermalGuiHelper.createDefaultMachineConfigBottom(gui, machine, tile), ThermalGuiHelper.createDefaultMachineConfigBack(gui, machine, tile)};
    }

    public static ElementScaled createDefaultProgress(IGuiAccess gui, int posX, int posY, String texture, ThermalTileBase tile) {
        return GuiHelper.createDefaultProgress((IGuiAccess)gui, (int)posX, (int)posY, (String)texture, tile::getScaledProgress, () -> tile.getRenderFluid().isEmpty());
    }

    public static ElementScaledFluid createDefaultFluidProgress(IGuiAccess gui, int posX, int posY, String texture, ThermalTileBase tile) {
        return GuiHelper.createDefaultFluidProgress((IGuiAccess)gui, (int)posX, (int)posY, (String)texture, tile::getScaledProgress, tile::getRenderFluid, () -> !tile.getRenderFluid().isEmpty());
    }

    public static ElementScaled createDefaultSpeed(IGuiAccess gui, int posX, int posY, String texture, ThermalTileBase tile) {
        return GuiHelper.createDefaultSpeed((IGuiAccess)gui, (int)posX, (int)posY, (String)texture, tile::getScaledSpeed);
    }

    public static ElementScaled createDefaultDuration(IGuiAccess gui, int posX, int posY, String texture, ThermalTileBase tile) {
        return GuiHelper.createDefaultDuration((IGuiAccess)gui, (int)posX, (int)posY, (String)texture, tile::getScaledDuration);
    }

    public static PanelResource createDefaultEnergyUserPanel(IGuiAccess gui, ThermalTileBase tile) {
        return new PanelResource(gui).setResource(CoreTextures.ICON_ENERGY, "info.cofh.energy", false).setCurrent(tile::getCurSpeed, "info.cofh.energy_use", "RF/t").setMax(tile::getMaxSpeed, "info.cofh.energy_max_use", "RF/t").setEfficiency(tile::getEfficiency);
    }

    public static PanelResource createDefaultEnergyProducerPanel(IGuiAccess gui, ThermalTileBase tile) {
        return new PanelResource(gui).setResource(CoreTextures.ICON_ENERGY, "info.cofh.energy", true).setCurrent(tile::getCurSpeed, "info.cofh.energy_prod", "RF/t").setMax(tile::getMaxSpeed, "info.cofh.energy_max_prod", "RF/t").setEfficiency(tile::getEfficiency);
    }
}

