/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.model;

import cofh.core.client.renderer.model.BakedQuadRetextured;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermal.core.tileentity.ThermalTileBase;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

public class UnderlayBakedModel
extends BakedModelWrapper<IBakedModel>
implements IDynamicBakedModel {
    protected static final IdentityHashMap<FluidCacheWrapper, BakedQuad[]> FLUID_QUAD_CACHE = new IdentityHashMap();
    protected static final IdentityHashMap<BlockState, BakedQuad[]> UNDERLAY_QUAD_CACHE = new IdentityHashMap();

    public static void clearCache() {
        FLUID_QUAD_CACHE.clear();
        UNDERLAY_QUAD_CACHE.clear();
    }

    public UnderlayBakedModel(IBakedModel originalModel) {
        super(originalModel);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(this.originalModel.getQuads(state, side, rand, extraData));
        if (side == null || quads.isEmpty()) {
            return quads;
        }
        int sideIndex = side.func_176745_a();
        if (extraData.hasProperty(ThermalTileBase.FLUID)) {
            FluidStack fluid = (FluidStack)extraData.getData(ThermalTileBase.FLUID);
            if (fluid != null && !fluid.isEmpty()) {
                FluidCacheWrapper wrapper = new FluidCacheWrapper(state, fluid);
                BakedQuad[] cachedFluidQuads = FLUID_QUAD_CACHE.get(wrapper);
                if (cachedFluidQuads == null || cachedFluidQuads.length < 6) {
                    cachedFluidQuads = new BakedQuad[6];
                }
                if (cachedFluidQuads[sideIndex] == null) {
                    cachedFluidQuads[sideIndex] = new BakedQuadRetextured(RenderHelper.mulColor((BakedQuad)quads.get(0), (int)fluid.getFluid().getAttributes().getColor(fluid)), RenderHelper.getFluidTexture((FluidStack)fluid));
                    FLUID_QUAD_CACHE.put(wrapper, cachedFluidQuads);
                }
                quads.offerFirst(cachedFluidQuads[sideIndex]);
            }
        } else if (extraData.hasProperty(ThermalTileBase.UNDERLAY)) {
            ResourceLocation loc = (ResourceLocation)extraData.getData(ThermalTileBase.UNDERLAY);
            BakedQuad[] cachedUnderlayQuads = UNDERLAY_QUAD_CACHE.get(state);
            if (cachedUnderlayQuads == null || cachedUnderlayQuads.length < 6) {
                cachedUnderlayQuads = new BakedQuad[6];
            }
            if (cachedUnderlayQuads[sideIndex] == null) {
                cachedUnderlayQuads[sideIndex] = new BakedQuadRetextured(quads.get(0), RenderHelper.getTexture((ResourceLocation)loc));
                UNDERLAY_QUAD_CACHE.put(state, cachedUnderlayQuads);
            }
            quads.offerFirst(cachedUnderlayQuads[sideIndex]);
        }
        return quads;
    }

    protected static class FluidCacheWrapper {
        BlockState state;
        FluidStack stack;

        FluidCacheWrapper(BlockState state, FluidStack stack) {
            this.state = state;
            this.stack = new FluidStack(stack, 1000);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FluidCacheWrapper that = (FluidCacheWrapper)o;
            return Objects.equals(this.state, that.state) && Objects.equals(this.stack, that.stack);
        }

        public int hashCode() {
            return Objects.hash(this.state, FluidHelper.fluidHashcode((FluidStack)this.stack));
        }
    }
}

