/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.common;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.util.managers.IManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.crafting.RecipeManager;

public class ThermalRecipeManagers {
    private static final ThermalRecipeManagers INSTANCE = new ThermalRecipeManagers();
    private RecipeManager serverRecipeManager;
    private final List<IManager> managers = new ArrayList<IManager>();

    public static ThermalRecipeManagers instance() {
        return INSTANCE;
    }

    public void setServerRecipeManager(RecipeManager recipeManager) {
        this.serverRecipeManager = recipeManager;
    }

    public static void registerManager(IManager manager) {
        if (!ThermalRecipeManagers.instance().managers.contains(manager)) {
            ThermalRecipeManagers.instance().managers.add(manager);
        }
    }

    public void config() {
        for (IManager sub : this.managers) {
            sub.config();
        }
    }

    public void refreshServer() {
        if (this.serverRecipeManager == null) {
            ThermalCore.LOG.error("The server's Recipe Manager is null! This is REALLY BAD and will prevent recipes from registering. Check your modpack and configs.");
            return;
        }
        for (IManager sub : this.managers) {
            sub.refresh(this.serverRecipeManager);
        }
    }

    public void refreshClient(RecipeManager recipeManager) {
        if (this.serverRecipeManager != null) {
            return;
        }
        if (recipeManager == null) {
            ThermalCore.LOG.error("The client's Recipe Manager is null! This is REALLY BAD and will prevent recipes from registering. Check your modpack and configs.");
            return;
        }
        for (IManager sub : this.managers) {
            sub.refresh(recipeManager);
        }
    }
}

