/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.datagen;

import cofh.core.datagen.ItemModelProviderCoFH;
import cofh.core.registries.DeferredRegisterCoFH;
import cofh.thermal.core.ThermalCore;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.generators.ExistingFileHelper;

public class TCoreItemModels
extends ItemModelProviderCoFH {
    public TCoreItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "thermal", existingFileHelper);
    }

    public String func_200397_b() {
        return "Thermal Core: Item Models";
    }

    protected void registerModels() {
        this.registerBlockItemModels();
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        this.registerVanilla(reg);
        this.registerResources(reg);
        this.registerParts(reg);
        this.registerTools(reg);
        this.registerArmor(reg);
        this.registerAugments(reg);
    }

    private void registerVanilla(DeferredRegisterCoFH<Item> reg) {
        this.metalSet(reg, "iron", true);
        this.metalSet(reg, "gold", true);
        this.gemSet(reg, "lapis", true);
        this.gemSet(reg, "diamond", true);
        this.gemSet(reg, "emerald", true);
        this.gemSet(reg, "quartz", true);
    }

    private void registerResources(DeferredRegisterCoFH<Item> reg) {
        this.generated((Supplier)reg.getSup("sawdust"), "resources");
        this.generated((Supplier)reg.getSup("rosin"), "resources");
        this.generated((Supplier)reg.getSup("rubber"), "resources");
        this.generated((Supplier)reg.getSup("cured_rubber"), "resources");
        this.generated((Supplier)reg.getSup("slag"), "resources");
        this.generated((Supplier)reg.getSup("rich_slag"), "resources");
        this.generated((Supplier)reg.getSup("beekeeper_fabric"), "crafting");
        this.generated((Supplier)reg.getSup("diving_fabric"), "crafting");
        this.generated((Supplier)reg.getSup("hazmat_fabric"), "crafting");
        this.generated((Supplier)reg.getSup("apatite"), "resources");
        this.generated((Supplier)reg.getSup("cinnabar"), "resources");
        this.generated((Supplier)reg.getSup("niter"), "resources");
        this.generated((Supplier)reg.getSup("sulfur"), "resources");
        this.generated((Supplier)reg.getSup("basalz_rod"), "resources");
        this.generated((Supplier)reg.getSup("basalz_powder"), "resources");
        this.generated((Supplier)reg.getSup("blitz_rod"), "resources");
        this.generated((Supplier)reg.getSup("blitz_powder"), "resources");
        this.generated((Supplier)reg.getSup("blizz_rod"), "resources");
        this.generated((Supplier)reg.getSup("blizz_powder"), "resources");
        this.metalSet(reg, "copper");
        this.metalSet(reg, "lead");
        this.metalSet(reg, "nickel");
        this.metalSet(reg, "silver");
        this.metalSet(reg, "tin");
        this.metalSet(reg, "bronze");
        this.metalSet(reg, "constantan");
        this.metalSet(reg, "electrum");
        this.metalSet(reg, "invar");
        this.gemSet(reg, "ruby");
        this.gemSet(reg, "sapphire");
        this.metalSet(reg, "signalum");
        this.metalSet(reg, "lumium");
        this.metalSet(reg, "enderium");
    }

    private void registerParts(DeferredRegisterCoFH<Item> reg) {
        this.generated((Supplier)reg.getSup("redstone_servo"), "crafting");
        this.generated((Supplier)reg.getSup("rf_coil"), "crafting");
        this.generated((Supplier)reg.getSup("drill_head"), "crafting");
        this.generated((Supplier)reg.getSup("saw_blade"), "crafting");
        this.generated((Supplier)reg.getSup("laser_diode"), "crafting");
    }

    private void registerTools(DeferredRegisterCoFH<Item> reg) {
        this.handheld((Supplier)reg.getSup("wrench"), "tools");
        this.generated((Supplier)reg.getSup("redprint"), "tools");
        this.generated((Supplier)reg.getSup("lock"), "tools");
        this.generated((Supplier)reg.getSup("phytogro"), "tools");
        this.generated((Supplier)reg.getSup("earth_charge"), "tools");
        this.generated((Supplier)reg.getSup("ice_charge"), "tools");
        this.generated((Supplier)reg.getSup("lightning_charge"), "tools");
    }

    private void registerArmor(DeferredRegisterCoFH<Item> reg) {
        this.generated((Supplier)reg.getSup("beekeeper_helmet"), "armor");
        this.generated((Supplier)reg.getSup("beekeeper_chestplate"), "armor");
        this.generated((Supplier)reg.getSup("beekeeper_leggings"), "armor");
        this.generated((Supplier)reg.getSup("beekeeper_boots"), "armor");
        this.generated((Supplier)reg.getSup("diving_helmet"), "armor");
        this.generated((Supplier)reg.getSup("diving_chestplate"), "armor");
        this.generated((Supplier)reg.getSup("diving_leggings"), "armor");
        this.generated((Supplier)reg.getSup("diving_boots"), "armor");
        this.generated((Supplier)reg.getSup("hazmat_helmet"), "armor");
        this.generated((Supplier)reg.getSup("hazmat_chestplate"), "armor");
        this.generated((Supplier)reg.getSup("hazmat_leggings"), "armor");
        this.generated((Supplier)reg.getSup("hazmat_boots"), "armor");
    }

    private void registerAugments(DeferredRegisterCoFH<Item> reg) {
        for (int i = 1; i <= 3; ++i) {
            this.generated((Supplier)reg.getSup("upgrade_augment_" + i), "augments");
        }
        this.generated((Supplier)reg.getSup("fluid_tank_augment"), "augments");
        this.generated((Supplier)reg.getSup("rf_coil_augment"), "augments");
        this.generated((Supplier)reg.getSup("rf_coil_storage_augment"), "augments");
        this.generated((Supplier)reg.getSup("rf_coil_xfer_augment"), "augments");
        this.generated((Supplier)reg.getSup("area_radius_augment"), "augments");
        this.generated((Supplier)reg.getSup("potion_amplifier_augment"), "augments");
        this.generated((Supplier)reg.getSup("potion_duration_augment"), "augments");
        this.generated((Supplier)reg.getSup("machine_speed_augment"), "augments");
        this.generated((Supplier)reg.getSup("machine_output_augment"), "augments");
        this.generated((Supplier)reg.getSup("machine_catalyst_augment"), "augments");
        this.generated((Supplier)reg.getSup("machine_cycle_augment"), "augments");
        this.generated((Supplier)reg.getSup("dynamo_output_augment"), "augments");
        this.generated((Supplier)reg.getSup("dynamo_fuel_augment"), "augments");
    }

    private void registerBlockItemModels() {
        DeferredRegisterCoFH<Block> reg = ThermalCore.BLOCKS;
        this.registerVanillaBlocks(reg);
        this.registerResourceBlocks(reg);
        this.registerStorageBlocks(reg);
        this.registerBuildingBlocks(reg);
        this.registerMiscBlocks(reg);
    }

    private void registerVanillaBlocks(DeferredRegisterCoFH<Block> reg) {
        this.blockItem((Supplier)reg.getSup("charcoal_block"));
        this.blockItem((Supplier)reg.getSup("bamboo_block"));
        this.blockItem((Supplier)reg.getSup("sugar_cane_block"));
        this.blockItem((Supplier)reg.getSup("gunpowder_block"));
        this.blockItem((Supplier)reg.getSup("apple_block"));
        this.blockItem((Supplier)reg.getSup("beetroot_block"));
        this.blockItem((Supplier)reg.getSup("carrot_block"));
        this.blockItem((Supplier)reg.getSup("potato_block"));
    }

    private void registerResourceBlocks(DeferredRegisterCoFH<Block> reg) {
        this.blockItem((Supplier)reg.getSup("apatite_ore"));
        this.blockItem((Supplier)reg.getSup("cinnabar_ore"));
        this.blockItem((Supplier)reg.getSup("niter_ore"));
        this.blockItem((Supplier)reg.getSup("sulfur_ore"));
        this.blockItem((Supplier)reg.getSup("copper_ore"));
        this.blockItem((Supplier)reg.getSup("lead_ore"));
        this.blockItem((Supplier)reg.getSup("nickel_ore"));
        this.blockItem((Supplier)reg.getSup("silver_ore"));
        this.blockItem((Supplier)reg.getSup("tin_ore"));
        this.blockItem((Supplier)reg.getSup("ruby_ore"));
        this.blockItem((Supplier)reg.getSup("sapphire_ore"));
    }

    private void registerStorageBlocks(DeferredRegisterCoFH<Block> reg) {
        this.blockItem((Supplier)reg.getSup("apatite_block"));
        this.blockItem((Supplier)reg.getSup("cinnabar_block"));
        this.blockItem((Supplier)reg.getSup("niter_block"));
        this.blockItem((Supplier)reg.getSup("sulfur_block"));
        this.blockItem((Supplier)reg.getSup("copper_block"));
        this.blockItem((Supplier)reg.getSup("lead_block"));
        this.blockItem((Supplier)reg.getSup("nickel_block"));
        this.blockItem((Supplier)reg.getSup("silver_block"));
        this.blockItem((Supplier)reg.getSup("tin_block"));
        this.blockItem((Supplier)reg.getSup("ruby_block"));
        this.blockItem((Supplier)reg.getSup("sapphire_block"));
        this.blockItem((Supplier)reg.getSup("bronze_block"));
        this.blockItem((Supplier)reg.getSup("electrum_block"));
        this.blockItem((Supplier)reg.getSup("invar_block"));
        this.blockItem((Supplier)reg.getSup("constantan_block"));
        this.blockItem((Supplier)reg.getSup("enderium_block"));
        this.blockItem((Supplier)reg.getSup("lumium_block"));
        this.blockItem((Supplier)reg.getSup("signalum_block"));
        this.blockItem((Supplier)reg.getSup("sawdust_block"));
        this.blockItem((Supplier)reg.getSup("rosin_block"));
        this.blockItem((Supplier)reg.getSup("rubber_block"));
        this.blockItem((Supplier)reg.getSup("cured_rubber_block"));
        this.blockItem((Supplier)reg.getSup("slag_block"));
        this.blockItem((Supplier)reg.getSup("rich_slag_block"));
    }

    private void registerBuildingBlocks(DeferredRegisterCoFH<Block> reg) {
        this.blockItem((Supplier)reg.getSup("obsidian_glass"));
        this.blockItem((Supplier)reg.getSup("signalum_glass"));
        this.blockItem((Supplier)reg.getSup("lumium_glass"));
        this.blockItem((Supplier)reg.getSup("enderium_glass"));
        this.blockItem((Supplier)reg.getSup("white_rockwool"));
        this.blockItem((Supplier)reg.getSup("orange_rockwool"));
        this.blockItem((Supplier)reg.getSup("magenta_rockwool"));
        this.blockItem((Supplier)reg.getSup("light_blue_rockwool"));
        this.blockItem((Supplier)reg.getSup("yellow_rockwool"));
        this.blockItem((Supplier)reg.getSup("lime_rockwool"));
        this.blockItem((Supplier)reg.getSup("pink_rockwool"));
        this.blockItem((Supplier)reg.getSup("gray_rockwool"));
        this.blockItem((Supplier)reg.getSup("light_gray_rockwool"));
        this.blockItem((Supplier)reg.getSup("cyan_rockwool"));
        this.blockItem((Supplier)reg.getSup("purple_rockwool"));
        this.blockItem((Supplier)reg.getSup("blue_rockwool"));
        this.blockItem((Supplier)reg.getSup("brown_rockwool"));
        this.blockItem((Supplier)reg.getSup("green_rockwool"));
        this.blockItem((Supplier)reg.getSup("red_rockwool"));
        this.blockItem((Supplier)reg.getSup("black_rockwool"));
    }

    private void registerMiscBlocks(DeferredRegisterCoFH<Block> reg) {
        this.blockItem((Supplier)reg.getSup("phyto_tnt"));
        this.blockItem((Supplier)reg.getSup("fire_tnt"));
        this.blockItem((Supplier)reg.getSup("earth_tnt"));
        this.blockItem((Supplier)reg.getSup("ice_tnt"));
        this.blockItem((Supplier)reg.getSup("lightning_tnt"));
        this.blockItem((Supplier)reg.getSup("nuke_tnt"));
    }
}

