/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.core.entity.AbstractGrenadeEntity;
import cofh.core.util.AreaUtils;
import cofh.core.util.Utils;
import cofh.core.util.references.CoreReferences;
import cofh.thermal.core.init.TCoreReferences;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LightningGrenadeEntity
extends AbstractGrenadeEntity {
    public static int effectAmplifier = 1;
    public static int effectDuration = 200;

    public LightningGrenadeEntity(EntityType<? extends ProjectileItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public LightningGrenadeEntity(World worldIn, double x, double y, double z) {
        super(TCoreReferences.LIGHTNING_GRENADE_ENTITY, x, y, z, worldIn);
    }

    public LightningGrenadeEntity(World worldIn, LivingEntity livingEntityIn) {
        super(TCoreReferences.LIGHTNING_GRENADE_ENTITY, livingEntityIn, worldIn);
    }

    protected Item func_213885_i() {
        return TCoreReferences.LIGHTNING_GRENADE_ITEM;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (Utils.isServerWorld((World)this.field_70170_p)) {
            BlockPos pos = this.func_180425_c();
            if (this.field_70170_p.func_226660_f_(pos)) {
                LightningBoltEntity bolt = new LightningBoltEntity(this.field_70170_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, false);
                bolt.func_204809_d(this.func_85052_h() instanceof ServerPlayerEntity ? (ServerPlayerEntity)this.func_85052_h() : null);
                ((ServerWorld)this.field_70170_p).func_217468_a(bolt);
            }
            LightningGrenadeEntity.shockNearbyEntities((Entity)this, this.field_70170_p, this.func_180425_c(), this.radius);
            AreaUtils.zapNearbyGround((Entity)this, (World)this.field_70170_p, (BlockPos)this.func_180425_c(), (int)this.radius, (double)0.05, (int)3);
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY && this.field_70173_aa < 10) {
            return;
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0, 0.0, 0.0);
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.5f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
    }

    public static void shockNearbyEntities(Entity entity, World worldIn, BlockPos pos, int radius) {
        AxisAlignedBB area = new AxisAlignedBB(pos.func_177982_a(-radius, -radius, -radius), pos.func_177982_a(1 + radius, 1 + radius, 1 + radius));
        worldIn.func_175647_a(LivingEntity.class, area, EntityPredicates.field_94557_a).forEach(livingEntity -> livingEntity.func_195064_c(new EffectInstance(CoreReferences.SHOCKED, effectDuration, effectAmplifier, false, false)));
    }
}

