/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.core.entity.AbstractGrenadeEntity;
import cofh.core.util.Utils;
import cofh.core.util.helpers.MathHelper;
import cofh.thermal.core.init.TCoreReferences;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class NukeGrenadeEntity
extends AbstractGrenadeEntity {
    public static int effectAmplifier = 2;
    public static int effectDuration = 400;
    public static double explosionStrength = 8.0;
    public static boolean explosionsBreakBlocks = true;

    public NukeGrenadeEntity(EntityType<? extends ProjectileItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public NukeGrenadeEntity(World worldIn, double x, double y, double z) {
        super(TCoreReferences.NUKE_GRENADE_ENTITY, x, y, z, worldIn);
    }

    public NukeGrenadeEntity(World worldIn, LivingEntity livingEntityIn) {
        super(TCoreReferences.NUKE_GRENADE_ENTITY, livingEntityIn, worldIn);
    }

    protected Item func_213885_i() {
        return TCoreReferences.NUKE_GRENADE_ITEM;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (Utils.isServerWorld((World)this.field_70170_p)) {
            this.field_70170_p.func_175656_a(this.func_180425_c(), Blocks.field_150350_a.func_176223_P());
            NukeGrenadeEntity.damageNearbyEntities((Entity)this, this.field_70170_p, this.func_180425_c(), this.radius * 2, this.func_85052_h());
            NukeGrenadeEntity.destroyBlocks((Entity)this, this.field_70170_p, this.func_180425_c(), this.radius + this.radius / 2);
            this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (float)explosionStrength, !this.func_70090_H(), explosionsBreakBlocks ? Explosion.Mode.BREAK : Explosion.Mode.NONE);
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY && this.field_70173_aa < 10) {
            return;
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218419_B, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0, 0.0, 0.0);
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.5f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
    }

    public static void destroyBlocks(Entity entity, World worldIn, BlockPos pos, int radius) {
        if (radius <= 0) {
            return;
        }
        float f = Math.min(16, radius);
        float maxResistance = 400.0f * (float)radius * (float)radius;
        float f2 = f * f;
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-f / 2.0f), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)f, (double)f))) {
            BlockState state;
            double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2) || (state = worldIn.func_180495_p(iterPos)).isAir((IBlockReader)worldIn, iterPos) || !((double)state.func_177230_c().getExplosionResistance(state, (IWorldReader)worldIn, iterPos, entity, null) < (double)maxResistance - (double)maxResistance * distance / (double)f2)) continue;
            worldIn.func_175656_a(iterPos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public static void damageNearbyEntities(Entity entity, World worldIn, BlockPos pos, int radius, @Nullable LivingEntity source) {
        AxisAlignedBB area = new AxisAlignedBB(pos.func_177982_a(-radius, -radius, -radius), pos.func_177982_a(1 + radius, 1 + radius, 1 + radius));
        double f2 = radius * radius;
        worldIn.func_175647_a(LivingEntity.class, area, EntityPredicates.field_94557_a).forEach(livingEntity -> {
            double distance = pos.func_177951_i((Vec3i)livingEntity.func_180425_c());
            if (distance < f2) {
                float damage = (float)MathHelper.clamp((double)(f2 - distance), (double)radius, (double)f2);
                livingEntity.func_70097_a(DamageSource.func_188405_b((LivingEntity)source), damage);
                livingEntity.func_195064_c(new EffectInstance(Effects.field_82731_v, effectDuration, effectAmplifier, false, false));
            }
        });
    }
}

