/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.core.entity.AbstractGrenadeEntity;
import cofh.core.util.AreaUtils;
import cofh.core.util.Utils;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.item.PhytoGroItem;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class PhytoGrenadeEntity
extends AbstractGrenadeEntity {
    public PhytoGrenadeEntity(EntityType<? extends ProjectileItemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public PhytoGrenadeEntity(World worldIn, LivingEntity livingEntityIn) {
        super(TCoreReferences.PHYTO_GRENADE_ENTITY, livingEntityIn, worldIn);
    }

    public PhytoGrenadeEntity(World worldIn, double x, double y, double z) {
        super(TCoreReferences.PHYTO_GRENADE_ENTITY, x, y, z, worldIn);
    }

    protected Item func_213885_i() {
        return TCoreReferences.PHYTO_GRENADE_ITEM;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (Utils.isServerWorld((World)this.field_70170_p)) {
            AreaUtils.growPlants((Entity)this, (World)this.field_70170_p, (BlockPos)this.func_180425_c(), (int)this.radius);
            for (int i = 0; i < 2; ++i) {
                PhytoGroItem.growSeagrass(this.field_70170_p, this.func_180425_c(), null);
            }
            this.makeAreaOfEffectCloud();
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0, 0.0, 0.0);
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.5f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
    }

    private void makeAreaOfEffectCloud() {
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        cloud.func_184483_a(1.0f);
        cloud.func_195059_a((IParticleData)ParticleTypes.field_197632_y);
        cloud.func_184486_b(20);
        cloud.func_184485_d(0);
        cloud.func_184487_c(((float)this.radius - cloud.func_184490_j()) / (float)cloud.func_184489_o());
        this.field_70170_p.func_217376_c((Entity)cloud);
    }
}

