/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.fluid;

import cofh.core.fluid.FluidCoFH;
import cofh.core.util.Utils;
import cofh.core.util.references.CoreReferences;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.common.ThermalItemGroups;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class EnderFluid
extends FluidCoFH {
    protected static boolean teleport = true;
    protected static int duration = 100;

    public static EnderFluid create(String key) {
        return new EnderFluid(key, "thermal:block/fluids/ender_still", "thermal:block/fluids/ender_flow");
    }

    protected EnderFluid(String key, String stillTexture, String flowTexture) {
        this.stillFluid = ThermalCore.FLUIDS.register(key, () -> new ForgeFlowingFluid.Source(this.properties));
        this.flowingFluid = ThermalCore.FLUIDS.register(EnderFluid.flowing((String)key), () -> new ForgeFlowingFluid.Flowing(this.properties));
        this.block = ThermalCore.BLOCKS.register(key, () -> new EnderFluidBlock((Supplier<? extends FlowingFluid>)this.stillFluid, Block.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e()));
        this.bucket = ThermalCore.ITEMS.register(EnderFluid.bucket((String)key), () -> new BucketItem((Supplier)this.stillFluid, new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1).func_200916_a(ThermalItemGroups.THERMAL_TOOLS).func_208103_a(Rarity.UNCOMMON)));
        this.properties = new ForgeFlowingFluid.Properties((Supplier)this.stillFluid, (Supplier)this.flowingFluid, FluidAttributes.builder((ResourceLocation)new ResourceLocation(stillTexture), (ResourceLocation)new ResourceLocation(flowTexture)).luminosity(3).density(4000).viscosity(2500).rarity(Rarity.UNCOMMON)).bucket((Supplier)this.bucket).block((Supplier)this.block).levelDecreasePerBlock(2);
    }

    public static class EnderFluidBlock
    extends FlowingFluidBlock {
        public EnderFluidBlock(Supplier<? extends FlowingFluid> supplier, Block.Properties properties) {
            super(supplier, properties);
        }

        public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
            if (!teleport || Utils.isClientWorld((World)worldIn)) {
                return;
            }
            if (entityIn instanceof ItemEntity || entityIn instanceof ExperienceOrbEntity) {
                return;
            }
            BlockPos randPos = pos.func_177982_a(-8 + worldIn.field_73012_v.nextInt(17), worldIn.field_73012_v.nextInt(8), -8 + worldIn.field_73012_v.nextInt(17));
            if (!worldIn.func_180495_p(randPos).func_185904_a().func_76220_a()) {
                if (entityIn instanceof LivingEntity) {
                    if (Utils.teleportEntityTo((Entity)entityIn, (BlockPos)randPos)) {
                        ((LivingEntity)entityIn).func_195064_c(new EffectInstance(CoreReferences.ENDERFERENCE, duration, 0, false, false));
                    }
                } else if (worldIn.func_82737_E() % (long)duration == 0L) {
                    entityIn.func_70107_b((double)randPos.func_177958_n(), (double)randPos.func_177956_o(), (double)randPos.func_177952_p());
                    entityIn.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                }
            }
        }
    }
}

