/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.inventory.container.workbench;

import cofh.core.inventory.InvWrapperCoFH;
import cofh.core.inventory.ItemInvWrapper;
import cofh.core.inventory.SimpleItemInv;
import cofh.core.inventory.container.ContainerCoFH;
import cofh.core.inventory.container.TileContainer;
import cofh.core.inventory.container.slot.SlotCoFH;
import cofh.core.network.packet.server.ContainerPacket;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.tileentity.workbench.TinkerBenchTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TinkerBenchContainer
extends TileContainer {
    public final TinkerBenchTile tile;
    protected SlotCoFH tinkerSlot;
    protected List<SlotCoFH> tinkerAugmentSlots = new ArrayList<SlotCoFH>(9);
    protected ItemInvWrapper itemInventory = new ItemInvWrapper((Container)this, 9){

        public boolean func_94041_b(int index, ItemStack stack) {
            return TinkerBenchContainer.this.tile.allowAugmentation() && TinkerBenchContainer.this.tinkerSlot.func_75216_d() && index < AugmentableHelper.getAugmentSlots((ItemStack)TinkerBenchContainer.this.tinkerSlot.func_75211_c()) && AugmentableHelper.validAugment((ItemStack)TinkerBenchContainer.this.tinkerSlot.func_75211_c(), (ItemStack)stack);
        }
    };

    public TinkerBenchContainer(int windowId, World world, BlockPos pos, PlayerInventory inventory, PlayerEntity player) {
        super(TCoreReferences.TINKER_BENCH_CONTAINER, windowId, world, pos, inventory, player);
        this.tile = (TinkerBenchTile)world.func_175625_s(pos);
        InvWrapperCoFH tileInv = new InvWrapperCoFH((SimpleItemInv)this.tile.getItemInv());
        this.tinkerSlot = new SlotCoFH(tileInv, 0, 44, 26){

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                if (TinkerBenchContainer.this.tinkerSlot.func_75211_c() == stack) {
                    TinkerBenchContainer.this.writeAugmentsToItem(stack);
                    TinkerBenchContainer.this.itemInventory.func_174888_l();
                }
                return super.func_190901_a(thePlayer, stack);
            }

            public void func_75215_d(ItemStack stack) {
                if (TinkerBenchContainer.this.syncing) {
                    super.func_75215_d(stack);
                    return;
                }
                ItemStack curStack = TinkerBenchContainer.this.tinkerSlot.func_75211_c();
                if (!curStack.func_190926_b() && !curStack.equals(stack)) {
                    TinkerBenchContainer.this.writeAugmentsToItem(curStack);
                }
                super.func_75215_d(stack);
                if (!stack.func_190926_b()) {
                    TinkerBenchContainer.this.readAugmentsFromItem(stack);
                }
            }
        };
        this.func_75146_a((Slot)this.tinkerSlot);
        this.func_75146_a((Slot)new SlotCoFH(tileInv, 1, 8, 53));
        this.func_75146_a((Slot)new SlotCoFH(tileInv, 2, 152, 53));
        this.bindAugmentSlots((IInventory)tileInv, 3, this.tile.augSize());
        this.bindTinkerSlots((IInventory)this.itemInventory, 0, 9);
        this.bindPlayerInventory(inventory);
        this.readAugmentsFromItem(this.tinkerSlot.func_75211_c());
    }

    private void readAugmentsFromItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            this.itemInventory.setInvContainer(stack, AugmentableHelper.getAugments((ItemStack)stack), AugmentableHelper.getAugmentSlots((ItemStack)stack));
        }
    }

    private void writeAugmentsToItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            this.tile.setPause(true);
            AugmentableHelper.setAugments((ItemStack)stack, (List)this.itemInventory.getStacks());
            this.tile.setPause(false);
        }
    }

    private void bindTinkerSlots(IInventory inventory, int startIndex, int numSlots) {
        for (int i = 0; i < numSlots; ++i) {
            SlotCoFH slot = new SlotCoFH(inventory, i + startIndex, 0, 0, 1){

                public boolean func_82869_a(PlayerEntity player) {
                    return TinkerBenchContainer.this.tile.allowAugmentation();
                }
            };
            this.tinkerAugmentSlots.add(slot);
            this.func_75146_a((Slot)slot);
        }
        ((ArrayList)this.tinkerAugmentSlots).trimToSize();
    }

    public void onModeChange() {
        ContainerPacket.sendToServer((ContainerCoFH)this);
    }

    public boolean isTinkerSlot(Slot slot) {
        return this.tinkerSlot.equals(slot);
    }

    public int getNumTinkerAugmentSlots() {
        return AugmentableHelper.getAugmentSlots((ItemStack)this.tinkerSlot.func_75211_c());
    }

    public List<SlotCoFH> getTinkerAugmentSlots() {
        return this.tinkerAugmentSlots;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        this.writeAugmentsToItem(this.tinkerSlot.func_75211_c());
        super.func_75134_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        if (index == this.tinkerSlot.getSlotIndex()) {
            this.writeAugmentsToItem(this.tinkerSlot.func_75211_c());
        }
        return super.func_82846_b(player, index);
    }

    public PacketBuffer getContainerPacket(PacketBuffer buffer) {
        return buffer;
    }

    public void handleContainerPacket(PacketBuffer buffer) {
        this.writeAugmentsToItem(this.tinkerSlot.func_75211_c());
        this.tile.toggleTinkerSlotMode();
    }
}

