/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.IPlacementItem;
import cofh.core.item.ItemCoFH;
import cofh.core.util.IConveyableData;
import cofh.core.util.Utils;
import cofh.core.util.control.ISecurable;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedprintItem
extends ItemCoFH
implements IPlacementItem {
    public RedprintItem(Item.Properties builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT conveyableData = stack.func_77978_p();
        if (conveyableData != null) {
            tooltip.add(StringHelper.getTextComponent((String)"info.thermal.redprint.contents"));
            for (String type : conveyableData.func_150296_c()) {
                if (!StringHelper.canLocalize((String)("info.thermal.redprint.data." + type))) {
                    tooltip.add(StringHelper.getTextComponent((String)"info.thermal.redprint.unknown").func_211708_a(TextFormatting.DARK_GRAY));
                }
                tooltip.add(new StringTextComponent(" - ").func_150257_a(StringHelper.getTextComponent((String)("info.thermal.redprint.data." + type)).func_211708_a(TextFormatting.GRAY)));
            }
        }
    }

    public Rarity func_77613_e(ItemStack stack) {
        return stack.func_77942_o() ? Rarity.UNCOMMON : Rarity.COMMON;
    }

    protected boolean useDelegate(ItemStack stack, ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        if (player == null || Utils.isClientWorld((World)world)) {
            return false;
        }
        if (player.func_226563_dT_() && context.func_221531_n() == Hand.MAIN_HAND) {
            if (stack.func_77978_p() != null) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.5f, 0.3f);
                stack.func_77982_d(null);
            }
            return true;
        }
        BlockPos pos = context.func_195995_a();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable && !((ISecurable)tile).canAccess((Entity)player)) {
            return false;
        }
        if (tile instanceof IConveyableData) {
            IConveyableData conveyableTile = (IConveyableData)tile;
            if (stack.func_77978_p() == null && context.func_221531_n() == Hand.MAIN_HAND) {
                conveyableTile.writeConveyableData(player, stack.func_196082_o());
                tile.func_70296_d();
                if (stack.func_77978_p().isEmpty()) {
                    stack.func_77982_d(null);
                    return false;
                }
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.5f, 0.7f);
            } else {
                conveyableTile.readConveyableData(player, stack.func_77978_p());
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 0.5f, 0.8f);
            }
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        return player.func_175151_a(context.func_195995_a(), context.func_196000_l(), context.func_195996_i()) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        return player.func_175151_a(context.func_195995_a(), context.func_196000_l(), stack) && this.useDelegate(stack, context) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_226563_dT_()) {
            if (stack.func_77978_p() != null) {
                player.func_184185_a(SoundEvents.field_187604_bf, 0.5f, 0.3f);
            }
            stack.func_77982_d(null);
        }
        player.func_184609_a(hand);
        return ActionResult.func_226248_a_((Object)stack);
    }

    public boolean onBlockPlacement(ItemStack stack, ItemUseContext context) {
        return this.useDelegate(stack, context);
    }
}

