/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.plugins.jei;

import cofh.core.util.helpers.StringHelper;
import cofh.thermal.core.plugins.jei.Drawables;
import cofh.thermal.core.util.recipes.ThermalFuel;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ThermalFuelCategory<T extends ThermalFuel>
implements IRecipeCategory<T> {
    protected final int DURATION_X = 70;
    protected final int DURATION_Y = 24;
    protected final int ENERGY_X = 106;
    protected final int ENERGY_Y = 10;
    protected final ResourceLocation uid;
    protected IDrawableStatic background;
    protected IDrawableStatic icon;
    protected ITextComponent name;
    protected IDrawableStatic energyBackground;
    protected IDrawableStatic durationBackground;
    protected IDrawableAnimated energy;
    protected IDrawableAnimated duration;

    public ThermalFuelCategory(IGuiHelper guiHelper, ResourceLocation uid) {
        this(guiHelper, uid, true);
    }

    public ThermalFuelCategory(IGuiHelper guiHelper, ResourceLocation uid, boolean drawEnergy) {
        this.uid = uid;
        if (drawEnergy) {
            this.energyBackground = Drawables.getDrawables(guiHelper).getEnergyEmpty();
            this.energy = guiHelper.createAnimatedDrawable(Drawables.getDrawables(guiHelper).getEnergyFill(), 400, IDrawableAnimated.StartDirection.BOTTOM, false);
        }
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public String getTitle() {
        return this.name.func_150254_d();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, double mouseX, double mouseY) {
        if (this.energyBackground != null) {
            this.energyBackground.draw(106, 10);
        }
        if (this.energy != null) {
            this.energy.draw(106, 10);
        }
        if (this.durationBackground != null) {
            this.durationBackground.draw(70, 24);
        }
        if (this.duration != null) {
            this.duration.draw(70, 24);
        }
    }

    public List<String> getTooltipStrings(T recipe, double mouseX, double mouseY) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (this.energy != null && mouseX > 106.0 && mouseX < (double)(106 + this.energy.getWidth() - 1) && mouseY > 10.0 && mouseY < (double)(10 + this.energy.getHeight() - 1)) {
            tooltip.add(StringHelper.localize((String)"info.cofh.energy") + ": " + StringHelper.format((long)((ThermalFuel)((Object)recipe)).getEnergy()) + " RF");
        }
        return tooltip;
    }
}

