/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity;

import cofh.core.energy.EnergyStorageCoFH;
import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.Utils;
import cofh.core.util.constants.Constants;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermal.core.tileentity.ReconfigurableTile4Way;
import cofh.thermal.core.util.IMachineInventory;
import cofh.thermal.core.util.recipes.internal.IMachineRecipe;
import cofh.thermal.core.util.recipes.internal.IRecipeCatalyst;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class MachineTileProcess
extends ReconfigurableTile4Way
implements ITickableTileEntity,
IMachineInventory {
    protected IMachineRecipe curRecipe;
    protected IRecipeCatalyst curCatalyst;
    protected List<Integer> itemInputCounts = new ArrayList<Integer>();
    protected List<Integer> fluidInputCounts = new ArrayList<Integer>();
    protected int process;
    protected int processMax;
    protected int baseProcessTick;
    protected int processTick = this.baseProcessTick = this.getBaseProcessTick();
    protected float processMod = 1.0f;
    protected float primaryMod = 1.0f;
    protected float secondaryMod = 1.0f;
    protected float energyMod = 1.0f;
    protected float experienceMod = 1.0f;
    protected float minOutputChance = 0.0f;
    protected float catalystMod = 1.0f;

    public MachineTileProcess(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.energyStorage = new EnergyStorageCoFH(this.getBaseEnergyStorage(), this.getBaseEnergyXfer());
    }

    public void func_73660_a() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.canProcessFinish()) {
                this.processFinish();
                this.transferOutput();
                this.transferInput();
                if (!this.redstoneControl.getState() || !this.canProcessStart()) {
                    this.processOff();
                } else {
                    this.processStart();
                }
            } else if (this.energyStorage.getEnergyStored() < this.processTick) {
                this.processOff();
            }
        } else if (this.redstoneControl.getState()) {
            if (this.timeCheck()) {
                this.transferOutput();
                this.transferInput();
            }
            if (this.timeCheckQuarter() && this.canProcessStart()) {
                this.processStart();
                this.processTick();
                this.isActive = true;
            }
        }
        this.updateActiveState(curActive);
        this.chargeEnergy();
    }

    protected boolean canProcessStart() {
        if (this.energyStorage.getEnergyStored() < this.processTick) {
            return false;
        }
        if (!this.validateInputs()) {
            return false;
        }
        return this.validateOutputs();
    }

    protected boolean canProcessFinish() {
        return this.process <= 0;
    }

    protected void processStart() {
        this.processTick = this.baseProcessTick;
        int energy = this.curRecipe.getEnergy(this);
        int minTicks = this.curRecipe.getMinTicks();
        if (minTicks > 0) {
            this.processTick = Math.min(this.processTick, Math.max(this.getMinProcessTick(), energy / minTicks));
            energy = Math.max(energy, this.getMinProcessTick() * minTicks);
            this.energyStorage.modify(-this.process);
        } else {
            energy += this.process;
        }
        this.process = this.processMax = energy;
        if (this.cacheRenderFluid()) {
            TileStatePacket.sendToClient((TileCoFH)this);
        }
    }

    protected void processFinish() {
        if (!this.validateInputs()) {
            this.processOff();
            return;
        }
        this.resolveOutputs();
        this.resolveInputs();
        this.func_70296_d();
    }

    protected void processOff() {
        this.process = 0;
        this.isActive = false;
        this.wasActive = true;
        this.clearRecipe();
        if (this.field_145850_b != null) {
            this.timeTracker.markTime(this.field_145850_b);
        }
    }

    protected int processTick() {
        if (this.process <= 0) {
            return 0;
        }
        this.energyStorage.modify(-this.processTick);
        this.process -= this.processTick;
        return this.processTick;
    }

    protected boolean cacheRecipe() {
        return false;
    }

    protected void clearRecipe() {
        this.curRecipe = null;
        this.curCatalyst = null;
        this.itemInputCounts = new ArrayList<Integer>();
        this.fluidInputCounts = new ArrayList<Integer>();
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        List<? extends ItemStorageCoFH> slotInputs = this.inputSlots();
        for (int i = 0; i < slotInputs.size() && i < this.itemInputCounts.size(); ++i) {
            int inputCount = this.itemInputCounts.get(i);
            if (inputCount <= 0 || slotInputs.get(i).getItemStack().func_190916_E() >= inputCount) continue;
            return false;
        }
        List<? extends FluidStorageCoFH> tankInputs = this.inputTanks();
        for (int i = 0; i < tankInputs.size() && i < this.fluidInputCounts.size(); ++i) {
            int inputCount = this.fluidInputCounts.get(i);
            FluidStack input = tankInputs.get(i).getFluidStack();
            if (inputCount <= 0 || !input.isEmpty() && input.getAmount() >= inputCount) continue;
            return false;
        }
        return true;
    }

    protected boolean validateOutputs() {
        List<? extends ItemStorageCoFH> slotOutputs = this.outputSlots();
        List<ItemStack> recipeOutputItems = this.curRecipe.getOutputItems(this);
        boolean[] used = new boolean[this.outputSlots().size()];
        for (ItemStack recipeOutput : recipeOutputItems) {
            int i;
            boolean matched = false;
            for (i = 0; i < slotOutputs.size(); ++i) {
                ItemStack output;
                if (used[i] || (output = slotOutputs.get(i).getItemStack()).func_190916_E() >= output.func_77976_d() || !ItemHelper.itemsEqualWithTags((ItemStack)output, (ItemStack)recipeOutput)) continue;
                used[i] = true;
                matched = true;
                break;
            }
            if (!matched) {
                for (i = 0; i < slotOutputs.size(); ++i) {
                    if (used[i] || !slotOutputs.get(i).isEmpty()) continue;
                    used[i] = true;
                    matched = true;
                    break;
                }
            }
            if (matched) continue;
            return false;
        }
        List<? extends FluidStorageCoFH> tankOutputs = this.outputTanks();
        List<FluidStack> recipeOutputFluids = this.curRecipe.getOutputFluids(this);
        used = new boolean[this.outputTanks().size()];
        for (FluidStack recipeOutput : recipeOutputFluids) {
            int i;
            boolean matched = false;
            for (i = 0; i < tankOutputs.size(); ++i) {
                FluidStack output;
                if (used[i] || tankOutputs.get(i).getSpace() <= 0 || !FluidHelper.fluidsEqual((FluidStack)(output = tankOutputs.get(i).getFluidStack()), (FluidStack)recipeOutput)) continue;
                used[i] = true;
                matched = true;
                break;
            }
            if (!matched) {
                for (i = 0; i < tankOutputs.size(); ++i) {
                    if (used[i] || !tankOutputs.get(i).isEmpty()) continue;
                    used[i] = true;
                    matched = true;
                    break;
                }
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    protected void resolveOutputs() {
        List<ItemStack> recipeOutputItems = this.curRecipe.getOutputItems(this);
        List<FluidStack> recipeOutputFluids = this.curRecipe.getOutputFluids(this);
        List<Float> recipeOutputChances = this.curRecipe.getOutputItemChances(this);
        for (int i = 0; i < recipeOutputItems.size(); ++i) {
            int outputCount;
            ItemStack itemStack = recipeOutputItems.get(i);
            float chance = recipeOutputChances.get(i).floatValue();
            int n = outputCount = chance <= 1.0f ? itemStack.func_190916_E() : (int)chance;
            while (this.field_145850_b.field_73012_v.nextFloat() < chance) {
                boolean bl = false;
                for (ItemStorageCoFH itemStorageCoFH : this.outputSlots()) {
                    ItemStack output = itemStorageCoFH.getItemStack();
                    if (!ItemHelper.itemsEqualWithTags((ItemStack)output, (ItemStack)itemStack) || output.func_190916_E() >= output.func_77976_d()) continue;
                    output.func_190917_f(outputCount);
                    bl = true;
                    break;
                }
                if (!bl) {
                    for (ItemStorageCoFH itemStorageCoFH : this.outputSlots()) {
                        if (!itemStorageCoFH.isEmpty()) continue;
                        itemStorageCoFH.setItemStack(ItemHelper.cloneStack((ItemStack)itemStack, (int)outputCount));
                        break;
                    }
                }
                chance -= 1.0f * (float)outputCount;
                outputCount = 1;
            }
        }
        block4: for (FluidStack fluidStack : recipeOutputFluids) {
            boolean matched = false;
            for (FluidStorageCoFH fluidStorageCoFH : this.outputTanks()) {
                FluidStack output = fluidStorageCoFH.getFluidStack();
                if (fluidStorageCoFH.getSpace() < fluidStack.getAmount() || !FluidHelper.fluidsEqual((FluidStack)output, (FluidStack)fluidStack)) continue;
                output.setAmount(output.getAmount() + fluidStack.getAmount());
                matched = true;
                break;
            }
            if (matched) continue;
            for (FluidStorageCoFH fluidStorageCoFH : this.outputTanks()) {
                if (!fluidStorageCoFH.isEmpty()) continue;
                fluidStorageCoFH.setFluidStack(fluidStack.copy());
                continue block4;
            }
        }
    }

    protected void resolveInputs() {
        int i;
        for (i = 0; i < this.itemInputCounts.size(); ++i) {
            this.inputSlots().get(i).consume(this.itemInputCounts.get(i).intValue());
        }
        for (i = 0; i < this.fluidInputCounts.size(); ++i) {
            this.inputTanks().get(i).modify(-this.fluidInputCounts.get(i).intValue());
        }
    }

    @Override
    public int getCurSpeed() {
        return this.isActive ? this.processTick : 0;
    }

    @Override
    public int getMaxSpeed() {
        return this.baseProcessTick;
    }

    @Override
    public double getEfficiency() {
        if (this.getEnergyMod() <= 0.0f) {
            return Double.MAX_VALUE;
        }
        return 1.0 / (double)this.getEnergyMod();
    }

    @Override
    public int getScaledProgress(int scale) {
        if (!this.isActive || this.processMax <= 0 || this.process <= 0) {
            return 0;
        }
        return scale * (this.processMax - this.process) / this.processMax;
    }

    @Override
    public int getScaledSpeed(int scale) {
        if (!this.isActive) {
            return 0;
        }
        return MathHelper.clamp((int)(scale * this.processTick / this.baseProcessTick), (int)1, (int)scale);
    }

    @Override
    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeInt(this.processMax);
        buffer.writeInt(this.processTick);
        return buffer;
    }

    @Override
    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.process = buffer.readInt();
        this.processMax = buffer.readInt();
        this.processTick = buffer.readInt();
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.process = nbt.func_74762_e("Proc");
        this.processMax = nbt.func_74762_e("ProcMax");
        this.processTick = nbt.func_74762_e("ProcTick");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Proc", this.process);
        nbt.func_74768_a("ProcMax", this.processMax);
        nbt.func_74768_a("ProcTick", this.processTick);
        return nbt;
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.processMod = 1.0f;
        this.primaryMod = 1.0f;
        this.secondaryMod = 1.0f;
        this.energyMod = 1.0f;
        this.experienceMod = 1.0f;
        this.catalystMod = 1.0f;
        this.minOutputChance = 0.0f;
    }

    @Override
    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.processMod += this.getAttributeMod(augmentData, "MchPwr");
        this.primaryMod += this.getAttributeMod(augmentData, "MchPri");
        this.secondaryMod += this.getAttributeMod(augmentData, "MchSec");
        this.energyMod *= this.getAttributeModWithDefault(augmentData, "MchEn", 1.0f);
        this.experienceMod *= this.getAttributeModWithDefault(augmentData, "MchXp", 1.0f);
        this.catalystMod *= this.getAttributeModWithDefault(augmentData, "MchCat", 1.0f);
        this.minOutputChance = Math.max(this.getAttributeMod(augmentData, "MchMin"), this.minOutputChance);
    }

    @Override
    protected void finalizeAttributes() {
        int minTicks;
        super.finalizeAttributes();
        float scaleMin = Constants.AUG_SCALE_MIN;
        float scaleMax = Constants.AUG_SCALE_MAX;
        this.baseProcessTick = Math.round((float)this.getBaseProcessTick() * this.baseMod * this.processMod);
        this.primaryMod = MathHelper.clamp((float)this.primaryMod, (float)scaleMin, (float)scaleMax);
        this.secondaryMod = MathHelper.clamp((float)this.secondaryMod, (float)scaleMin, (float)scaleMax);
        this.energyMod = MathHelper.clamp((float)this.energyMod, (float)scaleMin, (float)scaleMax);
        this.experienceMod = MathHelper.clamp((float)this.experienceMod, (float)scaleMin, (float)scaleMax);
        this.catalystMod = MathHelper.clamp((float)this.catalystMod, (float)scaleMin, (float)scaleMax);
        this.processTick = this.baseProcessTick;
        if (this.curRecipe != null && (minTicks = this.curRecipe.getMinTicks()) > 0) {
            int energy = this.curRecipe.getEnergy(this);
            this.processTick = Math.min(this.processTick, Math.max(this.getMinProcessTick(), energy / minTicks));
        }
    }

    @Override
    public void onInventoryChange(int slot) {
        super.onInventoryChange(slot);
        if (this.field_145850_b != null && Utils.isServerWorld((World)this.field_145850_b) && this.isActive) {
            if (slot >= this.invSize() - this.augSize()) {
                if (!this.validateOutputs()) {
                    this.processOff();
                }
            } else if (slot < this.inventory.getInputSlots().size()) {
                IMachineRecipe tempRecipe = this.curRecipe;
                IRecipeCatalyst tempCatalyst = this.curCatalyst;
                if (!this.validateInputs() || tempRecipe != this.curRecipe || tempCatalyst != this.curCatalyst) {
                    this.processOff();
                }
            }
        }
    }

    public void onTankChange(int tank) {
        if (Utils.isServerWorld((World)this.field_145850_b) && tank < this.tankInv.getInputTanks().size() && this.isActive) {
            IMachineRecipe tempRecipe = this.curRecipe;
            IRecipeCatalyst tempCatalyst = this.curCatalyst;
            if (!this.validateInputs() || tempRecipe != this.curRecipe || tempCatalyst != this.curCatalyst) {
                this.processOff();
            }
        }
        super.onTankChange(tank);
    }

    @Override
    public final float getPrimaryMod() {
        return this.primaryMod;
    }

    @Override
    public final float getSecondaryMod() {
        return this.secondaryMod;
    }

    @Override
    public final float getEnergyMod() {
        return this.energyMod;
    }

    @Override
    public final float getExperienceMod() {
        return this.experienceMod;
    }

    @Override
    public final float getMinOutputChance() {
        return this.minOutputChance;
    }

    @Override
    public final float getUseChance() {
        return this.catalystMod;
    }
}

