/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity;

import cofh.core.energy.EnergyStorageCoFH;
import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.fluid.ManagedTankInv;
import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.inventory.ManagedItemInv;
import cofh.core.network.packet.client.TileControlPacket;
import cofh.core.network.packet.client.TileRedstonePacket;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.tileentity.ITileCallback;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.IInventoryCallback;
import cofh.core.util.StorageGroup;
import cofh.core.util.TimeTracker;
import cofh.core.util.Utils;
import cofh.core.util.constants.Constants;
import cofh.core.util.control.IRedstoneControllableTile;
import cofh.core.util.control.ISecurableTile;
import cofh.core.util.control.RedstoneControlModule;
import cofh.core.util.control.SecurityControlModule;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.core.util.loot.TileNBTSync;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class ThermalTileBase
extends TileCoFH
implements ISecurableTile,
IRedstoneControllableTile,
INamedContainerProvider,
IThermalInventory {
    public static final ModelProperty<byte[]> SIDES = new ModelProperty();
    public static final ModelProperty<FluidStack> FLUID = new ModelProperty();
    public static final ModelProperty<ResourceLocation> UNDERLAY = new ModelProperty();
    protected static final int MIN_PROCESS_TICK = 5;
    protected static final int BASE_PROCESS_TICK = 20;
    protected static final int BASE_ENERGY = 20000;
    protected TimeTracker timeTracker = new TimeTracker();
    protected ManagedItemInv inventory = new ManagedItemInv((IInventoryCallback)this, "ItemInv");
    protected ManagedTankInv tankInv = new ManagedTankInv((ITileCallback)this, "TankInv");
    protected EnergyStorageCoFH energyStorage = new EnergyStorageCoFH(0);
    protected SecurityControlModule securityControl = new SecurityControlModule((ISecurableTile)this);
    protected RedstoneControlModule redstoneControl = new RedstoneControlModule((IRedstoneControllableTile)this);
    protected List<ItemStorageCoFH> augments = new ArrayList<ItemStorageCoFH>();
    protected Set<String> augmentTypes = new ObjectOpenHashSet();
    public boolean isActive;
    public boolean wasActive;
    protected FluidStack renderFluid = FluidStack.EMPTY;
    protected float baseMod = 1.0f;
    protected float energyStorageMod = 1.0f;
    protected float energyXferMod = 1.0f;
    protected float fluidStorageMod = 1.0f;
    protected LazyOptional<?> energyCap = LazyOptional.empty();
    protected LazyOptional<?> itemCap = LazyOptional.empty();
    protected LazyOptional<?> fluidCap = LazyOptional.empty();

    public ThermalTileBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    protected int getBaseEnergyStorage() {
        return 20000;
    }

    protected int getBaseEnergyXfer() {
        return 160;
    }

    protected int getBaseProcessTick() {
        return 20;
    }

    protected int getMinProcessTick() {
        return 5;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.energyCap.invalidate();
        this.itemCap.invalidate();
        this.fluidCap.invalidate();
    }

    public int invSize() {
        return this.inventory.getSlots();
    }

    public int augSize() {
        return this.augments.size();
    }

    public ManagedItemInv getItemInv() {
        return this.inventory;
    }

    public ManagedTankInv getTankInv() {
        return this.tankInv;
    }

    protected void initHandlers() {
        this.inventory.initHandlers();
        this.tankInv.initHandlers();
    }

    protected void updateActiveState(boolean curActive) {
        if (!this.wasActive && curActive != this.isActive || this.wasActive && (this.timeTracker.hasDelayPassed(this.field_145850_b, 40) || this.timeTracker.notSet())) {
            this.wasActive = false;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)Constants.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)));
            TileStatePacket.sendToClient((TileCoFH)this);
        }
    }

    protected boolean cacheRenderFluid() {
        return false;
    }

    public List<? extends ItemStorageCoFH> inputSlots() {
        return this.inventory.getInputSlots();
    }

    public List<? extends FluidStorageCoFH> inputTanks() {
        return this.tankInv.getInputTanks();
    }

    protected List<? extends ItemStorageCoFH> outputSlots() {
        return this.inventory.getOutputSlots();
    }

    protected List<? extends FluidStorageCoFH> outputTanks() {
        return this.tankInv.getOutputTanks();
    }

    protected List<? extends ItemStorageCoFH> internalSlots() {
        return this.inventory.getInternalSlots();
    }

    protected List<? extends FluidStorageCoFH> internalTanks() {
        return this.tankInv.getInternalTanks();
    }

    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        if (this.field_145850_b != null && this.redstoneControl.isControllable()) {
            this.redstoneControl.setPower(this.field_145850_b.func_175687_A(this.field_174879_c));
            TileRedstonePacket.sendToClient((TileCoFH)this);
        }
    }

    public void onPlacedBy(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlacedBy(worldIn, pos, state, placer, stack);
        this.updateAugmentState();
        this.onControlUpdate();
    }

    public void onReplaced(BlockState state, World worldIn, BlockPos pos, BlockState newState) {
        int i;
        if (!((Boolean)ThermalConfig.keepItems.get()).booleanValue()) {
            for (i = 0; i < this.invSize() - this.augSize(); ++i) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.inventory.getStackInSlot(i));
            }
        }
        if (!((Boolean)ThermalConfig.keepAugments.get()).booleanValue()) {
            for (i = this.invSize() - this.augSize(); i < this.invSize(); ++i) {
                Utils.dropItemStackIntoWorldWithRandomness((ItemStack)this.inventory.getStackInSlot(i), (World)worldIn, (BlockPos)pos);
            }
        }
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        return TileNBTSync.applyToStack(stack, (TileEntity)this);
    }

    public ItemStorageCoFH getSlot(int slot) {
        return this.inventory.getSlot(slot);
    }

    public FluidStorageCoFH getTank(int tank) {
        return this.tankInv.getTank(tank);
    }

    public EnergyStorageCoFH getEnergyStorage() {
        return this.energyStorage;
    }

    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    public int getScaledDuration() {
        return this.getScaledDuration(16);
    }

    public int getScaledDuration(int scale) {
        return this.isActive ? scale : 0;
    }

    public int getScaledProgress() {
        return this.getScaledProgress(24);
    }

    public int getScaledProgress(int scale) {
        return this.isActive ? scale : 0;
    }

    public int getScaledSpeed() {
        return this.getScaledSpeed(16);
    }

    public int getScaledSpeed(int scale) {
        return this.isActive ? scale : 0;
    }

    public int getCurSpeed() {
        return -1;
    }

    public int getMaxSpeed() {
        return -1;
    }

    public double getEfficiency() {
        return -1.0;
    }

    public boolean clearEnergy(int coil) {
        return this.energyStorage.clear();
    }

    public boolean clearSlot(int slot) {
        if (slot >= this.inventory.getSlots()) {
            return false;
        }
        if (this.inventory.getSlot(slot).clear()) {
            this.onInventoryChange(slot);
            return true;
        }
        return false;
    }

    public boolean clearTank(int tank) {
        if (tank >= this.tankInv.getTanks()) {
            return false;
        }
        if (this.tankInv.getTank(tank).clear()) {
            this.onTankChange(tank);
            return true;
        }
        return false;
    }

    public PacketBuffer getControlPacket(PacketBuffer buffer) {
        super.getControlPacket(buffer);
        this.securityControl.writeToBuffer(buffer);
        this.redstoneControl.writeToBuffer(buffer);
        buffer.writeFluidStack(this.renderFluid);
        return buffer;
    }

    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeBoolean(this.isActive);
        buffer.writeFluidStack(this.renderFluid);
        buffer.writeInt(this.energyStorage.getMaxEnergyStored());
        buffer.writeInt(this.energyStorage.getEnergyStored());
        for (int i = 0; i < this.tankInv.getTanks(); ++i) {
            buffer.writeFluidStack(this.tankInv.get(i));
        }
        return buffer;
    }

    public PacketBuffer getRedstonePacket(PacketBuffer buffer) {
        super.getRedstonePacket(buffer);
        buffer.writeInt(this.redstoneControl.getPower());
        return buffer;
    }

    public PacketBuffer getStatePacket(PacketBuffer buffer) {
        super.getStatePacket(buffer);
        buffer.writeBoolean(this.isActive);
        buffer.writeFluidStack(this.renderFluid);
        return buffer;
    }

    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        this.securityControl.readFromBuffer(buffer);
        this.redstoneControl.readFromBuffer(buffer);
        this.renderFluid = buffer.readFluidStack();
    }

    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.isActive = buffer.readBoolean();
        this.renderFluid = buffer.readFluidStack();
        this.energyStorage.setCapacity(buffer.readInt());
        this.energyStorage.setEnergyStored(buffer.readInt());
        for (int i = 0; i < this.tankInv.getTanks(); ++i) {
            this.tankInv.set(i, buffer.readFluidStack());
        }
    }

    public void handleRedstonePacket(PacketBuffer buffer) {
        super.handleRedstonePacket(buffer);
        this.redstoneControl.setPower(buffer.readInt());
    }

    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        this.isActive = buffer.readBoolean();
        this.renderFluid = buffer.readFluidStack();
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.isActive = nbt.func_74767_n("Active");
        this.wasActive = nbt.func_74767_n("WasActive");
        this.inventory.read(nbt);
        if (nbt.func_74764_b("Augments")) {
            this.inventory.readSlotsUnordered(nbt.func_150295_c("Augments", 10), this.invSize() - this.augSize());
        }
        this.updateAugmentState();
        this.tankInv.read(nbt);
        this.energyStorage.read(nbt);
        this.securityControl.read(nbt);
        this.redstoneControl.read(nbt);
        this.renderFluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("RenderFluid"));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Active", this.isActive);
        nbt.func_74757_a("WasActive", this.wasActive);
        this.inventory.write(nbt);
        this.tankInv.write(nbt);
        this.energyStorage.write(nbt);
        this.securityControl.write(nbt);
        this.redstoneControl.write(nbt);
        if (!this.renderFluid.isEmpty()) {
            nbt.func_218657_a("RenderFluid", (INBT)this.renderFluid.writeToNBT(new CompoundNBT()));
        }
        return nbt;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public void onInventoryChange(int slot) {
        if (slot >= this.invSize() - this.augSize()) {
            this.updateAugmentState();
        }
    }

    public void onControlUpdate() {
        TileControlPacket.sendToClient((TileCoFH)this);
    }

    public void readConveyableData(PlayerEntity player, CompoundNBT tag) {
        this.redstoneControl.read(tag);
        this.onControlUpdate();
    }

    public void writeConveyableData(PlayerEntity player, CompoundNBT tag) {
        this.redstoneControl.write(tag);
    }

    protected void addAugmentSlots(int numAugments) {
        for (int i = 0; i < numAugments; ++i) {
            ItemStorageCoFH slot = new ItemStorageCoFH(1, AugmentDataHelper::hasAugmentData);
            this.augments.add(slot);
            this.inventory.addSlot(slot, StorageGroup.INTERNAL);
        }
        ((ArrayList)this.augments).trimToSize();
    }

    protected void updateAugmentState() {
        this.resetAttributes();
        for (ItemStorageCoFH slot : this.augments) {
            ItemStack augment = slot.getItemStack();
            CompoundNBT augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.augmentTypes.add(AugmentDataHelper.getAugmentType((ItemStack)augment));
            this.setAttributesFromAugment(augmentData);
        }
        this.finalizeAttributes();
    }

    protected void resetAttributes() {
        this.baseMod = 1.0f;
        this.energyStorageMod = 1.0f;
        this.energyXferMod = 1.0f;
        this.fluidStorageMod = 1.0f;
    }

    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        this.baseMod = Math.max(this.getAttributeMod(augmentData, "BaseMod"), this.baseMod);
        this.energyStorageMod = Math.max(this.getAttributeMod(augmentData, "RFMax"), this.energyStorageMod);
        this.energyXferMod = Math.max(this.getAttributeMod(augmentData, "RFXfer"), this.energyXferMod);
        this.fluidStorageMod = Math.max(this.getAttributeMod(augmentData, "FlMax"), this.fluidStorageMod);
    }

    protected void finalizeAttributes() {
        float scaleMin = Constants.AUG_SCALE_MIN;
        float scaleMax = Constants.AUG_SCALE_MAX;
        this.energyStorageMod = MathHelper.clamp((float)this.energyStorageMod, (float)scaleMin, (float)scaleMax);
        this.energyXferMod = MathHelper.clamp((float)this.energyXferMod, (float)scaleMin, (float)scaleMax);
        this.fluidStorageMod = MathHelper.clamp((float)this.fluidStorageMod, (float)scaleMin, (float)scaleMax);
        this.energyStorage.applyModifiers(this.getEnergyStorageMod(), this.getEnergyXferMod());
        for (int i = 0; i < this.tankInv.getTanks(); ++i) {
            this.tankInv.getTank(i).applyModifiers(this.getFluidStorageMod());
        }
    }

    protected float getEnergyStorageMod() {
        return this.energyStorageMod * this.baseMod;
    }

    protected float getEnergyXferMod() {
        return this.energyXferMod * this.baseMod;
    }

    protected float getFluidStorageMod() {
        return this.fluidStorageMod * this.baseMod;
    }

    protected float getAttributeMod(CompoundNBT augmentData, String key) {
        return augmentData.func_74760_g(key);
    }

    protected float getAttributeModWithDefault(CompoundNBT augmentData, String key, float defaultValue) {
        return augmentData.func_74764_b(key) ? augmentData.func_74760_g(key) : defaultValue;
    }

    public SecurityControlModule securityControl() {
        return this.securityControl;
    }

    public RedstoneControlModule redstoneControl() {
        return this.redstoneControl;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY && this.energyStorage.getMaxEnergyStored() > 0) {
            return this.getEnergyCapability(side);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory.hasSlots()) {
            return this.getItemHandlerCapability(side);
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.tankInv.hasTanks()) {
            return this.getFluidHandlerCapability(side);
        }
        return super.getCapability(cap, side);
    }

    protected <T> LazyOptional<T> getEnergyCapability(@Nullable Direction side) {
        if (!this.energyCap.isPresent()) {
            this.energyCap = LazyOptional.of(() -> this.energyStorage);
        }
        return this.energyCap.cast();
    }

    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (!this.itemCap.isPresent()) {
            this.itemCap = LazyOptional.of(() -> this.inventory.getHandler(StorageGroup.ACCESSIBLE));
        }
        return this.itemCap.cast();
    }

    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (!this.fluidCap.isPresent()) {
            this.fluidCap = LazyOptional.of(() -> this.tankInv.getHandler(StorageGroup.ACCESSIBLE));
        }
        return this.fluidCap.cast();
    }
}

