/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.network.packet.client.TileControlPacket;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.references.CoreReferences;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceHiveExtractorContainer;
import cofh.thermal.core.tileentity.ThermalTileBase;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DeviceHiveExtractorTile
extends ThermalTileBase {
    private static final int COMB_AMOUNT = 2;
    private static final int HONEY_AMOUNT = 250;
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();
    protected FluidStorageCoFH outputTank = new FluidStorageCoFH(8000);

    public DeviceHiveExtractorTile() {
        super(TCoreReferences.DEVICE_HIVE_EXTRACTOR_TILE);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.tankInv.addTank(this.outputTank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalConfig.deviceAugments);
        this.initHandlers();
    }

    protected void extractProducts(BlockPos above) {
        if (this.field_145850_b == null) {
            return;
        }
        BlockState hive = this.field_145850_b.func_180495_p(above);
        Block hiveBlock = hive.func_177230_c();
        if (hiveBlock instanceof BeehiveBlock && BeehiveTileEntity.func_226964_a_((BlockState)hive) >= 5) {
            this.field_145850_b.func_180501_a(above, (BlockState)hive.func_206870_a((IProperty)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(0)), 3);
            if (this.outputSlot.isEmpty()) {
                this.outputSlot.setItemStack(ItemHelper.cloneStack((Item)Items.field_226635_pU_, (int)2));
            } else {
                this.outputSlot.modify(Math.min(2, this.outputSlot.getSpace()));
            }
            if (this.outputTank.isEmpty()) {
                this.outputTank.setFluidStack(new FluidStack((Fluid)CoreReferences.FLUID_HONEY, 250));
            } else {
                this.outputTank.modify(Math.min(250, this.outputTank.getSpace()));
            }
        }
    }

    protected void updateActiveState() {
        boolean curActive = this.isActive;
        this.isActive = this.redstoneControl().getState() && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() instanceof BeehiveBlock;
        this.updateActiveState(curActive);
    }

    @Override
    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        super.neighborChanged(blockIn, fromPos);
        if (fromPos.equals((Object)this.field_174879_c.func_177984_a()) && this.redstoneControl.getState()) {
            this.extractProducts(this.field_174879_c.func_177984_a());
        }
        this.updateActiveState();
    }

    public boolean onActivatedDelegate(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151069_bo && this.outputTank.getAmount() >= 250) {
            this.outputTank.drain(250, IFluidHandler.FluidAction.EXECUTE);
            stack.func_190918_g(1);
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_226638_pX_));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_226638_pX_))) {
                player.func_71019_a(new ItemStack((IItemProvider)Items.field_226638_pX_), false);
            }
            return true;
        }
        return super.onActivatedDelegate(world, pos, state, player, hand, result);
    }

    @Override
    public void onPlacedBy(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlacedBy(worldIn, pos, state, placer, stack);
        if (this.redstoneControl.getState()) {
            this.extractProducts(pos.func_177984_a());
        }
        this.updateActiveState();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceHiveExtractorContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Override
    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        if (this.redstoneControl.getState()) {
            this.extractProducts(this.field_174879_c.func_177984_a());
        }
    }

    @Override
    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        if (this.redstoneControl.getState()) {
            this.extractProducts(this.field_174879_c.func_177984_a());
        }
    }

    @Override
    public void onControlUpdate() {
        this.updateActiveState();
        TileControlPacket.sendToClient((TileCoFH)this);
    }
}

