/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.Utils;
import cofh.core.util.helpers.MathHelper;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceTreeExtractorContainer;
import cofh.thermal.core.tileentity.ThermalTileBase;
import cofh.thermal.core.util.managers.device.TreeExtractorManager;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DeviceTreeExtractorTile
extends ThermalTileBase
implements ITickableTileEntity {
    protected static final int NUM_LEAVES = 3;
    protected static final int TIME_CONSTANT = 500;
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(TreeExtractorManager.instance()::validBoost);
    protected FluidStorageCoFH outputTank = new FluidStorageCoFH(8000);
    private boolean cached;
    private boolean valid;
    private BlockPos trunkPos;
    private final BlockPos[] leafPos = new BlockPos[3];
    private int timeConstant = 500;
    private final int timeOffset = MathHelper.RANDOM.nextInt(500);
    private float boostMult;
    private int boostCycles;

    public DeviceTreeExtractorTile() {
        super(TCoreReferences.DEVICE_TREE_EXTRACTOR_TILE);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.tankInv.addTank(this.outputTank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalConfig.deviceAugments);
        this.initHandlers();
        this.trunkPos = new BlockPos((Vec3i)this.field_174879_c);
        for (int i = 0; i < 3; ++i) {
            this.leafPos[i] = new BlockPos((Vec3i)this.field_174879_c);
        }
    }

    protected void updateValidity() {
        int leafCount;
        Set<BlockState> leafSet;
        if (this.field_145850_b == null || !this.field_145850_b.isAreaLoaded(this.field_174879_c, 1) || Utils.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        this.timeConstant = this.getTimeConstant();
        if (this.valid) {
            if (this.isTrunkBase(this.trunkPos)) {
                leafSet = TreeExtractorManager.instance().getMatchingLeaves(this.field_145850_b.func_180495_p(this.trunkPos));
                leafCount = 0;
                for (int i = 0; i < 3; ++i) {
                    if (!leafSet.contains(this.field_145850_b.func_180495_p(this.leafPos[i]))) continue;
                    ++leafCount;
                }
                if (leafCount >= 3) {
                    Iterable area = BlockPos.func_218278_a((BlockPos)this.trunkPos, (BlockPos)this.trunkPos.func_177982_a(0, this.leafPos[0].func_177956_o() - this.trunkPos.func_177956_o(), 0));
                    for (BlockPos scan : area) {
                        Material material = this.field_145850_b.func_180495_p(scan).func_185904_a();
                        if (material != Material.field_151577_b && material != Material.field_151578_c && material != Material.field_151576_e) continue;
                        this.valid = false;
                        this.cached = true;
                        return;
                    }
                    area = BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(0, 1, 0), (BlockPos)this.field_174879_c.func_177982_a(0, this.leafPos[0].func_177956_o() - this.field_174879_c.func_177956_o(), 0));
                    for (BlockPos scan : area) {
                        if (!this.isTreeExtractor(this.field_145850_b.func_180495_p(scan))) continue;
                        this.valid = false;
                        this.cached = true;
                        return;
                    }
                    this.cached = true;
                    this.renderFluid = TreeExtractorManager.instance().getFluid(this.field_145850_b.func_180495_p(this.trunkPos));
                    return;
                }
            }
            this.valid = false;
        }
        if (this.isTrunkBase(this.field_174879_c.func_177976_e())) {
            this.trunkPos = this.field_174879_c.func_177976_e();
        } else if (this.isTrunkBase(this.field_174879_c.func_177974_f())) {
            this.trunkPos = this.field_174879_c.func_177974_f();
        } else if (this.isTrunkBase(this.field_174879_c.func_177978_c())) {
            this.trunkPos = this.field_174879_c.func_177978_c();
        } else if (this.isTrunkBase(this.field_174879_c.func_177968_d())) {
            this.trunkPos = this.field_174879_c.func_177968_d();
        }
        if (!this.isTrunkBase(this.trunkPos)) {
            this.valid = false;
            this.cached = true;
            return;
        }
        leafSet = TreeExtractorManager.instance().getMatchingLeaves(this.field_145850_b.func_180495_p(this.trunkPos));
        leafCount = 0;
        Iterable area = BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-1, 0, -1), (BlockPos)this.field_174879_c.func_177982_a(1, Math.min(256 - this.field_174879_c.func_177956_o(), 40), 1)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        for (BlockPos scan : area) {
            if (!leafSet.contains(this.field_145850_b.func_180495_p(scan))) continue;
            this.leafPos[leafCount] = new BlockPos((Vec3i)scan);
            if (++leafCount < 3) continue;
            break;
        }
        if (leafCount >= 3) {
            area = BlockPos.func_218278_a((BlockPos)this.trunkPos, (BlockPos)this.trunkPos.func_177982_a(0, this.leafPos[0].func_177956_o() - this.trunkPos.func_177956_o(), 0));
            for (BlockPos scan : area) {
                Material material = this.field_145850_b.func_180495_p(scan).func_185904_a();
                if (material != Material.field_151577_b && material != Material.field_151578_c && material != Material.field_151576_e) continue;
                this.valid = false;
                this.cached = true;
                return;
            }
            area = BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(0, 1, 0), (BlockPos)this.field_174879_c.func_177982_a(0, this.leafPos[0].func_177956_o() - this.field_174879_c.func_177956_o(), 0));
            for (BlockPos scan : area) {
                if (!this.isTreeExtractor(this.field_145850_b.func_180495_p(scan))) continue;
                this.valid = false;
                this.cached = true;
                return;
            }
            this.valid = true;
            this.renderFluid = TreeExtractorManager.instance().getFluid(this.field_145850_b.func_180495_p(this.trunkPos));
        }
        this.cached = true;
    }

    protected void updateActiveState() {
        boolean curActive = this.isActive;
        this.isActive = this.redstoneControl.getState() && this.valid;
        this.updateActiveState(curActive);
    }

    public void func_73660_a() {
        if (!this.timeCheckOffset()) {
            return;
        }
        Fluid curFluid = this.renderFluid.getFluid();
        if (this.isActive && this.valid) {
            if (this.boostCycles > 0) {
                --this.boostCycles;
            } else if (!this.inputSlot.isEmpty()) {
                this.boostMult = TreeExtractorManager.instance().getBoostMultiplier(this.inputSlot.getItemStack());
                this.boostCycles = TreeExtractorManager.instance().getBoostCycles(this.inputSlot.getItemStack());
                this.inputSlot.consume(1);
            } else {
                this.boostMult = 1.0f;
                this.boostCycles = 0;
            }
            this.outputTank.fill(new FluidStack(this.renderFluid, (int)((float)this.renderFluid.getAmount() * this.baseMod * this.boostMult)), IFluidHandler.FluidAction.EXECUTE);
            this.updateValidity();
        }
        if (!this.cached) {
            this.updateValidity();
        }
        if (curFluid != this.renderFluid.getFluid()) {
            TileStatePacket.sendToClient((TileCoFH)this);
        }
        this.updateActiveState();
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(FLUID, (Object)this.renderFluid).build();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceTreeExtractorContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Override
    public int getScaledDuration(int scale) {
        return !this.isActive || this.boostCycles <= 0 ? 0 : scale;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.boostCycles);
        buffer.writeFloat(this.boostMult);
        return buffer;
    }

    @Override
    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.boostCycles = buffer.readInt();
        this.boostMult = buffer.readFloat();
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.boostMult = nbt.func_74760_g("BoostMult");
        this.boostCycles = nbt.func_74762_e("BoostCycles");
        this.timeConstant = nbt.func_74762_e("TimeConstant");
        if (this.timeConstant <= 0) {
            this.timeConstant = 500;
        }
        for (int i = 0; i < 3; ++i) {
            this.leafPos[i] = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Leaf" + i));
        }
        this.trunkPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Trunk"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("BoostMult", this.boostMult);
        nbt.func_74768_a("BoostCycles", this.boostCycles);
        nbt.func_74768_a("TimeConstant", this.timeConstant);
        for (int i = 0; i < 3; ++i) {
            nbt.func_218657_a("Leaf" + i, (INBT)NBTUtil.func_186859_a((BlockPos)this.leafPos[i]));
        }
        nbt.func_218657_a("Trunk", (INBT)NBTUtil.func_186859_a((BlockPos)this.trunkPos));
        return nbt;
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.timeOffset) % (long)this.timeConstant == 0L;
    }

    protected int getTimeConstant() {
        int constant = 250;
        Iterable area = BlockPos.func_218278_a((BlockPos)this.trunkPos.func_177982_a(-1, 0, -1), (BlockPos)this.trunkPos.func_177982_a(1, 0, 1));
        for (BlockPos scan : area) {
            if (!this.isTreeExtractor(this.field_145850_b.func_180495_p(scan))) continue;
            constant += 250;
        }
        return MathHelper.clamp((int)constant, (int)500, (int)1000);
    }

    protected boolean isTrunkBase(BlockPos checkPos) {
        BlockState state = this.field_145850_b.func_180495_p(checkPos.func_177977_b());
        Material material = state.func_185904_a();
        if (material != Material.field_151577_b && material != Material.field_151578_c && material != Material.field_151576_e) {
            return false;
        }
        return TreeExtractorManager.instance().validTrunk(this.field_145850_b.func_180495_p(checkPos)) && TreeExtractorManager.instance().validTrunk(this.field_145850_b.func_180495_p(checkPos.func_177984_a())) && TreeExtractorManager.instance().validTrunk(this.field_145850_b.func_180495_p(checkPos.func_177981_b(2)));
    }

    protected boolean isTreeExtractor(BlockState state) {
        return state.func_177230_c() == this.func_195044_w().func_177230_c();
    }
}

