/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.fluid.FluidStorageInfinite;
import cofh.core.util.StorageGroup;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.tileentity.ThermalTileBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class DeviceWaterGenTile
extends ThermalTileBase {
    protected byte adjWaterSource;
    protected boolean valid;
    protected FluidStorageCoFH tank = new FluidStorageInfinite(16000, e -> false);

    public DeviceWaterGenTile() {
        super(TCoreReferences.DEVICE_WATER_GEN_TILE);
        this.tankInv.addTank(this.tank, StorageGroup.OUTPUT);
    }

    protected void updateValidity() {
        BlockPos[] cardinals;
        if (this.field_145850_b == null || !this.field_145850_b.isAreaLoaded(this.field_174879_c, 1)) {
            return;
        }
        this.adjWaterSource = 0;
        this.valid = false;
        for (BlockPos adj : cardinals = new BlockPos[]{this.field_174879_c.func_177978_c(), this.field_174879_c.func_177968_d(), this.field_174879_c.func_177976_e(), this.field_174879_c.func_177974_f()}) {
            IFluidState state = this.field_145850_b.func_204610_c(adj);
            if (!state.func_206886_c().equals(Fluids.field_204546_a)) continue;
            this.adjWaterSource = (byte)(this.adjWaterSource + 1);
        }
        if (this.adjWaterSource > 1) {
            this.tank.setFluidStack(new FluidStack((Fluid)Fluids.field_204546_a, 500 * this.adjWaterSource));
            this.valid = true;
        } else {
            this.tank.clear();
        }
    }

    protected void updateActiveState() {
        this.updateValidity();
        boolean curActive = this.isActive;
        this.isActive = this.redstoneControl().getState() && this.valid;
        this.updateActiveState(curActive);
    }

    @Override
    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        super.neighborChanged(blockIn, fromPos);
        this.updateActiveState();
    }

    @Override
    public void onPlacedBy(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlacedBy(worldIn, pos, state, placer, stack);
        this.updateActiveState();
    }

    public boolean canOpenGui() {
        return false;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return null;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.tankInv.hasTanks()) {
            return LazyOptional.of(() -> this.isActive ? this.tankInv.getHandler(StorageGroup.OUTPUT) : EmptyHandler.INSTANCE).cast();
        }
        return super.getCapability(cap, side);
    }
}

