/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.loot;

import cofh.core.util.control.IReconfigurableTile;
import cofh.core.util.control.ISecurableTile;
import cofh.core.util.control.ITransferControllableTile;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.tileentity.ThermalTileBase;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class TileNBTSync
extends LootFunction {
    protected TileNBTSync(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        return TileNBTSync.applyToStack(stack, (TileEntity)context.func_216031_c(LootParameters.field_216288_h));
    }

    public static ItemStack applyToStack(ItemStack stack, TileEntity tile) {
        if (tile instanceof ThermalTileBase) {
            ThermalTileBase castedTile = (ThermalTileBase)tile;
            CompoundNBT tag = new CompoundNBT();
            if (((Boolean)ThermalConfig.keepEnergy.get()).booleanValue()) {
                castedTile.getEnergyStorage().write(tag);
            }
            if (((Boolean)ThermalConfig.keepItems.get()).booleanValue()) {
                castedTile.getItemInv().writeSlotsToNBT(tag, 0, castedTile.invSize() - castedTile.augSize());
            }
            if (((Boolean)ThermalConfig.keepAugments.get()).booleanValue() && castedTile.augSize() > 0) {
                castedTile.getItemInv().writeSlotsToNBTUnordered(tag, "Augments", castedTile.invSize() - castedTile.augSize());
            }
            if (((Boolean)ThermalConfig.keepFluids.get()).booleanValue()) {
                castedTile.getTankInv().write(tag);
            }
            if (((Boolean)ThermalConfig.keepRSControl.get()).booleanValue()) {
                castedTile.redstoneControl().write(tag);
            }
            if (((Boolean)ThermalConfig.keepSideConfig.get()).booleanValue() && tile instanceof IReconfigurableTile) {
                ((IReconfigurableTile)tile).reconfigControl().write(tag);
            }
            if (((Boolean)ThermalConfig.keepTransferControl.get()).booleanValue() && tile instanceof ITransferControllableTile) {
                ((ITransferControllableTile)tile).transferControl().write(tag);
            }
            if (((ISecurableTile)tile).hasSecurity()) {
                castedTile.securityControl().write(tag);
            }
            if (!tag.isEmpty()) {
                stack.func_77983_a("BlockEntityTag", (INBT)tag);
            }
        }
        return stack;
    }

    public static LootFunction.Builder<?> builder() {
        return TileNBTSync.func_215860_a(TileNBTSync::new);
    }

    public static class Serializer
    extends LootFunction.Serializer<TileNBTSync> {
        public Serializer() {
            super(new ResourceLocation("thermal:nbt_sync"), TileNBTSync.class);
        }

        public TileNBTSync deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            return new TileNBTSync(conditionsIn);
        }
    }
}

