/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers;

import cofh.core.fluid.FluidStackHolder;
import cofh.core.fluid.IFluidStackAccess;
import cofh.core.inventory.IItemStackAccess;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.core.util.managers.AbstractManager;
import cofh.thermal.core.util.managers.IFuelManager;
import cofh.thermal.core.util.recipes.ThermalFuel;
import cofh.thermal.core.util.recipes.internal.BaseDynamoFuel;
import cofh.thermal.core.util.recipes.internal.IDynamoFuel;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class SingleFluidFuelManager
extends AbstractManager
implements IFuelManager {
    public static final int MIN_ENERGY = 10000;
    public static final int MAX_ENERGY = 200000000;
    public static final int FLUID_FUEL_AMOUNT = 100;
    public static final int ENERGY_FACTOR = 10;
    protected Map<Integer, IDynamoFuel> fuelMap = new Object2ObjectOpenHashMap();

    protected SingleFluidFuelManager(int defaultEnergy) {
        super(defaultEnergy);
    }

    public void addFuel(ThermalFuel recipe) {
        this.addFuel(recipe.getEnergy(), Collections.emptyList(), recipe.getInputFluids());
    }

    public boolean validFuel(FluidStack input) {
        return this.getFuel(input) != null;
    }

    protected void clear() {
        this.fuelMap.clear();
    }

    protected IDynamoFuel getFuel(FluidStack input) {
        return this.getFuel(Collections.emptyList(), Collections.singletonList(new FluidStackHolder(input)));
    }

    protected IDynamoFuel getFuel(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputTanks.isEmpty() || inputTanks.get(0).isEmpty()) {
            return null;
        }
        return this.fuelMap.get(FluidHelper.fluidHashcode((FluidStack)inputTanks.get(0).getFluidStack()));
    }

    public IDynamoFuel addFuel(int energy, List<ItemStack> inputItems, List<FluidStack> inputFluids) {
        if (inputFluids.isEmpty() || energy <= 0) {
            return null;
        }
        FluidStack input = inputFluids.get(0);
        if (input.isEmpty()) {
            return null;
        }
        int amount = input.getAmount();
        if (amount != 100) {
            if (amount != 1000) {
                long normEnergy = energy * 1000 / amount;
                input.setAmount(100);
                energy = (int)normEnergy;
            }
            energy /= 10;
        }
        if (energy < 10000 || energy > 200000000) {
            return null;
        }
        energy = energy * this.getDefaultScale() / 100;
        BaseDynamoFuel fuel = new BaseDynamoFuel(energy, inputItems, inputFluids);
        this.fuelMap.put(FluidHelper.fluidHashcode((FluidStack)input), fuel);
        return fuel;
    }

    @Override
    public IDynamoFuel getFuel(IThermalInventory inventory) {
        return this.getFuel(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IDynamoFuel> getFuelList() {
        return new ArrayList<IDynamoFuel>(this.fuelMap.values());
    }
}

