/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers;

import cofh.core.fluid.IFluidStackAccess;
import cofh.core.inventory.IItemStackAccess;
import cofh.core.inventory.ItemStackHolder;
import cofh.core.util.ComparableItemStack;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.core.util.managers.AbstractManager;
import cofh.thermal.core.util.managers.IRecipeManager;
import cofh.thermal.core.util.recipes.ThermalCatalyst;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.core.util.recipes.internal.BaseMachineCatalyst;
import cofh.thermal.core.util.recipes.internal.IMachineRecipe;
import cofh.thermal.core.util.recipes.internal.IRecipeCatalyst;
import cofh.thermal.core.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class SingleItemRecipeManager
extends AbstractManager
implements IRecipeManager {
    protected Map<ComparableItemStack, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected int maxOutputItems;
    protected int maxOutputFluids;

    protected SingleItemRecipeManager(int defaultEnergy, int maxOutputItems, int maxOutputFluids) {
        super(defaultEnergy);
        this.maxOutputItems = maxOutputItems;
        this.maxOutputFluids = maxOutputFluids;
    }

    public void addRecipe(ThermalRecipe recipe) {
        for (ItemStack recipeInput : recipe.getInputItems().get(0).func_193365_a()) {
            this.addRecipe(recipe.getEnergy(), recipe.getExperience(), recipe.getMinTicks(), Collections.singletonList(recipeInput), recipe.getInputFluids(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
        }
    }

    public boolean validRecipe(ItemStack input) {
        return this.getRecipe(input) != null;
    }

    protected void clear() {
        this.recipeMap.clear();
    }

    protected IMachineRecipe getRecipe(ItemStack input) {
        return this.getRecipe(Collections.singletonList(new ItemStackHolder(input)), Collections.emptyList());
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputSlots.isEmpty() || inputSlots.get(0).isEmpty()) {
            return null;
        }
        return this.recipeMap.get(SingleItemRecipeManager.convert(inputSlots.get(0).getItemStack()));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, int minTicks, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        ItemStack input = inputItems.get(0);
        if (input.func_190926_b()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.func_190926_b()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = energy * this.getDefaultScale() / 100;
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, minTicks, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(SingleItemRecipeManager.convert(input), recipe);
        return recipe;
    }

    @Override
    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    public static abstract class Catalyzed
    extends SingleItemRecipeManager {
        protected Map<ComparableItemStack, IRecipeCatalyst> catalystMap = new Object2ObjectOpenHashMap();

        protected Catalyzed(int defaultEnergy, int maxOutputItems, int maxOutputFluids) {
            super(defaultEnergy, maxOutputItems, maxOutputFluids);
        }

        @Override
        protected void clear() {
            super.clear();
            this.catalystMap.clear();
        }

        public List<ItemStack> getCatalysts() {
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>(this.catalystMap.size());
            this.catalystMap.keySet().forEach(stack -> ret.add(stack.toItemStack()));
            return ret;
        }

        public IRecipeCatalyst getCatalyst(IItemStackAccess input) {
            return this.catalystMap.get(Catalyzed.convert(input.getItemStack()));
        }

        public IRecipeCatalyst getCatalyst(ItemStack input) {
            return this.catalystMap.get(Catalyzed.convert(input));
        }

        public void addCatalyst(ThermalCatalyst catalyst) {
            for (ItemStack ingredient : catalyst.getIngredient().func_193365_a()) {
                this.addCatalyst(ingredient, catalyst.getPrimaryMod(), catalyst.getSecondaryMod(), catalyst.getEnergyMod(), catalyst.getMinChance(), catalyst.getUseChance());
            }
        }

        public IRecipeCatalyst addCatalyst(ItemStack input, float primaryMod, float secondaryMod, float energyMod, float minChance, float useChance) {
            if (input == null || input.func_190926_b()) {
                return null;
            }
            BaseMachineCatalyst catalyst = new BaseMachineCatalyst(primaryMod, secondaryMod, energyMod, minChance, useChance);
            this.catalystMap.put(Catalyzed.convert(input), catalyst);
            return catalyst;
        }

        public boolean validCatalyst(ItemStack input) {
            return this.getCatalyst(input) != null;
        }

        public IRecipeCatalyst removeCatalyst(ItemStack input) {
            return this.catalystMap.remove(Catalyzed.convert(input));
        }
    }
}

